/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.core.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sourceforge.pmd.eclipse.core.IRuleSetManager;
import net.sourceforge.pmd.lang.rule.RuleSet;

public class RuleSetManagerImpl
implements IRuleSetManager {
    private final List<RuleSet> ruleSets = new ArrayList<RuleSet>();
    private final List<RuleSet> defaultRuleSets = new ArrayList<RuleSet>();

    @Override
    public Collection<RuleSet> getRegisteredRuleSets() {
        return this.ruleSets;
    }

    @Override
    public void registerRuleSet(RuleSet ruleSet) {
        this.checkForNull(ruleSet);
        if (!this.ruleSets.contains(ruleSet)) {
            this.ruleSets.add(ruleSet);
        }
    }

    @Override
    public void unregisterRuleSet(RuleSet ruleSet) {
        this.checkForNull(ruleSet);
        this.ruleSets.remove(ruleSet);
    }

    @Override
    public Collection<RuleSet> getDefaultRuleSets() {
        return this.defaultRuleSets;
    }

    @Override
    public void registerDefaultRuleSet(RuleSet ruleSet) {
        this.checkForNull(ruleSet);
        if (!this.defaultRuleSets.contains(ruleSet)) {
            this.defaultRuleSets.add(ruleSet);
        }
    }

    @Override
    public void unregisterDefaultRuleSet(RuleSet ruleSet) {
        this.checkForNull(ruleSet);
        this.defaultRuleSets.remove(ruleSet);
    }

    private void checkForNull(RuleSet ruleSet) {
        if (ruleSet == null) {
            throw new IllegalArgumentException("ruleSet cannot be null");
        }
    }
}

