/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.core.internal;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileModificationUtil {
    private static final Logger LOG = LoggerFactory.getLogger(FileModificationUtil.class);

    private FileModificationUtil() {
    }

    public static long getFileModificationTimestamp(File f) {
        long result = 0L;
        if (f.exists()) {
            try {
                FileTime filesLastMod = Files.getLastModifiedTime(f.toPath(), new LinkOption[0]);
                result = filesLastMod.toMillis();
                LOG.debug("File {} last mod: {}", (Object)f, (Object)result);
            }
            catch (IOException e) {
                LOG.debug("Error while reading file modification timestamp for {}: {}", (Object)f, (Object)e.toString());
            }
        }
        return result;
    }
}

