/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.logging.internal;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class EclipseLogAppender
extends AppenderBase<ILoggingEvent> {
    private final ILog eclipseLog;
    private final String pluginId;

    public EclipseLogAppender(String thePluginId, ILog theEclipseLog) {
        this.pluginId = thePluginId;
        this.eclipseLog = theEclipseLog;
    }

    protected void append(ILoggingEvent eventObject) {
        int statusSeverity = this.convertLevel(eventObject.getLevel());
        Throwable throwable = this.getThrowable(eventObject.getArgumentArray());
        this.eclipseLog.log((IStatus)new Status(statusSeverity, this.pluginId, eventObject.getFormattedMessage(), throwable));
    }

    private Throwable getThrowable(Object[] argumentArray) {
        Object last;
        if (argumentArray != null && argumentArray.length > 0 && (last = argumentArray[argumentArray.length - 1]) instanceof Throwable) {
            return (Throwable)last;
        }
        return null;
    }

    private int convertLevel(Level level) {
        switch (level.levelInt) {
            case 40000: {
                return 4;
            }
            case 30000: {
                return 2;
            }
            case 20000: {
                return 1;
            }
        }
        return 0;
    }
}

