/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.logging.internal;

import java.text.MessageFormat;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JulLoggingHandler
extends Handler {
    public static void install() {
        java.util.logging.Logger julLogger = java.util.logging.Logger.getLogger("net.sourceforge.pmd");
        Handler[] handlerArray = julLogger.getHandlers();
        int n = handlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Handler handler = handlerArray[n2];
            if (handler instanceof JulLoggingHandler) {
                return;
            }
            ++n2;
        }
        julLogger.addHandler(new JulLoggingHandler());
        julLogger.setUseParentHandlers(false);
    }

    public static void uninstall() {
        JulLoggingHandler julLoggingHandler = null;
        java.util.logging.Logger julLogger = java.util.logging.Logger.getLogger("net.sourceforge.pmd");
        Handler[] handlerArray = julLogger.getHandlers();
        int n = handlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Handler handler = handlerArray[n2];
            if (handler instanceof JulLoggingHandler) {
                julLoggingHandler = (JulLoggingHandler)handler;
                break;
            }
            ++n2;
        }
        julLogger.removeHandler(julLoggingHandler);
        julLogger.setUseParentHandlers(true);
    }

    @Override
    public void publish(LogRecord record) {
        Object[] parameters;
        String message;
        if (record == null) {
            return;
        }
        String loggerName = record.getLoggerName();
        if (loggerName == null) {
            loggerName = "net.sourceforge.pmd";
        }
        if ((message = record.getMessage()) == null) {
            message = "";
        }
        if ((parameters = record.getParameters()) != null) {
            message = MessageFormat.format(message, parameters);
        }
        Throwable thrown = record.getThrown();
        int loglevel = record.getLevel().intValue();
        Logger slf4j = LoggerFactory.getLogger((String)loggerName);
        if (loglevel <= Level.FINE.intValue()) {
            slf4j.debug(message, thrown);
        } else if (loglevel <= Level.INFO.intValue()) {
            slf4j.info(message, thrown);
        } else if (loglevel <= Level.WARNING.intValue()) {
            slf4j.warn(message, thrown);
        } else {
            slf4j.error(message, thrown);
        }
    }

    @Override
    public void close() throws SecurityException {
    }

    @Override
    public void flush() {
    }
}

