/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.logging.internal;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.filter.ThresholdFilter;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeBasedTriggeringPolicy;
import ch.qos.logback.core.rolling.TriggeringPolicy;
import ch.qos.logback.core.util.FileSize;
import java.lang.reflect.Method;
import net.sourceforge.pmd.eclipse.logging.internal.EclipseLogAppender;
import net.sourceforge.pmd.eclipse.logging.internal.JulLoggingHandler;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;

public class LogbackConfiguration {
    public static final String ROOT_LOG_ID = "net.sourceforge.pmd";
    private static final String PMD_ECLIPSE_APPENDER_NAME = "PMDEclipseAppender";
    private static final String DEFAULT_PMD_LOG_MAX_FILE_SIZE = "10MB";

    private ILog getLog() {
        return PMDPlugin.getDefault().getLog();
    }

    public void configureLogback() {
        this.unconfigureLogback();
        LoggerContext logbackContext = this.getLogbackContext();
        if (logbackContext == null) {
            this.getLog().log((IStatus)new Status(2, "net.sourceforge.pmd.eclipse.plugin", "Couldn't find logback. PMD logging is not available!"));
            return;
        }
        EclipseLogAppender logbackEclipseAppender = new EclipseLogAppender("net.sourceforge.pmd.eclipse.plugin", this.getLog());
        logbackEclipseAppender.setContext((Context)logbackContext);
        logbackEclipseAppender.setName("net.sourceforge.pmd.eclipse.plugin");
        ThresholdFilter filter = new ThresholdFilter();
        filter.setContext((Context)logbackContext);
        filter.setLevel(Level.INFO.toString());
        filter.start();
        logbackEclipseAppender.addFilter((Filter)filter);
        logbackEclipseAppender.start();
        Logger l = logbackContext.getLogger(ROOT_LOG_ID);
        l.addAppender((Appender)logbackEclipseAppender);
        l.setAdditive(false);
        JulLoggingHandler.install();
    }

    public void unconfigureLogback() {
        LoggerContext logbackContext = this.getLogbackContext();
        if (logbackContext == null) {
            return;
        }
        Logger l = logbackContext.getLogger(ROOT_LOG_ID);
        l.detachAndStopAllAppenders();
        JulLoggingHandler.uninstall();
    }

    private void configureLogs(String logFileName, String logLevel) {
        Method m;
        LoggerContext logbackContext = this.getLogbackContext();
        if (logbackContext == null) {
            return;
        }
        RollingFileAppender appender = new RollingFileAppender();
        appender.setContext((Context)logbackContext);
        appender.setFile(logFileName);
        appender.setName(PMD_ECLIPSE_APPENDER_NAME);
        SizeBasedTriggeringPolicy triggeringPolicy = new SizeBasedTriggeringPolicy();
        triggeringPolicy.setContext((Context)logbackContext);
        Exception firstTry = null;
        try {
            m = triggeringPolicy.getClass().getMethod("setMaxFileSize", String.class);
            m.invoke((Object)triggeringPolicy, DEFAULT_PMD_LOG_MAX_FILE_SIZE);
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
            firstTry = e;
        }
        if (firstTry != null) {
            try {
                m = triggeringPolicy.getClass().getMethod("setMaxFileSize", FileSize.class);
                m.invoke((Object)triggeringPolicy, FileSize.valueOf((String)DEFAULT_PMD_LOG_MAX_FILE_SIZE));
            }
            catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
                System.err.println("WARNING: Unable to configure max file size for SizeBasedTriggeringPolicy.");
                System.err.println("Falling back to default of 10485760 bytes");
                System.err.println("Reported exception on first try:");
                firstTry.printStackTrace();
                System.err.println("Reported exception on second try:");
                e.printStackTrace();
            }
        }
        triggeringPolicy.start();
        appender.setTriggeringPolicy((TriggeringPolicy)triggeringPolicy);
        FixedWindowRollingPolicy rollingPolicy = new FixedWindowRollingPolicy();
        rollingPolicy.setContext((Context)logbackContext);
        rollingPolicy.setFileNamePattern(String.valueOf(logFileName) + ".%i");
        rollingPolicy.setMinIndex(1);
        rollingPolicy.setMaxIndex(1);
        rollingPolicy.setParent((FileAppender)appender);
        rollingPolicy.start();
        appender.setRollingPolicy((RollingPolicy)rollingPolicy);
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setContext((Context)logbackContext);
        encoder.setPattern("%d{yyyy/MM/dd HH:mm:ss.SSS} [%thread] %-5level %logger{36} - %msg%n");
        encoder.start();
        appender.setEncoder((Encoder)encoder);
        ThresholdFilter filter = new ThresholdFilter();
        filter.setContext((Context)logbackContext);
        filter.setLevel(logLevel);
        filter.start();
        appender.addFilter((Filter)filter);
        appender.start();
        Logger rootLogger = logbackContext.getLogger(ROOT_LOG_ID);
        rootLogger.addAppender((Appender)appender);
        rootLogger.setLevel(Level.toLevel((String)logLevel, (Level)Level.INFO));
    }

    public void applyLogPreferences(String logFileName, String logLevel) {
        LoggerContext logbackContext = this.getLogbackContext();
        if (logbackContext == null) {
            return;
        }
        Logger rootLogger = logbackContext.getLogger(ROOT_LOG_ID);
        Appender appender = rootLogger.getAppender(PMD_ECLIPSE_APPENDER_NAME);
        if (appender != null) {
            rootLogger.detachAppender(appender);
            appender.stop();
        }
        this.configureLogs(logFileName, logLevel);
    }

    private LoggerContext getLogbackContext() {
        ILoggerFactory loggerFactory = LoggerFactory.getILoggerFactory();
        int maxTries = 10;
        while (!(loggerFactory instanceof LoggerContext) && maxTries > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return null;
            }
            --maxTries;
            loggerFactory = LoggerFactory.getILoggerFactory();
        }
        if (loggerFactory instanceof LoggerContext) {
            return (LoggerContext)loggerFactory;
        }
        return null;
    }
}

