/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.plugin;

import java.util.HashSet;
import java.util.Set;
import net.sourceforge.pmd.eclipse.runtime.cmd.ReviewCodeCmd;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileChangeReviewer
implements IResourceChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(FileChangeReviewer.class);
    private static boolean autoBuildingHintLogged;

    public void resourceChanged(IResourceChangeEvent event) {
        IWorkspaceDescription workspaceSettings = ResourcesPlugin.getWorkspace().getDescription();
        if (workspaceSettings.isAutoBuilding()) {
            if (!autoBuildingHintLogged) {
                autoBuildingHintLogged = true;
                LOG.info("Not running PMD via FileChangeReviewer, as autoBuilding is enabled for this workspace.");
            }
            return;
        }
        autoBuildingHintLogged = false;
        HashSet<ResourceChange> itemsChanged = new HashSet<ResourceChange>();
        if (event.getType() == 1) {
            this.changed(itemsChanged, event.getDelta(), (IProgressMonitor)new NullProgressMonitor());
        }
        if (itemsChanged.isEmpty()) {
            return;
        }
        ReviewCodeCmd cmd = new ReviewCodeCmd();
        cmd.reset();
        for (ResourceChange chg : itemsChanged) {
            cmd.addResource((IResource)chg.file);
        }
        try {
            cmd.performExecute();
        }
        catch (RuntimeException e) {
            LOG.error("Error processing code review upon file changes: {}", (Object)e.toString(), (Object)e);
        }
    }

    private void changed(Set<ResourceChange> itemsChanged, IResourceDelta delta, IProgressMonitor monitor) {
        IResource rsc = delta.getResource();
        int flags = delta.getFlags();
        switch (delta.getKind()) {
            case 0: {
                return;
            }
            case 2: {
                IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
                int n = iResourceDeltaArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResourceDelta grandkidDelta = iResourceDeltaArray[n2];
                    if (monitor.isCanceled()) {
                        return;
                    }
                    this.changed(itemsChanged, grandkidDelta, monitor);
                    ++n2;
                }
                break;
            }
            case 1: {
                if (rsc instanceof IFile) {
                    this.added(itemsChanged, (IFile)rsc, flags);
                }
                IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
                int n = iResourceDeltaArray.length;
                int n3 = 0;
                while (n3 < n) {
                    IResourceDelta grandkidDelta = iResourceDeltaArray[n3];
                    if (monitor.isCanceled()) {
                        return;
                    }
                    this.changed(itemsChanged, grandkidDelta, monitor);
                    ++n3;
                }
                break;
            }
            case 4: {
                if (rsc instanceof IFile) {
                    this.changed(itemsChanged, (IFile)rsc, flags);
                }
                IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
                int n = iResourceDeltaArray.length;
                int n4 = 0;
                while (n4 < n) {
                    IResourceDelta grandkidDelta = iResourceDeltaArray[n4];
                    if (monitor.isCanceled()) {
                        return;
                    }
                    this.changed(itemsChanged, grandkidDelta, monitor);
                    ++n4;
                }
                break;
            }
            default: {
                IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
                int n = iResourceDeltaArray.length;
                int n5 = 0;
                while (n5 < n) {
                    IResourceDelta grandkidDelta = iResourceDeltaArray[n5];
                    if (monitor.isCanceled()) {
                        return;
                    }
                    this.changed(itemsChanged, grandkidDelta, monitor);
                    ++n5;
                }
                break block0;
            }
        }
    }

    private void changed(Set<ResourceChange> itemsChanged, IFile rsc, int flags) {
        if ((flags & 0x100) > 0) {
            itemsChanged.add(new ResourceChange(ChangeType.CHANGED, rsc, flags));
        }
    }

    private void added(Set<ResourceChange> itemsChanged, IFile rsc, int flags) {
        itemsChanged.add(new ResourceChange(ChangeType.ADDED, rsc, flags));
    }

    private static enum ChangeType {
        ADDED,
        REMOVED,
        CHANGED;

    }

    private final class ResourceChange {
        public final ChangeType resourceDeltaType;
        public final int flags;
        public final IFile file;

        private ResourceChange(ChangeType type, IFile theFile, int theFlags) {
            this.resourceDeltaType = type;
            this.file = theFile;
            this.flags = theFlags;
        }

        public int hashCode() {
            return this.resourceDeltaType.hashCode() + 13 + this.file.hashCode() + this.flags;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (other.getClass() == this.getClass()) {
                ResourceChange chg = (ResourceChange)other;
                return chg.file.equals((Object)this.file) && this.resourceDeltaType == chg.resourceDeltaType && this.flags == chg.flags;
            }
            return false;
        }
    }
}

