/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.sourceforge.pmd.eclipse.core.IRuleSetManager;
import net.sourceforge.pmd.eclipse.core.ext.RuleSetsExtensionProcessor;
import net.sourceforge.pmd.eclipse.core.impl.RuleSetManagerImpl;
import net.sourceforge.pmd.eclipse.logging.internal.LogbackConfiguration;
import net.sourceforge.pmd.eclipse.plugin.FileChangeReviewer;
import net.sourceforge.pmd.eclipse.runtime.preferences.IPreferences;
import net.sourceforge.pmd.eclipse.runtime.preferences.IPreferencesFactory;
import net.sourceforge.pmd.eclipse.runtime.preferences.IPreferencesManager;
import net.sourceforge.pmd.eclipse.runtime.preferences.impl.PreferencesFactoryImpl;
import net.sourceforge.pmd.eclipse.runtime.properties.IProjectProperties;
import net.sourceforge.pmd.eclipse.runtime.properties.IProjectPropertiesManager;
import net.sourceforge.pmd.eclipse.runtime.properties.IPropertiesFactory;
import net.sourceforge.pmd.eclipse.runtime.properties.PropertiesException;
import net.sourceforge.pmd.eclipse.runtime.properties.impl.PropertiesFactoryImpl;
import net.sourceforge.pmd.eclipse.runtime.writer.IAstWriter;
import net.sourceforge.pmd.eclipse.runtime.writer.IRuleSetWriter;
import net.sourceforge.pmd.eclipse.runtime.writer.impl.WriterFactoryImpl;
import net.sourceforge.pmd.eclipse.ui.RuleLabelDecorator;
import net.sourceforge.pmd.eclipse.ui.actions.RuleSetUtil;
import net.sourceforge.pmd.eclipse.ui.actions.internal.InternalRuleSetUtil;
import net.sourceforge.pmd.eclipse.ui.nls.StringTable;
import net.sourceforge.pmd.eclipse.ui.priority.PriorityDescriptorCache;
import net.sourceforge.pmd.eclipse.ui.views.PriorityFilter;
import net.sourceforge.pmd.eclipse.util.ResourceManager;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.java.JavaLanguageModule;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.lang.rule.RuleReference;
import net.sourceforge.pmd.lang.rule.RuleSet;
import net.sourceforge.pmd.lang.rule.RuleSetLoadException;
import net.sourceforge.pmd.lang.rule.RuleSetLoader;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PMDPlugin
extends AbstractUIPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(PMDPlugin.class);
    private static Map<IProject, IJavaProject> javaProjectsByIProject = new HashMap<IProject, IJavaProject>();
    private static PMDPlugin plugin;
    public static final String PLUGIN_ID = "net.sourceforge.pmd.eclipse.plugin";
    public static final String VIOLATIONS_OVERVIEW_ID = "net.sourceforge.pmd.eclipse.ui.views.violationOverview";
    public static final String VIOLATIONS_OUTLINE_ID = "net.sourceforge.pmd.eclipse.ui.views.violationOutline";
    public static String version;
    private FileChangeReviewer changeReviewer;
    private Map<RGB, Color> coloursByRgb = new HashMap<RGB, Color>();
    private StringTable stringTable;
    private IPreferencesFactory preferencesFactory = new PreferencesFactoryImpl();
    private IPropertiesFactory propertiesFactory = new PropertiesFactoryImpl();
    private final IRuleSetManager ruleSetManager = new RuleSetManagerImpl();
    private final LogbackConfiguration logbackConfiguration = new LogbackConfiguration();

    static {
        version = "unknown";
    }

    public PMDPlugin() {
        plugin = this;
    }

    public Color colorFor(RGB rgb) {
        Color color = this.coloursByRgb.get(rgb);
        if (color != null) {
            return color;
        }
        color = new Color(null, rgb.red, rgb.green, rgb.blue);
        this.coloursByRgb.put(rgb, color);
        return color;
    }

    public static LanguageVersion javaVersionFor(IProject project) {
        IJavaProject jProject = javaProjectsByIProject.get(project);
        if (jProject == null) {
            jProject = JavaCore.create((IProject)project);
            javaProjectsByIProject.put(project, jProject);
        }
        if (jProject.exists()) {
            String compilerCompliance = jProject.getOption("org.eclipse.jdt.core.compiler.compliance", true);
            return JavaLanguageModule.getInstance().getVersion(compilerCompliance);
        }
        return null;
    }

    public static IClasspathEntry buildSourceClassPathEntryFor(IProject project) {
        IJavaProject jProject = javaProjectsByIProject.get(project);
        if (jProject == null) {
            jProject = JavaCore.create((IProject)project);
            javaProjectsByIProject.put(project, jProject);
        }
        if (jProject.exists()) {
            try {
                if (jProject.getRawClasspath() != null) {
                    IClasspathEntry[] iClasspathEntryArray = jProject.getRawClasspath();
                    int n = iClasspathEntryArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IClasspathEntry entry = iClasspathEntryArray[n2];
                        if (entry.getEntryKind() == 3) {
                            return entry;
                        }
                        ++n2;
                    }
                }
            }
            catch (JavaModelException e) {
                LOG.error("Couldn't determine source classpath", (Throwable)e);
            }
        }
        return null;
    }

    private void disposeResources() {
        PMDPlugin.disposeAll(this.coloursByRgb.values());
    }

    public static void disposeAll(Collection<Color> colors) {
        for (Color color : colors) {
            color.dispose();
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.logbackConfiguration.configureLogback();
        this.registerStandardRuleSets();
        IPreferences prefs = this.loadPreferences();
        this.logbackConfiguration.applyLogPreferences(prefs.getLogFileName(), prefs.getLogLevelName());
        this.registerAdditionalRuleSets();
        this.fileChangeListenerEnabled(prefs.isCheckAfterSaveEnabled());
        ResourcesPlugin.getWorkspace().addResourceChangeListener(new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent arg0) {
                if (arg0.getType() == 4 && arg0.getResource() instanceof IProject) {
                    PMDPlugin.this.getPropertiesManager().removeProjectProperties((IProject)arg0.getResource());
                }
            }
        });
        PriorityFilter.getInstance().initialize();
        version = (String)context.getBundle().getHeaders().get("Bundle-Version");
        LOG.debug("PMD Plugin {} has started...", (Object)version);
    }

    public void showView(final String viewId) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(viewId);
                }
                catch (PartInitException e) {
                    LOG.error("Error while showing {}", (Object)viewId, (Object)e);
                }
            }
        });
    }

    public void fileChangeListenerEnabled(boolean flag) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (flag) {
            if (this.changeReviewer == null) {
                this.changeReviewer = new FileChangeReviewer();
            }
            workspace.addResourceChangeListener((IResourceChangeListener)this.changeReviewer);
        } else if (this.changeReviewer != null) {
            workspace.removeResourceChangeListener((IResourceChangeListener)this.changeReviewer);
            this.changeReviewer = null;
        }
    }

    public static IViewPart getView(String id) {
        IViewReference[] viewReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getViewReferences();
        int i = 0;
        while (i < viewReferences.length) {
            if (id.equals(viewReferences[i].getId())) {
                return viewReferences[i].getView(false);
            }
            ++i;
        }
        return null;
    }

    public void refreshView(final String viewId) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IViewReference[] views;
                    IViewPart view = PMDPlugin.getView(viewId);
                    if (view == null) {
                        return;
                    }
                    boolean found = false;
                    IViewReference[] iViewReferenceArray = views = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getViewReferences();
                    int n = views.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IViewReference viewRef = iViewReferenceArray[n2];
                        if (viewRef.getTitle().equals(view.getTitle())) {
                            found = true;
                        }
                        ++n2;
                    }
                    if (!found) {
                        return;
                    }
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().hideView(view);
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(viewId);
                }
                catch (PartInitException e) {
                    LOG.error("Error while refreshing view {}", (Object)viewId, (Object)e);
                }
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        this.fileChangeListenerEnabled(false);
        this.disposeResources();
        ResourceManager.dispose();
        PriorityDescriptorCache.INSTANCE.dispose();
        this.logbackConfiguration.unconfigureLogback();
        plugin = null;
        super.stop(context);
    }

    public static PMDPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public Image getImage(String key, String iconPath) {
        ImageDescriptor descriptor;
        ImageRegistry registry = this.getImageRegistry();
        Image image = registry.get(key);
        if (image == null && (descriptor = PMDPlugin.getImageDescriptor(iconPath)) != null) {
            registry.put(key, descriptor);
            image = registry.get(key);
        }
        return image;
    }

    public void logError(String message, Throwable t) {
        this.getLog().log((IStatus)new Status(4, this.getBundle().getSymbolicName(), 0, String.valueOf(message) + t.getMessage(), t));
        if (LOG != null) {
            LOG.error(message, t);
        }
    }

    public void logError(IStatus status) {
        this.getLog().log(status);
        if (LOG != null) {
            LOG.error(status.getMessage(), status.getException());
        }
    }

    public void showError(final String message, final Throwable t) {
        this.logError(message, t);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                String errTitle = PMDPlugin.this.getStringTable().getString("message.error.title");
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)errTitle, (String)(String.valueOf(message) + "\n" + String.valueOf(t)));
            }
        });
    }

    public void showUserError(final String message) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                String errTitle = PMDPlugin.this.getStringTable().getString("message.error.title");
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)errTitle, (String)message);
            }
        });
    }

    public StringTable getStringTable() {
        if (this.stringTable == null) {
            this.stringTable = new StringTable();
        }
        return this.stringTable;
    }

    public IPreferences loadPreferences() {
        return this.getPreferencesManager().loadPreferences();
    }

    public IPreferencesManager getPreferencesManager() {
        return this.preferencesFactory.getPreferencesManager();
    }

    public IProjectPropertiesManager getPropertiesManager() {
        return this.propertiesFactory.getProjectPropertiesManager();
    }

    public IProjectProperties loadProjectProperties(IProject project) throws PropertiesException {
        return this.getPropertiesManager().loadProjectProperties(project);
    }

    public void logInformation(String message) {
        this.getLog().log((IStatus)new Status(1, this.getBundle().getSymbolicName(), 0, message, null));
    }

    public void logWarn(String message) {
        this.getLog().log((IStatus)new Status(2, this.getBundle().getSymbolicName(), 0, message, null));
    }

    public IAstWriter getAstWriter() {
        return new WriterFactoryImpl().getAstWriter();
    }

    public IRuleSetWriter getRuleSetWriter() {
        return new WriterFactoryImpl().getRuleSetWriter();
    }

    public void applyLogPreferences(IPreferences preferences) {
        this.logbackConfiguration.applyLogPreferences(preferences.getLogFileName(), preferences.getLogLevelName());
    }

    public final IRuleSetManager getRuleSetManager() {
        return this.ruleSetManager;
    }

    public final void log(int severity, String message, Throwable t) {
        Bundle bundle = this.getBundle();
        if (bundle != null) {
            this.getLog().log((IStatus)new Status(severity, bundle.getSymbolicName(), 0, message, t));
        }
    }

    private void registerStandardRuleSets() {
        RuleSetLoader loader = InternalRuleSetUtil.getDefaultRuleSetLoader();
        try {
            IRuleSetManager manager = this.getRuleSetManager();
            for (RuleSet ruleset : loader.getStandardRuleSets()) {
                RuleSet modifiedRuleSet = this.removeDeprecatedRuleReferences(ruleset);
                manager.registerRuleSet(modifiedRuleSet);
                manager.registerDefaultRuleSet(modifiedRuleSet);
            }
        }
        catch (RuleSetLoadException e) {
            this.log(2, "Problem getting all registered PMD RuleSets", e);
        }
    }

    private RuleSet removeDeprecatedRuleReferences(RuleSet ruleSet) {
        ArrayList<Rule> rules = new ArrayList<Rule>(ruleSet.getRules());
        Iterator it = rules.iterator();
        while (it.hasNext()) {
            Rule rule = (Rule)it.next();
            if (!rule.isDeprecated() || !(rule instanceof RuleReference)) continue;
            LOG.debug("Removed deprecated rule reference {} from ruleset {}", (Object)rule.getName(), (Object)ruleSet.getName());
            it.remove();
        }
        RuleSet result = RuleSetUtil.clearRules(ruleSet);
        result = RuleSetUtil.addRules(result, rules);
        return result;
    }

    private void registerAdditionalRuleSets() {
        try {
            RuleSetsExtensionProcessor processor = new RuleSetsExtensionProcessor(this.getRuleSetManager());
            processor.process();
        }
        catch (CoreException e) {
            this.log(4, "Error when processing RuleSets extensions", e);
        }
    }

    public RuleLabelDecorator ruleLabelDecorator() {
        IDecoratorManager mgr = PlatformUI.getWorkbench().getDecoratorManager();
        return (RuleLabelDecorator)mgr.getBaseLabelProvider("net.sourceforge.pmd.eclipse.plugin.RuleLabelDecorator");
    }

    public void changedFiles(Collection<IFile> changedFiles) {
        RuleLabelDecorator rld = this.ruleLabelDecorator();
        if (rld == null) {
            return;
        }
        HashSet<IResource> withParents = new HashSet<IResource>(changedFiles.size() * 2);
        withParents.addAll(changedFiles);
        for (IFile file : changedFiles) {
            IContainer parent = file.getParent();
            while (parent != null) {
                withParents.add((IResource)parent);
                parent = parent.getParent();
            }
        }
        rld.changed(withParents);
    }

    private void addFilesTo(IResource resource, Collection<IResource> allKids) {
        if (resource instanceof IFile) {
            allKids.add(resource);
            return;
        }
        if (resource instanceof IFolder) {
            IFolder folder = (IFolder)resource;
            IResource[] kids = null;
            try {
                kids = folder.members();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            this.addKids(allKids, kids);
            allKids.add((IResource)folder);
            return;
        }
        if (resource instanceof IProject) {
            IProject project = (IProject)resource;
            IResource[] kids = null;
            try {
                kids = project.members();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            this.addKids(allKids, kids);
            allKids.add((IResource)project);
        }
    }

    private void addKids(Collection<IResource> allKids, IResource[] kids) {
        if (kids == null) {
            return;
        }
        IResource[] iResourceArray = kids;
        int n = kids.length;
        int n2 = 0;
        while (n2 < n) {
            IResource irc = iResourceArray[n2];
            if (irc instanceof IFile) {
                allKids.add(irc);
            } else if (irc instanceof IFolder) {
                this.addFilesTo(irc, allKids);
            }
            ++n2;
        }
    }

    public void removedMarkersIn(IResource resource) {
        RuleLabelDecorator decorator = this.ruleLabelDecorator();
        if (decorator == null) {
            return;
        }
        ArrayList<IResource> changes = new ArrayList<IResource>();
        this.addFilesTo(resource, changes);
        decorator.changed(changes);
    }
}

