/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.preferences.IPreferencesManager;
import net.sourceforge.pmd.eclipse.ui.Shape;
import net.sourceforge.pmd.eclipse.ui.ShapeDescriptor;
import net.sourceforge.pmd.eclipse.ui.priority.PriorityDescriptorCache;
import net.sourceforge.pmd.eclipse.util.FontBuilder;
import net.sourceforge.pmd.lang.rule.RulePriority;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.graphics.RGB;

public final class UISettings {
    public static final FontBuilder CODE_FONT_BUILDER = new FontBuilder("Courier", 11, 0);
    private static Map<RulePriority, String> labelsByPriority = new HashMap<RulePriority, String>();
    private static IPreferencesManager preferencesManager = PMDPlugin.getDefault().getPreferencesManager();

    private UISettings() {
    }

    public static Shape[] allShapes() {
        return new Shape[]{Shape.circle, Shape.star, Shape.domeLeft, Shape.domeRight, Shape.diamond, Shape.square, Shape.roundedRect, Shape.minus, Shape.pipe, Shape.plus, Shape.triangleUp, Shape.triangleDown, Shape.triangleRight, Shape.triangleLeft, Shape.triangleNorthEast, Shape.triangleSouthEast, Shape.triangleSouthWest, Shape.triangleNorthWest};
    }

    public static RulePriority[] currentPriorities(boolean sortAscending) {
        RulePriority[] priorities = RulePriority.values();
        Arrays.sort(priorities, new Comparator<RulePriority>(){

            @Override
            public int compare(RulePriority rpA, RulePriority rbB) {
                return rpA.getPriority() - rbB.getPriority();
            }
        });
        return priorities;
    }

    public static Map<Shape, ShapeDescriptor> shapeSet(RGB color, int size) {
        HashMap<Shape, ShapeDescriptor> shapes = new HashMap<Shape, ShapeDescriptor>();
        for (Shape shape : EnumSet.allOf(Shape.class)) {
            shapes.put(shape, new ShapeDescriptor(shape, color, size));
        }
        return shapes;
    }

    private static String pLabelFor(RulePriority priority, boolean useCustom) {
        if (!useCustom) {
            return priority.getName();
        }
        String custom = PriorityDescriptorCache.INSTANCE.descriptorFor((RulePriority)priority).label;
        return StringUtils.isBlank((CharSequence)custom) ? UISettings.preferencesManager.defaultDescriptorFor((RulePriority)priority).label : custom;
    }

    public static void useCustomPriorityLabels(boolean flag) {
        labelsByPriority.clear();
        RulePriority[] rulePriorityArray = UISettings.currentPriorities(true);
        int n = rulePriorityArray.length;
        int n2 = 0;
        while (n2 < n) {
            RulePriority priority = rulePriorityArray[n2];
            labelsByPriority.put(priority, UISettings.pLabelFor(priority, flag));
            ++n2;
        }
    }

    public static String labelFor(RulePriority priority) {
        if (labelsByPriority.isEmpty()) {
            UISettings.useCustomPriorityLabels(preferencesManager.loadPreferences().useCustomPriorityNames());
        }
        return labelsByPriority.get(priority);
    }

    public static Map<Object, ShapeDescriptor> shapesByPriority() {
        HashMap<Object, ShapeDescriptor> shapesByPriority = new HashMap<Object, ShapeDescriptor>(RulePriority.values().length);
        RulePriority[] rulePriorityArray = RulePriority.values();
        int n = rulePriorityArray.length;
        int n2 = 0;
        while (n2 < n) {
            RulePriority priority = rulePriorityArray[n2];
            shapesByPriority.put(priority, PriorityDescriptorCache.INSTANCE.descriptorFor((RulePriority)priority).shape);
            ++n2;
        }
        return shapesByPriority;
    }

    public static List<Integer> getPriorityIntValues() {
        ArrayList<Integer> values = new ArrayList<Integer>();
        RulePriority[] rulePriorityArray = RulePriority.values();
        int n = rulePriorityArray.length;
        int n2 = 0;
        while (n2 < n) {
            RulePriority priority = rulePriorityArray[n2];
            values.add(priority.getPriority());
            ++n2;
        }
        return values;
    }
}

