/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.runtime.builder;

import java.util.Map;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.builder.MarkerUtil;
import net.sourceforge.pmd.eclipse.runtime.cmd.ReviewCodeCmd;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PMDBuilder
extends IncrementalProjectBuilder {
    public static final Logger LOG = LoggerFactory.getLogger(PMDBuilder.class);
    public static final String PMD_BUILDER = "net.sourceforge.pmd.eclipse.plugin.pmdBuilder";
    public static final IProject[] EMPTY_PROJECT_ARRAY = new IProject[0];

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        IProject currentProject = this.getProject();
        LOG.debug("Incremental builder activated for {}", (Object)currentProject);
        try {
            if (kind == 9) {
                LOG.debug("Auto build requested.");
                this.buildIncremental(currentProject, monitor);
            } else if (kind == 6) {
                LOG.debug("Full build requested.");
                this.buildFull(currentProject, monitor);
            } else if (kind == 10) {
                LOG.debug("Incremental build requested.");
                this.buildIncremental(currentProject, monitor);
            } else {
                LOG.warn("Ignoring IncrementalBuilder request of kind {} for {} - not supported", (Object)kind, (Object)currentProject);
            }
        }
        catch (RuntimeException e) {
            throw new CoreException((IStatus)new Status(4, PMDPlugin.getDefault().getBundle().getSymbolicName(), 0, e.getMessage(), (Throwable)e));
        }
        return EMPTY_PROJECT_ARRAY;
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        MarkerUtil.deleteAllMarkersIn((IResource)this.getProject());
    }

    private void buildFull(IProject project, IProgressMonitor monitor) {
        this.processProjectFiles(project, monitor);
    }

    private void buildIncremental(IProject project, IProgressMonitor monitor) {
        if (!PMDPlugin.getDefault().loadPreferences().isCheckAfterSaveEnabled()) {
            return;
        }
        IResourceDelta resourceDelta = this.getDelta(project);
        if (resourceDelta != null && resourceDelta.getAffectedChildren().length != 0) {
            ReviewCodeCmd cmd = new ReviewCodeCmd();
            cmd.setResourceDelta(resourceDelta);
            cmd.setMonitor(monitor);
            cmd.performExecute();
        } else {
            LOG.debug("No change reported. Performing no build");
        }
    }

    private void processProjectFiles(IProject project, IProgressMonitor monitor) {
        ReviewCodeCmd cmd = new ReviewCodeCmd();
        cmd.addResource((IResource)project);
        cmd.setMonitor(monitor);
        cmd.performExecute();
    }
}

