/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.runtime.builder;

import net.sourceforge.pmd.eclipse.runtime.builder.MarkerUtil;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class PMDNature
implements IProjectNature {
    public static final String PMD_NATURE = "net.sourceforge.pmd.eclipse.plugin.pmdNature";
    private IProject project;

    public void configure() throws CoreException {
        IProjectDescription description = this.project.getDescription();
        ICommand[] commands = description.getBuildSpec();
        if (!this.pmdBuilderFound(commands)) {
            ICommand pmdBuilderCommand = description.newCommand();
            pmdBuilderCommand.setBuilderName("net.sourceforge.pmd.eclipse.plugin.pmdBuilder");
            ICommand[] newCommands = new ICommand[commands.length + 1];
            System.arraycopy(commands, 0, newCommands, 0, commands.length);
            newCommands[commands.length] = pmdBuilderCommand;
            description.setBuildSpec(newCommands);
            this.project.setDescription(description, null);
        }
    }

    public void deconfigure() throws CoreException {
        IProjectDescription description = this.project.getDescription();
        ICommand[] commands = description.getBuildSpec();
        if (this.pmdBuilderFound(commands)) {
            ICommand[] newCommands = new ICommand[commands.length - 1];
            int i = 0;
            int j = 0;
            while (i < commands.length) {
                if (!"net.sourceforge.pmd.eclipse.plugin.pmdBuilder".equals(commands[i].getBuilderName())) {
                    newCommands[j++] = commands[i];
                }
                ++i;
            }
            description.setBuildSpec(newCommands);
            this.project.setDescription(description, null);
        }
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject theProject) {
        this.project = theProject;
    }

    public static boolean addPMDNature(IProject project, IProgressMonitor monitor) throws CoreException {
        boolean success = false;
        if (!project.hasNature(PMD_NATURE)) {
            IProjectDescription description = project.getDescription();
            String[] natureIds = description.getNatureIds();
            String[] newNatureIds = new String[natureIds.length + 1];
            System.arraycopy(natureIds, 0, newNatureIds, 0, natureIds.length);
            newNatureIds[natureIds.length] = PMD_NATURE;
            description.setNatureIds(newNatureIds);
            project.setDescription(description, monitor);
            success = true;
        }
        return success;
    }

    public static boolean removePMDNature(IProject project, IProgressMonitor monitor) throws CoreException {
        boolean success = false;
        if (project.hasNature(PMD_NATURE)) {
            IProjectDescription description = project.getDescription();
            String[] natureIds = description.getNatureIds();
            String[] newNatureIds = new String[natureIds.length - 1];
            int i = 0;
            int j = 0;
            while (i < natureIds.length) {
                if (!PMD_NATURE.equals(natureIds[i])) {
                    newNatureIds[j++] = natureIds[i];
                }
                ++i;
            }
            description.setNatureIds(newNatureIds);
            project.setDescription(description, monitor);
            MarkerUtil.deleteAllMarkersIn((IResource)project);
        }
        return success;
    }

    private boolean pmdBuilderFound(ICommand[] commands) {
        ICommand[] iCommandArray = commands;
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand command = iCommandArray[n2];
            if ("net.sourceforge.pmd.eclipse.plugin.pmdBuilder".equals(command.getBuilderName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

