/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.runtime.cmd;

import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.cmd.JobCommandProcessor;
import net.sourceforge.pmd.lang.Language;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class AbstractDefaultCommand {
    private boolean readOnly;
    private boolean outputProperties;
    private boolean readyToExecute;
    private final String description;
    private final String name;
    private IProgressMonitor monitor;
    private int stepCount;
    private boolean userInitiated;
    private boolean terminated;

    protected AbstractDefaultCommand(String theName, String theDescription) {
        this.name = theName;
        this.description = theDescription;
    }

    public static void logInfo(String message) {
        PMDPlugin.getDefault().logInformation(message);
    }

    public static void logError(String message, Throwable error) {
        PMDPlugin.getDefault().logError(message, error);
    }

    public static boolean isLanguageFile(IFile file, Language language) {
        return file != null && language.hasExtension(file.getFileExtension());
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public void setOutputProperties(boolean outputProperties) {
        this.outputProperties = outputProperties;
    }

    public boolean hasOutputProperties() {
        return this.outputProperties;
    }

    public boolean isReadyToExecute() {
        return this.readyToExecute;
    }

    public void setReadyToExecute(boolean readyToExecute) {
        this.readyToExecute = readyToExecute;
    }

    public int getStepCount() {
        return this.stepCount;
    }

    public void setStepCount(int stepCount) {
        this.stepCount = stepCount;
    }

    public boolean isUserInitiated() {
        return this.userInitiated;
    }

    public void setUserInitiated(boolean userInitiated) {
        this.userInitiated = userInitiated;
    }

    public IProgressMonitor getMonitor() {
        return this.monitor;
    }

    public void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public abstract void execute();

    public abstract void reset();

    protected void beginTask(String name, int totalWork) {
        if (this.monitor != null) {
            this.monitor.beginTask(name, totalWork);
        }
    }

    protected void done() {
        if (this.monitor != null) {
            this.monitor.done();
        }
        this.setTerminated(true);
    }

    protected void setTerminated(boolean terminated) {
        this.terminated = terminated;
    }

    protected boolean isTerminated() {
        return this.terminated;
    }

    protected boolean isCanceled() {
        return this.monitor != null && this.monitor.isCanceled();
    }

    protected void setTaskName(String name) {
        if (this.monitor != null) {
            this.monitor.setTaskName(name);
        }
    }

    protected void subTask(String name) {
        if (this.monitor != null) {
            this.monitor.subTask(name);
        }
    }

    protected void worked(int work) {
        if (this.monitor != null) {
            this.monitor.worked(work);
        }
    }

    public final void performExecute() {
        JobCommandProcessor.getInstance().processCommand(this);
    }

    public final void join() {
        JobCommandProcessor.getInstance().waitCommandToFinish(this);
    }
}

