/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.runtime.cmd;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.PmdAnalysis;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.cmd.MarkerInfo2;
import net.sourceforge.pmd.eclipse.runtime.properties.IProjectProperties;
import net.sourceforge.pmd.eclipse.runtime.properties.PropertiesException;
import net.sourceforge.pmd.eclipse.util.internal.IOUtil;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.LanguageVersionDiscoverer;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.java.JavaLanguageModule;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.lang.rule.RuleSet;
import net.sourceforge.pmd.reporting.Report;
import net.sourceforge.pmd.reporting.RuleViolation;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.ResourceWorkingSetFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(BaseVisitor.class);
    private IProgressMonitor monitor;
    private Map<IFile, Set<MarkerInfo2>> accumulator;
    private List<RuleSet> ruleSets;
    private Set<String> fileExtensions;
    private int fileCount;
    private long pmdDuration;
    private IProjectProperties projectProperties;
    private PMDConfiguration configuration;

    protected BaseVisitor() {
    }

    protected PMDConfiguration configuration() {
        if (this.configuration == null) {
            this.configuration = new PMDConfiguration();
        }
        return this.configuration;
    }

    public Map<IFile, Set<MarkerInfo2>> getAccumulator() {
        return this.accumulator;
    }

    public void setAccumulator(Map<IFile, Set<MarkerInfo2>> accumulator) {
        this.accumulator = accumulator;
    }

    public IProgressMonitor getMonitor() {
        return this.monitor;
    }

    public void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public boolean isCanceled() {
        return this.getMonitor() != null && this.getMonitor().isCanceled();
    }

    public void subTask(String name) {
        if (this.getMonitor() != null) {
            this.getMonitor().subTask(name);
        }
    }

    public void worked(int work) {
        if (this.getMonitor() != null) {
            this.getMonitor().worked(work);
        }
    }

    public List<RuleSet> getRuleSetList() {
        return this.ruleSets;
    }

    public RuleSet getRuleSet() {
        return this.ruleSets.get(0);
    }

    public void setRuleSet(RuleSet ruleSet) {
        this.ruleSets = new ArrayList<RuleSet>();
        this.ruleSets.add(ruleSet);
    }

    public void setRuleSetList(List<RuleSet> ruleSets) {
        this.ruleSets = ruleSets;
    }

    public void setFileExtensions(Set<String> fileExtensions) {
        this.fileExtensions = fileExtensions;
    }

    public int getProcessedFilesCount() {
        return this.fileCount;
    }

    public long getActualPmdDuration() {
        return this.pmdDuration;
    }

    public void setProjectProperties(IProjectProperties projectProperties) {
        this.projectProperties = projectProperties;
    }

    private boolean isIncluded(IFile file) throws PropertiesException {
        return this.projectProperties.isIncludeDerivedFiles() || !this.projectProperties.isIncludeDerivedFiles() && !file.isDerived();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void reviewResource(IResource resource) {
        if (this.isCanceled()) {
            return;
        }
        IFile file = (IFile)resource.getAdapter(IFile.class);
        if (file == null) return;
        if (file.getFileExtension() == null) {
            return;
        }
        if (PMDPlugin.getDefault().loadPreferences().isDetermineFiletypesAutomatically()) {
            if (this.fileExtensions != null) {
                if (!this.fileExtensions.contains(file.getFileExtension().toLowerCase(Locale.ROOT))) {
                    LOG.debug("Skipping file {} based on file extension", (Object)file);
                    return;
                }
            } else {
                LOG.warn("Can't check for file extensions.");
            }
        }
        try {
            boolean included = this.isIncluded(file);
            LOG.debug("Derived files included: " + this.projectProperties.isIncludeDerivedFiles());
            LOG.debug("file " + file.getName() + " is derived: " + file.isDerived());
            LOG.debug("file checked: " + included);
            this.prepareMarkerAccumulator(file);
            LanguageVersionDiscoverer languageDiscoverer = new LanguageVersionDiscoverer(LanguageRegistry.PMD);
            LanguageVersion languageVersion = languageDiscoverer.getDefaultLanguageVersionForFile(file.getName());
            if (languageVersion != null && JavaLanguageModule.getInstance().equals((Object)languageVersion.getLanguage())) {
                languageVersion = PMDPlugin.javaVersionFor(file.getProject());
            }
            if (languageVersion != null) {
                this.configuration().setDefaultLanguageVersion(languageVersion);
            }
            LOG.debug("discovered language: {}", (Object)languageVersion);
            if (PMDPlugin.getDefault().loadPreferences().isProjectBuildPathEnabled()) {
                this.configuration().setClassLoader(this.projectProperties.getAuxClasspath());
            }
            this.configuration().setIgnoreIncrementalAnalysis(true);
            File sourceCodeFile = file.getRawLocation().toFile();
            FileId fileId = FileId.fromPathLikeString((String)sourceCodeFile.getAbsolutePath());
            if (included && this.isFileInWorkingSet(file) && languageVersion != null) {
                Report.ConfigurationError error;
                Iterator iterator;
                StringBuilder message;
                Report collectingReport;
                long start;
                block35: {
                    this.subTask("PMD checking: " + file.getProject() + ": " + file.getName());
                    start = System.currentTimeMillis();
                    this.configuration().setThreads(0);
                    collectingReport = null;
                    Throwable throwable = null;
                    Object var12_17 = null;
                    try {
                        InputStreamReader input = new InputStreamReader(file.getContents(), file.getCharset());
                        try {
                            try (PmdAnalysis pmdAnalysis = PmdAnalysis.create((PMDConfiguration)this.configuration());){
                                String sourceContents = IOUtil.toString(input);
                                pmdAnalysis.files().addSourceFile(fileId, sourceContents);
                                pmdAnalysis.addRuleSets(this.getRuleSetList());
                                LOG.debug("PMD running on file {}", (Object)file.getName());
                                collectingReport = pmdAnalysis.performAnalysisAndCollectReport();
                                LOG.debug("PMD run finished.");
                            }
                            if (input == null) break block35;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (input == null) throw throwable;
                            ((Reader)input).close();
                            throw throwable;
                        }
                        ((Reader)input).close();
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        }
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                        throw throwable;
                    }
                }
                this.pmdDuration += System.currentTimeMillis() - start;
                LOG.debug("PMD found {} violations for file {}", (Object)collectingReport.getViolations().size(), (Object)file);
                if (!collectingReport.getConfigurationErrors().isEmpty()) {
                    message = new StringBuilder("There were configuration errors!\n");
                    iterator = collectingReport.getConfigurationErrors().iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            LOG.warn(message.toString());
                            break;
                        }
                        error = (Report.ConfigurationError)iterator.next();
                        message.append(error.rule().getName()).append(": ").append(error.issue()).append('\n');
                    }
                }
                if (collectingReport.getProcessingErrors().isEmpty()) {
                    this.updateMarkers(file, collectingReport.getViolations());
                    this.worked(1);
                    ++this.fileCount;
                    return;
                }
                message = new StringBuilder("There were processing errors!\n");
                iterator = collectingReport.getProcessingErrors().iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        PMDPlugin.getDefault().logWarn(message.toString());
                        throw new RuntimeException(message.toString());
                    }
                    error = (Report.ProcessingError)iterator.next();
                    message.append(error.getFileId().getOriginalPath()).append(": ").append(error.getMsg()).append(' ').append(error.getDetail()).append("\n");
                }
            }
            LOG.debug("The file " + file.getName() + " is not in the working set");
            return;
        }
        catch (CoreException e) {
            LOG.error("Core exception visiting " + file.getName(), (Throwable)e);
            return;
        }
        catch (IOException e) {
            LOG.error("IO exception visiting " + file.getName(), (Throwable)e);
            return;
        }
        catch (PropertiesException e) {
            LOG.error("Properties exception visiting {}", (Object)file.getName(), (Object)e);
            return;
        }
        catch (IllegalArgumentException e) {
            LOG.error("Illegal argument: {}", (Object)e.toString(), (Object)e);
            return;
        }
        catch (RuntimeException e) {
            LOG.error("Runtime exception visiting {}", (Object)file.getName(), (Object)e);
        }
    }

    private boolean isFileInWorkingSet(IFile file) throws PropertiesException {
        boolean fileInWorkingSet = true;
        IWorkingSet workingSet = this.projectProperties.getProjectWorkingSet();
        if (workingSet != null) {
            ResourceWorkingSetFilter filter = new ResourceWorkingSetFilter();
            filter.setWorkingSet(workingSet);
            fileInWorkingSet = filter.select(null, null, (Object)file);
        }
        return fileInWorkingSet;
    }

    public static String markerTypeFor(RuleViolation violation) {
        switch (violation.getRule().getPriority()) {
            case HIGH: {
                return "net.sourceforge.pmd.eclipse.plugin.pmdMarker1";
            }
            case MEDIUM_HIGH: {
                return "net.sourceforge.pmd.eclipse.plugin.pmdMarker2";
            }
            case MEDIUM: {
                return "net.sourceforge.pmd.eclipse.plugin.pmdMarker3";
            }
            case MEDIUM_LOW: {
                return "net.sourceforge.pmd.eclipse.plugin.pmdMarker4";
            }
            case LOW: {
                return "net.sourceforge.pmd.eclipse.plugin.pmdMarker5";
            }
        }
        return "net.sourceforge.pmd.eclipse.plugin.pmdMarker";
    }

    private void prepareMarkerAccumulator(IFile file) {
        Map<IFile, Set<MarkerInfo2>> accumulator = this.getAccumulator();
        if (accumulator != null) {
            accumulator.put(file, new HashSet());
        }
    }

    private void updateMarkers(IFile file, List<RuleViolation> violations) throws CoreException, PropertiesException {
        Map<IFile, Set<MarkerInfo2>> accumulator = this.getAccumulator();
        HashSet<MarkerInfo2> markerSet = new HashSet<MarkerInfo2>();
        List<Review> reviewsList = this.findReviewedViolations(file);
        Review review = new Review();
        for (RuleViolation violation : violations) {
            Rule rule = violation.getRule();
            review.ruleName = rule.getName();
            review.lineNumber = violation.getBeginLine();
            if (reviewsList.contains(review)) {
                LOG.debug("Ignoring violation of rule " + rule.getName() + " at line " + violation.getBeginLine() + " because of a review.");
                continue;
            }
            markerSet.add(this.getMarkerInfo(violation, BaseVisitor.markerTypeFor(violation)));
            LOG.debug("Adding a violation for rule " + rule.getName() + " at line " + violation.getBeginLine());
        }
        if (accumulator != null) {
            LOG.debug("Adding markerSet to accumulator for file " + file.getName());
            accumulator.put(file, markerSet);
        }
    }

    private List<Review> findReviewedViolations(IFile file) {
        ArrayList<Review> reviews = new ArrayList<Review>();
        int lineNumber = 0;
        boolean findLine = false;
        boolean comment = false;
        ArrayDeque<String> pendingReviews = new ArrayDeque<String>();
        try {
            Throwable throwable = null;
            Object var8_11 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(file.getContents(), file.getCharset()));){
                while (reader.ready()) {
                    String line = reader.readLine();
                    if (line == null) continue;
                    line = line.trim();
                    ++lineNumber;
                    if (line.startsWith("/*")) {
                        comment = line.indexOf("*/") == -1;
                        continue;
                    }
                    if (comment && line.indexOf("*/") != -1) {
                        comment = false;
                        continue;
                    }
                    if (!comment && line.startsWith("// @PMD:REVIEWED:")) {
                        String tail = line.substring("// @PMD:REVIEWED:".length());
                        String ruleName = tail.substring(0, tail.indexOf(58));
                        pendingReviews.push(ruleName);
                        findLine = true;
                        continue;
                    }
                    if (comment || !findLine || !StringUtils.isNotBlank((CharSequence)line) || line.startsWith("//")) continue;
                    findLine = false;
                    while (!pendingReviews.isEmpty()) {
                        Review review = new Review();
                        review.ruleName = (String)pendingReviews.pop();
                        review.lineNumber = lineNumber;
                        reviews.add(review);
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (CoreException e) {
            PMDPlugin.getDefault().logError("Core Exception when searching reviewed violations", e);
        }
        catch (IOException e) {
            PMDPlugin.getDefault().logError("IO Exception when searching reviewed violations", e);
        }
        return reviews;
    }

    private MarkerInfo2 getMarkerInfo(RuleViolation violation, String type) throws PropertiesException {
        Rule rule = violation.getRule();
        MarkerInfo2 info = new MarkerInfo2(type, 7);
        info.add("message", String.valueOf(rule.getName()) + ": " + violation.getDescription());
        info.add("pmd_message", violation.getDescription());
        info.add("lineNumber", violation.getBeginLine());
        info.add("line2", violation.getEndLine());
        info.add("rulename", rule.getName());
        info.add("pmd_priority", rule.getPriority().getPriority());
        info.add("priority", 1);
        switch (rule.getPriority()) {
            case HIGH: 
            case MEDIUM_HIGH: {
                info.add("severity", this.projectProperties.violationsAsErrors() ? 2 : 1);
                break;
            }
            case MEDIUM: 
            case MEDIUM_LOW: {
                info.add("severity", 1);
                break;
            }
            case LOW: {
                info.add("severity", 0);
            }
        }
        return info;
    }

    private final class Review {
        public String ruleName;
        public int lineNumber;

        private Review() {
        }

        public boolean equals(Object obj) {
            boolean result = false;
            if (obj instanceof Review) {
                Review reviewObj = (Review)obj;
                result = this.ruleName.equals(reviewObj.ruleName) && this.lineNumber == reviewObj.lineNumber;
            }
            return result;
        }

        public int hashCode() {
            return this.ruleName.hashCode() + this.lineNumber * this.lineNumber;
        }
    }
}

