/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.runtime.cmd;

import java.io.File;
import java.util.List;
import net.sourceforge.pmd.cpd.CpdCapableLanguage;
import net.sourceforge.pmd.eclipse.runtime.properties.PropertiesException;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.ResourceWorkingSetFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CPDVisitor
implements IResourceVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(CPDVisitor.class);
    private boolean includeDerivedFiles;
    private ResourceWorkingSetFilter workingSetFilter;
    private CpdCapableLanguage language;
    private List<File> files;

    public void setIncludeDerivedFiles(boolean includeDerivedFiles) {
        this.includeDerivedFiles = includeDerivedFiles;
    }

    public void setWorkingSet(IWorkingSet workingSet) {
        this.workingSetFilter = new ResourceWorkingSetFilter();
        this.workingSetFilter.setWorkingSet(workingSet);
    }

    public void setLanguage(CpdCapableLanguage language) {
        this.language = language;
    }

    public List<File> getFiles() {
        return this.files;
    }

    public void setFiles(List<File> files) {
        this.files = files;
    }

    public boolean visit(IResource resource) throws CoreException {
        LOG.debug("CPD Visiting " + resource.getName());
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            File ioFile = file.getLocation().toFile();
            try {
                if (StringUtils.isNotBlank((CharSequence)file.getFileExtension()) && this.language.hasExtension(file.getFileExtension()) && this.isFileInWorkingSet(file) && (this.includeDerivedFiles || !file.isDerived())) {
                    LOG.debug("Add file " + resource.getName());
                    this.files.add(ioFile);
                    return false;
                }
            }
            catch (PropertiesException e) {
                LOG.warn("ModelException when adding file " + resource.getName() + " to CPD. Continuing.", (Throwable)e);
            }
        }
        return true;
    }

    private boolean isFileInWorkingSet(IFile file) throws PropertiesException {
        boolean fileInWorkingSet = true;
        if (this.workingSetFilter != null) {
            fileInWorkingSet = this.workingSetFilter.select(null, null, (Object)file);
        }
        return fileInWorkingSet;
    }
}

