/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.runtime.cmd;

import net.sourceforge.pmd.eclipse.runtime.cmd.AbstractDefaultCommand;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;

public class DeleteMarkersCommand
extends AbstractDefaultCommand {
    private IMarker[] markers;

    public DeleteMarkersCommand() {
        super("DeleteMarkersCommand", "Deletes a possible large number of markers");
        this.setOutputProperties(true);
        this.setReadOnly(false);
        this.setTerminated(false);
        this.setMarkers(null);
        this.setUserInitiated(false);
    }

    public final void setMarkers(IMarker[] theMarkers) {
        this.markers = theMarkers;
    }

    @Override
    public boolean isReadyToExecute() {
        return this.markers != null;
    }

    @Override
    public void execute() {
        try {
            this.beginTask("Deleting single markers", this.markers.length);
            int j = 0;
            while (j < this.markers.length && !this.isCanceled()) {
                this.markers[j].delete();
                this.worked(1);
                ++j;
            }
            this.done();
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void reset() {
        this.setMarkers(null);
    }
}

