/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.runtime.cmd;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.sourceforge.pmd.cpd.CPDConfiguration;
import net.sourceforge.pmd.cpd.CPDReport;
import net.sourceforge.pmd.cpd.CPDReportRenderer;
import net.sourceforge.pmd.cpd.CpdAnalysis;
import net.sourceforge.pmd.cpd.CpdCapableLanguage;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.cmd.AbstractProjectCommand;
import net.sourceforge.pmd.eclipse.runtime.cmd.CPDVisitor;
import net.sourceforge.pmd.eclipse.runtime.cmd.internal.CpdResult;
import net.sourceforge.pmd.eclipse.runtime.properties.IProjectProperties;
import net.sourceforge.pmd.eclipse.runtime.properties.PropertiesException;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageRegistry;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPropertyListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetectCutAndPasteCmd
extends AbstractProjectCommand {
    private CpdCapableLanguage language;
    private int minTileSize;
    private CPDReportRenderer renderer;
    private String reportName;
    private boolean createReport;
    private List<IPropertyListener> listeners;
    private static final Logger LOG = LoggerFactory.getLogger(DetectCutAndPasteCmd.class);

    public DetectCutAndPasteCmd() {
        super("DetectCutAndPaste", "Detect Cut & paste for a project");
        this.setOutputProperties(true);
        this.setReadOnly(false);
        this.setTerminated(false);
        this.listeners = new ArrayList<IPropertyListener>();
    }

    private void notifyListeners(final CpdResult cpdResult) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                for (IPropertyListener listener : DetectCutAndPasteCmd.this.listeners) {
                    listener.propertyChanged((Object)cpdResult, 1111);
                }
            }
        });
    }

    @Override
    public void execute() {
        try {
            try {
                List<File> files = this.findCandidateFiles();
                if (files.isEmpty()) {
                    DetectCutAndPasteCmd.logInfo("No files found for specified language.");
                } else {
                    DetectCutAndPasteCmd.logInfo("Found " + files.size() + " files for the specified language. Performing CPD.");
                }
                this.setStepCount(files.size());
                this.beginTask("Finding suspect Cut And Paste", this.getStepCount() * 2);
                Consumer<CPDReport> renderer = null;
                if (this.createReport) {
                    renderer = this::renderReport;
                }
                if (!this.isCanceled()) {
                    CpdResult cpdResult = this.detectCutAndPaste(files, renderer);
                    if (!this.isCanceled()) {
                        this.notifyListeners(cpdResult);
                    }
                }
            }
            catch (CoreException e) {
                LOG.debug("Core Exception: " + e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
            catch (PropertiesException e) {
                LOG.debug("Properties Exception: " + e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        finally {
            this.setTerminated(true);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.setTerminated(false);
        this.setReportName(null);
        this.setCPDRenderer(null);
        this.setLanguage("java");
        this.setMinTileSize(PMDPlugin.getDefault().loadPreferences().getMinTileSize());
        this.setCreateReport(false);
        this.addPropertyListener(null);
        this.listeners = new ArrayList<IPropertyListener>();
    }

    public void setLanguage(String theLanguage) {
        this.language = (CpdCapableLanguage)LanguageRegistry.CPD.getLanguageById(theLanguage);
    }

    public void setMinTileSize(int tilesize) {
        this.minTileSize = tilesize;
    }

    public void setCPDRenderer(CPDReportRenderer theRenderer) {
        this.renderer = theRenderer;
    }

    public void setReportName(String theReportName) {
        this.reportName = theReportName;
    }

    public void setCreateReport(boolean render) {
        this.createReport = render;
    }

    public void addPropertyListener(IPropertyListener listener) {
        this.listeners.add(listener);
    }

    private boolean canRenderReport() {
        return this.renderer != null && StringUtils.isNotBlank((CharSequence)this.reportName);
    }

    @Override
    public boolean isReadyToExecute() {
        return super.isReadyToExecute() && this.language != null && (!this.createReport || this.canRenderReport());
    }

    private List<File> findCandidateFiles() throws PropertiesException, CoreException {
        IProjectProperties properties = this.projectProperties();
        CPDVisitor visitor = new CPDVisitor();
        visitor.setWorkingSet(properties.getProjectWorkingSet());
        visitor.setIncludeDerivedFiles(properties.isIncludeDerivedFiles());
        visitor.setLanguage(this.language);
        visitor.setFiles(new ArrayList<File>());
        this.visitProjectResourcesWith(visitor);
        return visitor.getFiles();
    }

    private CpdResult detectCutAndPaste(List<File> files, Consumer<CPDReport> renderer) {
        LOG.debug("Searching for project files");
        AtomicReference reportResult = new AtomicReference();
        CPDConfiguration config = new CPDConfiguration();
        config.setMinimumTileSize(this.minTileSize);
        config.setOnlyRecognizeLanguage((Language)this.language);
        config.setSourceEncoding(Charset.defaultCharset());
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (CpdAnalysis cpd = CpdAnalysis.create((CPDConfiguration)config);){
                this.subTask("Collecting files for CPD");
                Iterator<File> fileIterator = files.iterator();
                while (fileIterator.hasNext() && !this.isCanceled()) {
                    File file = fileIterator.next();
                    cpd.files().addFile(file.toPath());
                    this.worked(1);
                }
                if (!this.isCanceled()) {
                    this.subTask("Performing CPD");
                    LOG.debug("Performing CPD");
                    cpd.performAnalysis(r -> {
                        if (renderer != null) {
                            renderer.accept((CPDReport)r);
                        }
                        reportResult.set(new CpdResult((CPDReport)r));
                    });
                    this.worked(this.getStepCount());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOG.error("IOException while executing CPD", (Throwable)e);
        }
        return (CpdResult)reportResult.get();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void renderReport(CPDReport cpdResult) {
        try {
            Object var6_11;
            byte[] data;
            IFile reportFile;
            block29: {
                LOG.debug("Rendering CPD report");
                this.subTask("Rendering CPD report");
                LOG.debug("Create the report folder");
                IFolder folder = this.getProjectFolder("reports");
                if (!folder.exists()) {
                    folder.create(true, true, this.getMonitor());
                }
                LOG.debug("Create the report file");
                reportFile = folder.getFile(this.reportName);
                data = new byte[]{};
                try {
                    Throwable throwable = null;
                    var6_11 = null;
                    try {
                        ByteArrayOutputStream renderedReport = new ByteArrayOutputStream();
                        try {
                            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)renderedReport, StandardCharsets.UTF_8);){
                                this.renderer.render(cpdResult, (Writer)writer);
                                ((Writer)writer).flush();
                                data = renderedReport.toByteArray();
                            }
                            if (renderedReport == null) break block29;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (renderedReport == null) throw throwable;
                            renderedReport.close();
                            throw throwable;
                        }
                        renderedReport.close();
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        }
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    LOG.error("Error while renderering CPD Report", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            try {
                Throwable e = null;
                var6_11 = null;
                try (ByteArrayInputStream contentsStream = new ByteArrayInputStream(data);){
                    if (reportFile.exists()) {
                        LOG.debug("   Overwriting report file");
                        reportFile.setContents((InputStream)contentsStream, true, false, this.getMonitor());
                        reportFile.setCharset(StandardCharsets.UTF_8.name(), this.getMonitor());
                    } else {
                        LOG.debug("   Creating report file");
                        reportFile.create((InputStream)contentsStream, true, this.getMonitor());
                    }
                }
                catch (Throwable throwable) {
                    if (e == null) {
                        e = throwable;
                        throw e;
                    }
                    if (e == throwable) throw e;
                    e.addSuppressed(throwable);
                    throw e;
                }
            }
            catch (IOException e) {
                LOG.error("Error while writing CPD Report", (Throwable)e);
                throw new RuntimeException(e);
            }
            reportFile.refreshLocal(2, this.getMonitor());
            return;
        }
        catch (CoreException e) {
            LOG.debug("Core Exception: " + e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

