/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.runtime.cmd;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Set;
import net.sourceforge.pmd.eclipse.core.internal.FileModificationUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaProjectClassLoader
extends URLClassLoader {
    private static final Logger LOG = LoggerFactory.getLogger(JavaProjectClassLoader.class);
    private final IJavaProject javaProject;
    private final long lastModTimestamp;
    private final IWorkspace workspace;
    private Set<IJavaProject> javaProjects = new HashSet<IJavaProject>();

    public JavaProjectClassLoader(ClassLoader parent, IProject project) {
        super(new URL[0], parent);
        try {
            if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
                throw new IllegalArgumentException("The project " + project + " is not a java project");
            }
        }
        catch (CoreException e) {
            throw new IllegalArgumentException("The project " + project + " is not a java project", e);
        }
        this.workspace = project.getWorkspace();
        this.javaProject = JavaCore.create((IProject)project);
        this.lastModTimestamp = this.getClasspathModificationTimestamp();
        this.addURLs(this.javaProject, false);
        this.javaProjects = null;
    }

    public boolean isModified() {
        long newTimestamp = this.getClasspathModificationTimestamp();
        return newTimestamp != this.lastModTimestamp;
    }

    private long getClasspathModificationTimestamp() {
        IFile classpathFile = this.javaProject.getProject().getFile(".classpath");
        return FileModificationUtil.getFileModificationTimestamp(classpathFile.getLocation().toFile());
    }

    private IProject projectFor(IClasspathEntry classpathEntry) {
        return this.workspace.getRoot().getProject(classpathEntry.getPath().toString());
    }

    private void addURLs(IJavaProject javaProject, boolean exportsOnly) {
        if (this.javaProjects.contains(javaProject)) {
            return;
        }
        this.javaProjects.add(javaProject);
        try {
            IClasspathEntry[] classpathEntries;
            IPath projectLocation = javaProject.getProject().getLocation();
            this.addURL(projectLocation.append(javaProject.getOutputLocation().removeFirstSegments(1)));
            IClasspathEntry[] iClasspathEntryArray = classpathEntries = javaProject.getResolvedClasspath(true);
            int n = classpathEntries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
                if (classpathEntry.isExported() || !exportsOnly) {
                    switch (classpathEntry.getEntryKind()) {
                        case 2: {
                            IProject project = this.projectFor(classpathEntry);
                            IJavaProject javaProj = JavaCore.create((IProject)project);
                            if (javaProj == null) break;
                            this.addURLs(javaProj, true);
                            break;
                        }
                        case 1: {
                            this.addURL(classpathEntry);
                            break;
                        }
                        case 3: {
                            IPath outputLocation = classpathEntry.getOutputLocation();
                            if (outputLocation == null) break;
                            this.addURL(projectLocation.append(outputLocation.removeFirstSegments(1)));
                            break;
                        }
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            LOG.warn("JavaModelException occurred: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void addURL(IClasspathEntry classpathEntry) {
        this.addURL(classpathEntry.getPath());
    }

    private void addURL(IPath path) {
        try {
            File absoluteFile = null;
            IPath location = this.workspace.getRoot().getFile(path).getLocation();
            if (location != null) {
                absoluteFile = location.toFile().getAbsoluteFile();
            }
            if (absoluteFile == null) {
                absoluteFile = path.toFile().getAbsoluteFile();
            }
            if (!absoluteFile.exists()) {
                LOG.warn("auxclasspath: Resolved file {} does not exist", (Object)absoluteFile);
            }
            URL url = absoluteFile.toURI().toURL();
            LOG.debug("auxclasspath: Adding url {}", (Object)url);
            this.addURL(url);
        }
        catch (MalformedURLException e) {
            LOG.warn("MalformedURLException occurred: {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

