/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.runtime.cmd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import net.sourceforge.pmd.eclipse.runtime.cmd.AbstractDefaultCommand;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobCommandProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(JobCommandProcessor.class);
    private final Map<AbstractDefaultCommand, Job> jobs = Collections.synchronizedMap(new HashMap());
    private static Queue<Job> outstanding = new ConcurrentLinkedQueue<Job>();
    private static AtomicInteger count = new AtomicInteger();
    private static final JobCommandProcessor INSTANCE = new JobCommandProcessor();

    public static JobCommandProcessor getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processCommand(final AbstractDefaultCommand aCommand) {
        LOG.debug("Beginning job command {}", (Object)aCommand.getName());
        if (!aCommand.isReadyToExecute()) {
            throw new IllegalStateException();
        }
        Job job = new Job(aCommand.getName()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                try {
                    if (aCommand instanceof AbstractDefaultCommand) {
                        aCommand.setMonitor(monitor);
                    }
                    long start = System.currentTimeMillis();
                    aCommand.execute();
                    long duration = System.currentTimeMillis() - start;
                    LOG.debug("Command {} executed in {} ms", (Object)aCommand.getName(), (Object)duration);
                }
                catch (RuntimeException e) {
                    LOG.error("Error executing command {}: {}", new Object[]{aCommand.getName(), e.toString(), e});
                }
                Queue queue = outstanding;
                synchronized (queue) {
                    count.decrementAndGet();
                    Job job = (Job)outstanding.poll();
                    if (job != null) {
                        job.schedule();
                    }
                }
                return Status.OK_STATUS;
            }
        };
        if (aCommand instanceof AbstractDefaultCommand) {
            job.setUser(aCommand.isUserInitiated());
        }
        Queue<Job> queue = outstanding;
        synchronized (queue) {
            if (count.incrementAndGet() > 10) {
                outstanding.add(job);
            } else {
                job.schedule();
            }
        }
        this.addJob(aCommand, job);
        LOG.debug("Ending job command {}", (Object)aCommand.getName());
    }

    public void waitCommandToFinish(AbstractDefaultCommand aCommand) {
        Job job = this.jobs.get(aCommand);
        if (job != null) {
            try {
                job.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        } else {
            this.clearTerminatedJobs();
            ArrayList<Job> runningJobs = new ArrayList<Job>(this.jobs.values());
            LOG.debug("Waiting for {} jobs to finish...", (Object)runningJobs.size());
            for (Job runningJob : runningJobs) {
                try {
                    runningJob.join();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
            }
            this.clearTerminatedJobs();
            LOG.debug("All jobs have finished.");
        }
    }

    private void addJob(AbstractDefaultCommand command, Job job) {
        this.jobs.put(command, job);
        this.clearTerminatedJobs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearTerminatedJobs() {
        Set<AbstractDefaultCommand> keySet = this.jobs.keySet();
        Map<AbstractDefaultCommand, Job> map = this.jobs;
        synchronized (map) {
            Iterator<AbstractDefaultCommand> i = keySet.iterator();
            while (i.hasNext()) {
                AbstractDefaultCommand aCommand = i.next();
                Job aJob = this.jobs.get(aCommand);
                if (aJob != null && aJob.getResult() == null) continue;
                i.remove();
            }
        }
    }
}

