/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.runtime.cmd;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.builder.MarkerUtil;
import net.sourceforge.pmd.eclipse.runtime.cmd.AbstractProjectCommand;
import net.sourceforge.pmd.eclipse.runtime.cmd.FakeRuleViolation;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.lang.rule.RuleSet;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.reporting.Report;
import net.sourceforge.pmd.reporting.RuleViolation;
import net.sourceforge.pmd.util.BaseResultProducingCloseable;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenderReportsCmd
extends AbstractProjectCommand {
    private static final Logger LOG = LoggerFactory.getLogger(RenderReportsCmd.class);
    private Map<String, Renderer> renderers = new HashMap<String, Renderer>();

    public RenderReportsCmd() {
        super("RenderReport", "Produce reports for a project");
        this.setOutputProperties(false);
        this.setReadOnly(false);
        this.setTerminated(false);
    }

    public void registerRenderer(Renderer renderer, String reportFile) {
        if (reportFile != null && renderer != null) {
            this.renderers.put(reportFile, renderer);
        }
    }

    private void render(Report report, IFolder folder, String reportName, Renderer renderer) throws IOException, CoreException {
        String reportString = null;
        Throwable throwable = null;
        Throwable throwable2 = null;
        try (StringWriter writer = new StringWriter();){
            renderer.setWriter((Writer)writer);
            renderer.start();
            renderer.renderFileReport(report);
            renderer.end();
            renderer.flush();
            reportString = writer.toString();
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        if (StringUtils.isBlank((CharSequence)reportString)) {
            LOG.debug("Missing content for report: " + reportName);
            return;
        }
        LOG.debug("   Creating the report file");
        IFile reportFile = folder.getFile(reportName);
        throwable2 = null;
        Object var8_11 = null;
        try (ByteArrayInputStream contentsStream = new ByteArrayInputStream(reportString.getBytes(StandardCharsets.UTF_8));){
            if (reportFile.exists()) {
                reportFile.setContents((InputStream)contentsStream, true, false, this.getMonitor());
            } else {
                reportFile.create((InputStream)contentsStream, true, this.getMonitor());
            }
            reportFile.setCharset(StandardCharsets.UTF_8.name(), this.getMonitor());
        }
        catch (Throwable throwable4) {
            if (throwable2 == null) {
                throwable2 = throwable4;
            } else if (throwable2 != throwable4) {
                throwable2.addSuppressed(throwable4);
            }
            throw throwable2;
        }
        reportFile.refreshLocal(2, this.getMonitor());
    }

    @Override
    public void execute() {
        try {
            try {
                LOG.debug("Starting RenderReport command");
                LOG.debug("   Create a report object");
                Report report = this.createReport(this.project());
                LOG.debug("   Getting the report folder");
                IFolder folder = this.getProjectFolder("reports");
                if (!folder.exists()) {
                    folder.create(true, true, this.getMonitor());
                }
                for (Map.Entry<String, Renderer> entry : this.renderers.entrySet()) {
                    String reportName = entry.getKey();
                    Renderer renderer = entry.getValue();
                    LOG.debug("   Render the report");
                    this.render(report, folder, reportName, renderer);
                }
            }
            catch (IOException | CoreException e) {
                LOG.debug(e.toString(), e);
                throw new RuntimeException(e);
            }
        }
        finally {
            LOG.debug("End of RenderReport command");
            this.setTerminated(true);
        }
    }

    @Override
    public void reset() {
        this.setProject(null);
        this.renderers = new HashMap<String, Renderer>();
        this.setTerminated(false);
    }

    @Override
    public boolean isReadyToExecute() {
        return super.isReadyToExecute() && !this.renderers.isEmpty();
    }

    private static void classAndPackageFrom(IMarker marker, FakeRuleViolation violation) throws JavaModelException {
        ICompilationUnit unit = JavaCore.createCompilationUnitFrom((IFile)((IFile)marker.getResource()));
        IPackageDeclaration[] packages = unit.getPackageDeclarations();
        violation.setPackageName(packages.length > 0 ? packages[0].getElementName() : "(default)");
        IType[] types = unit.getAllTypes();
        violation.setClassName(types.length > 0 ? types[0].getElementName() : marker.getResource().getName());
    }

    private Report createReport(IProject project) throws CoreException {
        IMarker[] markers = MarkerUtil.findAllMarkers((IResource)project);
        boolean isJavaProject = project.hasNature("org.eclipse.jdt.core.javanature");
        return (Report)BaseResultProducingCloseable.using((BaseResultProducingCloseable)new Report.ReportBuilderListener(), reportBuilderListener -> {
            RuleSet ruleSet = PMDPlugin.getDefault().getPreferencesManager().getRuleSet();
            IMarker[] iMarkerArray2 = markers;
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray2[n2];
                String ruleName = marker.getAttribute("rulename", "");
                Rule rule = ruleSet.getRuleByName(ruleName);
                FakeRuleViolation ruleViolation = RenderReportsCmd.createViolation(marker, rule);
                if (isJavaProject && marker.getResource() instanceof IFile) {
                    try {
                        RenderReportsCmd.classAndPackageFrom(marker, ruleViolation);
                    }
                    catch (JavaModelException e) {
                        throw new RuntimeException(e);
                    }
                }
                reportBuilderListener.onRuleViolation((RuleViolation)ruleViolation);
                ++n2;
            }
        });
    }

    private static FakeRuleViolation createViolation(IMarker marker, Rule rule) {
        FakeRuleViolation ruleViolation = new FakeRuleViolation(rule);
        ruleViolation.setBeginLine(marker.getAttribute("lineNumber", 0));
        ruleViolation.setEndLine(marker.getAttribute("line2", 0));
        ruleViolation.setVariableName(marker.getAttribute("line2", ""));
        FileId fileId = FileId.fromPathLikeString((String)marker.getResource().getProjectRelativePath().toString());
        ruleViolation.setFileId(fileId);
        ruleViolation.setDescription(marker.getAttribute("message", rule.getMessage()));
        return ruleViolation;
    }
}

