/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.runtime.cmd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.builder.MarkerUtil;
import net.sourceforge.pmd.eclipse.runtime.cmd.AbstractDefaultCommand;
import net.sourceforge.pmd.eclipse.runtime.cmd.DeltaVisitor;
import net.sourceforge.pmd.eclipse.runtime.cmd.MarkerInfo2;
import net.sourceforge.pmd.eclipse.runtime.cmd.ResourceVisitor;
import net.sourceforge.pmd.eclipse.runtime.preferences.IPreferences;
import net.sourceforge.pmd.eclipse.runtime.properties.IProjectProperties;
import net.sourceforge.pmd.eclipse.runtime.properties.PropertiesException;
import net.sourceforge.pmd.eclipse.ui.actions.RuleSetUtil;
import net.sourceforge.pmd.eclipse.ui.actions.internal.InternalRuleSetUtil;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.lang.rule.RuleSet;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReviewCodeCmd
extends AbstractDefaultCommand {
    private static final Logger LOG = LoggerFactory.getLogger(ReviewCodeCmd.class);
    private static final int MAXIMUM_RESOURCE_COUNT = 5;
    private final List<IResource> resources = new ArrayList<IResource>();
    private IResourceDelta resourceDelta;
    private Map<IFile, Set<MarkerInfo2>> markersByFile = new HashMap<IFile, Set<MarkerInfo2>>();
    private boolean openPmdPerspective;
    private boolean openPmdViolationsOverviewView;
    private boolean openPmdViolationsOutlineView;
    private int ruleCount;
    private int fileCount;
    private long pmdDuration;
    private boolean runAlways = false;
    private IProjectProperties propertyCache = null;

    public ReviewCodeCmd() {
        super("ReviewCode", "Run PMD on a list of workbench resources");
        this.setOutputProperties(true);
        this.setReadOnly(true);
        this.setTerminated(false);
    }

    public Set<IFile> markedFiles() {
        return this.markersByFile.keySet();
    }

    public static void runCodeReviewOnFiles(Set<IFile> files) {
        ReviewCodeCmd cmd = new ReviewCodeCmd();
        cmd.setStepCount(files.size());
        cmd.setOpenPmdPerspective(PMDPlugin.getDefault().loadPreferences().isPmdPerspectiveEnabled());
        cmd.setOpenPmdViolationsOverviewView(PMDPlugin.getDefault().loadPreferences().isPmdViolationsOverviewEnabled());
        cmd.setOpenPmdViolationsOutlineView(PMDPlugin.getDefault().loadPreferences().isPmdViolationsOutlineEnabled());
        cmd.setUserInitiated(true);
        cmd.setRunAlways(true);
        for (IResource iResource : files) {
            cmd.addResource(iResource);
        }
        cmd.performExecute();
    }

    private RuleSet currentRules() {
        return RuleSetUtil.newEmpty("pmd-eclipse", "PMD Plugin preferences rule set");
    }

    private Map<Rule, String> misconfiguredRulesIn() {
        RuleSet ruleSet = this.currentRules();
        HashMap<Rule, String> faultsByRule = new HashMap<Rule, String>();
        for (Rule rule : ruleSet.getRules()) {
            String fault = rule.dysfunctionReason();
            if (!StringUtils.isNotEmpty((CharSequence)fault)) continue;
            faultsByRule.put(rule, fault);
        }
        return faultsByRule;
    }

    private boolean checkForMisconfiguredRules() {
        Map<Rule, String> faultsByRule;
        RuleSet ruleSet = this.currentRules();
        boolean runPMD = true;
        if (!ruleSet.getRules().isEmpty() && !(faultsByRule = this.misconfiguredRulesIn()).isEmpty()) {
            runPMD = MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"Rule configuration problem", (String)"Continue anyways?");
        }
        return runPMD;
    }

    @Override
    public void execute() {
        boolean doReview = this.checkForMisconfiguredRules();
        if (!doReview) {
            return;
        }
        LOG.debug("ReviewCode command starting.");
        try {
            try {
                this.fileCount = 0;
                this.ruleCount = 0;
                this.pmdDuration = 0L;
                String projectList = this.determineProjectList();
                int totalWork = this.determineTotalWork();
                LOG.info("Found {} resources in projects {}", (Object)totalWork, (Object)projectList);
                this.setStepCount(totalWork);
                StringBuilder mainTaskName = new StringBuilder(projectList.length() + 20);
                mainTaskName.append("Executing PMD for ").append(projectList).append(" ...");
                this.beginTask(mainTaskName.toString(), totalWork);
                if (this.resources.isEmpty()) {
                    this.processResourceDelta();
                } else {
                    this.processResources();
                }
                if (!this.markersByFile.isEmpty()) {
                    IWorkspaceRunnable action = new IWorkspaceRunnable(){

                        public void run(IProgressMonitor monitor) throws CoreException {
                            ReviewCodeCmd.this.applyMarkers();
                        }
                    };
                    for (IFile file : this.markersByFile.keySet()) {
                        if (this.isCanceled()) break;
                        MarkerUtil.deleteAllMarkersIn((IResource)file);
                    }
                    IWorkspace workspace = ResourcesPlugin.getWorkspace();
                    workspace.run(action, this.getSchedulingRule(), 1, this.getMonitor());
                }
                if (this.openPmdPerspective) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ReviewCodeCmd.switchToPmdPerspective();
                        }
                    });
                }
                if (this.openPmdViolationsOverviewView) {
                    PMDPlugin.getDefault().showView("net.sourceforge.pmd.eclipse.ui.views.violationOverview");
                }
                if (this.openPmdViolationsOutlineView) {
                    PMDPlugin.getDefault().showView("net.sourceforge.pmd.eclipse.ui.views.violationOutline");
                }
            }
            catch (CoreException e) {
                throw new RuntimeException("Core exception when reviewing code", e);
            }
        }
        catch (Throwable throwable) {
            LOG.debug("ReviewCode command has ended.");
            this.setTerminated(true);
            this.done();
            if (this.fileCount > 0 && this.ruleCount > 0) {
                LOG.info("Review code command finished. {} rules were executed against {} files.\nActual PMD duration is about {}ms, that is about {}ms/file, {}ms/rule, {}ms/filerule", new Object[]{this.ruleCount, this.fileCount, this.pmdDuration, Float.valueOf((float)this.pmdDuration / (float)this.fileCount), Float.valueOf((float)this.pmdDuration / (float)this.ruleCount), Float.valueOf((float)this.pmdDuration / (float)((long)this.fileCount * (long)this.ruleCount))});
            } else {
                LOG.info("Review code command finished. {} rules were executed against {} files. PMD has not been executed.", (Object)this.ruleCount, (Object)this.fileCount);
            }
            throw throwable;
        }
        LOG.debug("ReviewCode command has ended.");
        this.setTerminated(true);
        this.done();
        if (this.fileCount > 0 && this.ruleCount > 0) {
            LOG.info("Review code command finished. {} rules were executed against {} files.\nActual PMD duration is about {}ms, that is about {}ms/file, {}ms/rule, {}ms/filerule", new Object[]{this.ruleCount, this.fileCount, this.pmdDuration, Float.valueOf((float)this.pmdDuration / (float)this.fileCount), Float.valueOf((float)this.pmdDuration / (float)this.ruleCount), Float.valueOf((float)this.pmdDuration / (float)((long)this.fileCount * (long)this.ruleCount))});
        } else {
            LOG.info("Review code command finished. {} rules were executed against {} files. PMD has not been executed.", (Object)this.ruleCount, (Object)this.fileCount);
        }
        PMDPlugin.getDefault().changedFiles(this.markedFiles());
    }

    private int determineTotalWork() {
        boolean useFileExtensions = PMDPlugin.getDefault().loadPreferences().isDetermineFiletypesAutomatically();
        HashMap<IProject, Set<String>> fileExtensionsPerProject = new HashMap<IProject, Set<String>>();
        CountVisitor2 visitor = new CountVisitor2(useFileExtensions, fileExtensionsPerProject);
        for (IResource resource : this.resources) {
            this.determineFileExtensions(fileExtensionsPerProject, resource);
            try {
                if (resource instanceof IProject && ((IProject)resource).hasNature("org.eclipse.jdt.core.javanature")) {
                    for (IResource sourceFolder : this.getJavaProjectSourceFolders((IProject)resource)) {
                        sourceFolder.accept((IResourceVisitor)visitor);
                    }
                    continue;
                }
                resource.accept((IResourceVisitor)visitor);
            }
            catch (CoreException e) {
                LOG.warn("Error while counting resources for {}", (Object)resource, (Object)e);
            }
        }
        if (this.resourceDelta != null) {
            IResource resource;
            resource = this.resourceDelta.getResource();
            this.determineFileExtensions(fileExtensionsPerProject, resource);
            try {
                resource.accept((IResourceVisitor)visitor);
            }
            catch (CoreException e) {
                LOG.warn("Error while counting resources for {} (delta)", (Object)resource, (Object)e);
            }
        }
        return visitor.getCount();
    }

    private void determineFileExtensions(Map<IProject, Set<String>> fileExtensionsPerProject, IResource resource) {
        IProject project = resource.getProject();
        if (project != null && !fileExtensionsPerProject.containsKey(project)) {
            try {
                List<RuleSet> rulesets = this.rulesetsFrom(resource);
                Set<String> fileExtensions = this.determineFileExtensions(rulesets);
                fileExtensionsPerProject.put(project, fileExtensions);
            }
            catch (PropertiesException e) {
                LOG.warn("Error while determining file extensions for project {}", (Object)project, (Object)e);
                fileExtensionsPerProject.put(project, Collections.emptySet());
            }
        }
    }

    private String determineProjectList() {
        IProject project;
        HashSet<IProject> projects = new HashSet<IProject>();
        for (IResource resource : this.resources) {
            IProject project2 = resource.getProject();
            if (project2 == null) continue;
            projects.add(project2);
        }
        if (this.resourceDelta != null && (project = this.resourceDelta.getResource().getProject()) != null) {
            projects.add(project);
        }
        StringBuilder projectList = new StringBuilder(projects.size() * 20);
        projectList.append('[');
        for (IProject project3 : projects) {
            projectList.append(project3.getName());
            projectList.append(", ");
        }
        projectList.delete(projectList.length() - 2, projectList.length());
        projectList.append(']');
        return projectList.toString();
    }

    public Map<IFile, Set<MarkerInfo2>> getMarkers() {
        return this.markersByFile;
    }

    public int getFileCount() {
        return this.fileCount;
    }

    public void setResources(Collection<ISchedulingRule> resources) {
        resources.clear();
        resources.addAll(resources);
    }

    public void addResource(IResource resource) {
        if (resource == null) {
            throw new IllegalArgumentException("Resource parameter can not be null");
        }
        this.resources.add(resource);
    }

    public void setResourceDelta(IResourceDelta resourceDelta) {
        this.resourceDelta = resourceDelta;
    }

    public void setRunAlways(boolean runAlways) {
        this.runAlways = runAlways;
    }

    public void setOpenPmdPerspective(boolean openPmdPerspective) {
        this.openPmdPerspective = openPmdPerspective;
    }

    public void setOpenPmdViolationsOverviewView(boolean openPmdViolationsView) {
        this.openPmdViolationsOverviewView = openPmdViolationsView;
    }

    public void setOpenPmdViolationsOutlineView(boolean openPmdViolationsOutlineView) {
        this.openPmdViolationsOutlineView = openPmdViolationsOutlineView;
    }

    @Override
    public void reset() {
        this.resources.clear();
        this.markersByFile = new HashMap<IFile, Set<MarkerInfo2>>();
        this.setTerminated(false);
        this.openPmdPerspective = false;
        this.openPmdViolationsOverviewView = false;
        this.openPmdViolationsOutlineView = false;
        this.runAlways = false;
    }

    @Override
    public boolean isReadyToExecute() {
        return !this.resources.isEmpty() || this.resourceDelta != null;
    }

    private ISchedulingRule getSchedulingRule() {
        ISchedulingRule rule;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IResourceRuleFactory ruleFactory = workspace.getRuleFactory();
        if (this.resources.isEmpty()) {
            rule = ruleFactory.markerRule((IResource)this.resourceDelta.getResource().getProject());
        } else {
            ISchedulingRule[] rules = new ISchedulingRule[this.resources.size()];
            int i = 0;
            while (i < rules.length) {
                rules[i] = ruleFactory.markerRule(this.resources.get(i));
                ++i;
            }
            rule = new MultiRule(this.resources.toArray(rules));
        }
        return rule;
    }

    private void processResources() {
        for (IResource resource : this.resources) {
            if (this.isCanceled()) continue;
            if (resource instanceof IProject) {
                this.processProject((IProject)resource);
                continue;
            }
            this.processResource(resource);
        }
    }

    private IProjectProperties getProjectProperties(IProject project) throws PropertiesException {
        if (this.propertyCache == null || !this.propertyCache.getProject().getName().equals(project.getName())) {
            this.propertyCache = PMDPlugin.getDefault().loadProjectProperties(project);
        }
        return this.propertyCache;
    }

    private List<RuleSet> rulesetsFrom(IResource resource) throws PropertiesException {
        IProject project = resource.getProject();
        IProjectProperties properties = this.getProjectProperties(project);
        return this.filteredRuleSets(properties);
    }

    private void processResource(IResource resource) {
        try {
            IProject project = resource.getProject();
            IProjectProperties properties = this.getProjectProperties(project);
            if (!this.runAlways && !properties.isPmdEnabled()) {
                return;
            }
            List<RuleSet> ruleSets = this.rulesetsFrom(resource);
            Set<String> fileExtensions = this.determineFileExtensions(ruleSets);
            int targetCount = 0;
            if (resource.exists()) {
                targetCount = this.countResourceElement(resource, fileExtensions);
            }
            if (properties.isFullBuildEnabled() || this.isUserInitiated() || targetCount <= 5) {
                this.setStepCount(targetCount);
                LOG.debug("Visiting resource {}: {}", (Object)resource.getName(), (Object)this.getStepCount());
                if (resource.exists()) {
                    ResourceVisitor visitor = new ResourceVisitor();
                    visitor.setMonitor(this.getMonitor());
                    visitor.setRuleSetList(ruleSets);
                    visitor.setFileExtensions(fileExtensions);
                    visitor.setAccumulator(this.markersByFile);
                    visitor.setProjectProperties(properties);
                    resource.accept((IResourceVisitor)visitor);
                    this.ruleCount = InternalRuleSetUtil.countRules(ruleSets);
                    this.fileCount += visitor.getProcessedFilesCount();
                    this.pmdDuration += visitor.getActualPmdDuration();
                } else {
                    LOG.debug("Skipping resource {} because it doesn't exist.", (Object)resource.getName());
                }
            } else {
                LOG.info("Skipping resource {} because of fullBuildEnabled flag and targetCount is {}. This is more than {}. If you want to execute PMD, please check \"Full build enabled\" in the project settings.", new Object[]{resource.getName(), targetCount, 5});
            }
        }
        catch (PropertiesException | CoreException e) {
            throw new RuntimeException(e);
        }
    }

    private Set<String> determineFileExtensions(List<RuleSet> ruleSets) {
        HashSet<Language> languages = new HashSet<Language>();
        for (RuleSet ruleset : ruleSets) {
            for (Rule rule : ruleset.getRules()) {
                languages.add(rule.getLanguage());
            }
        }
        HashSet<String> fileExtensions = new HashSet<String>();
        for (Language language : languages) {
            for (String extension : language.getExtensions()) {
                fileExtensions.add(extension.toLowerCase(Locale.ROOT));
            }
        }
        LOG.debug("Determined applicable file extensions: {}", fileExtensions);
        return fileExtensions;
    }

    private void processProject(IProject project) {
        try {
            this.subTask("Review " + project);
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                this.processJavaProject(project);
            } else {
                this.processResource((IResource)project);
            }
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    private void processJavaProject(IProject project) throws CoreException {
        for (IResource sourceFolder : this.getJavaProjectSourceFolders(project)) {
            this.processResource(sourceFolder);
        }
    }

    private List<IResource> getJavaProjectSourceFolders(IProject project) throws CoreException {
        ArrayList<IResource> sourceFolders = new ArrayList<IResource>();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IClasspathEntry[] entries = javaProject.getRawClasspath();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IClasspathEntry[] iClasspathEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entrie = iClasspathEntryArray[n2];
            if (entrie.getEntryKind() == 3) {
                IFolder sourceContainer = null;
                try {
                    sourceContainer = root.getFolder(entrie.getPath());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    sourceContainer = root.getProject(entrie.getPath().toString());
                }
                if (sourceContainer == null) {
                    LOG.warn("Source container {} for project {} is not valid", (Object)entrie.getPath(), (Object)project);
                } else {
                    sourceFolders.add((IResource)sourceContainer);
                }
            }
            ++n2;
        }
        return sourceFolders;
    }

    private void taskScope(int activeRuleCount, int totalRuleCount) {
        this.setTaskName("Checking with " + Integer.toString(activeRuleCount) + " out of " + Integer.toString(totalRuleCount) + " rules");
    }

    private List<RuleSet> filteredRuleSets(IProjectProperties properties) throws PropertiesException {
        List<RuleSet> projectRuleSets = properties.getProjectRuleSetList();
        IPreferences preferences = PMDPlugin.getDefault().getPreferencesManager().loadPreferences();
        Set<String> onlyActiveRuleNames = preferences.getActiveRuleNames();
        ArrayList<RuleSet> filteredRuleSets = new ArrayList<RuleSet>();
        for (RuleSet ruleSet : projectRuleSets) {
            int rulesBefore = ruleSet.size();
            RuleSet filteredRuleSet = RuleSetUtil.newCopyOf(ruleSet);
            if (preferences.getGlobalRuleManagement()) {
                ArrayList<Rule> rulesToKeep = new ArrayList<Rule>();
                for (Rule rule : filteredRuleSet.getRules()) {
                    if (!onlyActiveRuleNames.contains(rule.getName())) continue;
                    rulesToKeep.add(rule);
                }
                int rulesAfter = (filteredRuleSet = RuleSetUtil.retainOnly(filteredRuleSet, rulesToKeep)).size();
                if (rulesAfter < rulesBefore) {
                    LOG.warn("Ruleset has been filtered as Global Rule Management is active. {} of {} rules are active and are used. {} rules will be ignored.", new Object[]{rulesAfter, rulesBefore, rulesBefore - rulesAfter});
                }
            }
            filteredRuleSet = InternalRuleSetUtil.addExcludePatterns(filteredRuleSet, InternalRuleSetUtil.convertStringPatterns(preferences.activeExclusionPatterns()), InternalRuleSetUtil.convertStringPatterns(properties.getBuildPathExcludePatterns()));
            filteredRuleSet = InternalRuleSetUtil.addIncludePatterns(filteredRuleSet, InternalRuleSetUtil.convertStringPatterns(preferences.activeInclusionPatterns()), InternalRuleSetUtil.convertStringPatterns(properties.getBuildPathIncludePatterns()));
            filteredRuleSets.add(filteredRuleSet);
        }
        this.taskScope(InternalRuleSetUtil.countRules(filteredRuleSets), InternalRuleSetUtil.countRules(projectRuleSets));
        return filteredRuleSets;
    }

    private List<RuleSet> rulesetsFromResourceDelta() throws PropertiesException {
        IResource resource = this.resourceDelta.getResource();
        IProject project = resource.getProject();
        IProjectProperties properties = this.getProjectProperties(project);
        return this.filteredRuleSets(properties);
    }

    private void processResourceDelta() {
        try {
            IResource resource = this.resourceDelta.getResource();
            IProject project = resource.getProject();
            IProjectProperties properties = this.getProjectProperties(project);
            LOG.info("ReviewCodeCmd started on resource delta {} in {}", (Object)resource.getName(), (Object)project);
            List<RuleSet> ruleSets = this.rulesetsFromResourceDelta();
            Set<String> fileExtensions = this.determineFileExtensions(ruleSets);
            int targetCount = this.countDeltaElement(this.resourceDelta);
            if (properties.isFullBuildEnabled() || this.isUserInitiated() || targetCount <= 5) {
                this.setStepCount(targetCount);
                LOG.debug("Visiting delta of resource {}: {}", (Object)resource.getName(), (Object)this.getStepCount());
                DeltaVisitor visitor = new DeltaVisitor();
                visitor.setMonitor(this.getMonitor());
                visitor.setRuleSetList(ruleSets);
                visitor.setFileExtensions(fileExtensions);
                visitor.setAccumulator(this.markersByFile);
                visitor.setProjectProperties(properties);
                this.resourceDelta.accept((IResourceDeltaVisitor)visitor);
                this.ruleCount = InternalRuleSetUtil.countRules(ruleSets);
                this.fileCount += visitor.getProcessedFilesCount();
                this.pmdDuration += visitor.getActualPmdDuration();
            } else {
                LOG.info("Skipping resourceDelta {} because of fullBuildEnabled flag and targetCount is {}. This is more than {}. If you want to execute PMD, please check \"Full build enabled\" in the project settings.", new Object[]{resource.getName(), targetCount, 5});
            }
        }
        catch (PropertiesException | CoreException e) {
            throw new RuntimeException(e);
        }
    }

    private void applyMarkers() {
        block8: {
            LOG.debug("Processing marker directives");
            int violationCount = 0;
            long start = System.currentTimeMillis();
            String currentFile = "";
            this.beginTask("PMD Applying markers", this.markersByFile.size());
            try {
                try {
                    for (IFile file : this.markersByFile.keySet()) {
                        if (!this.isCanceled()) {
                            currentFile = file.getName();
                            Set<MarkerInfo2> markerInfoSet = this.markersByFile.get(file);
                            for (MarkerInfo2 markerInfo : markerInfoSet) {
                                markerInfo.addAsMarkerTo(file);
                                ++violationCount;
                            }
                            this.worked(1);
                            continue;
                        }
                        break;
                    }
                }
                catch (CoreException e) {
                    LOG.warn("CoreException when setting marker for file {}: {}", new Object[]{currentFile, e.toString(), e});
                    long duration = System.currentTimeMillis() - start;
                    int count = this.markersByFile.size();
                    LOG.debug("applyMarkers: {} markers applied on {} files in {} ms.", new Object[]{violationCount, count, duration});
                    LOG.info("End of processing marker directives. " + violationCount + " violations for " + count + " files.");
                    break block8;
                }
            }
            catch (Throwable throwable) {
                long duration = System.currentTimeMillis() - start;
                int count = this.markersByFile.size();
                LOG.debug("applyMarkers: {} markers applied on {} files in {} ms.", new Object[]{violationCount, count, duration});
                LOG.info("End of processing marker directives. " + violationCount + " violations for " + count + " files.");
                throw throwable;
            }
            long duration = System.currentTimeMillis() - start;
            int count = this.markersByFile.size();
            LOG.debug("applyMarkers: {} markers applied on {} files in {} ms.", new Object[]{violationCount, count, duration});
            LOG.info("End of processing marker directives. " + violationCount + " violations for " + count + " files.");
        }
    }

    private int countResourceElement(IResource resource, Set<String> fileExtensions) {
        boolean checkFileExtensions = PMDPlugin.getDefault().loadPreferences().isDetermineFiletypesAutomatically();
        if (resource instanceof IFile) {
            if (checkFileExtensions && fileExtensions != null) {
                String extension = resource.getFileExtension();
                if (extension != null && fileExtensions.contains(extension.toLowerCase(Locale.ROOT))) {
                    return 1;
                }
                return 0;
            }
            return 1;
        }
        CountVisitor2 visitor = new CountVisitor2(checkFileExtensions, resource.getProject(), fileExtensions);
        try {
            resource.accept((IResourceVisitor)visitor);
        }
        catch (CoreException e) {
            LOG.error("Exception when counting elements of a project: {}", (Object)e.toString(), (Object)e);
        }
        return visitor.getCount();
    }

    private int countDeltaElement(IResourceDelta delta) {
        CountVisitor visitor = new CountVisitor();
        try {
            delta.accept((IResourceDeltaVisitor)visitor);
        }
        catch (CoreException e) {
            LOG.error("Exception counting elements in a delta selection: {}", (Object)e.toString(), (Object)e);
        }
        return visitor.count;
    }

    private static void switchToPmdPerspective() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IPerspectiveRegistry reg = workbench.getPerspectiveRegistry();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        window.getActivePage().setPerspective(reg.findPerspectiveWithId("net.sourceforge.pmd.eclipse.ui.views.pmdPerspective"));
    }

    private final class CountVisitor
    implements IResourceVisitor,
    IResourceDeltaVisitor {
        public int count = 0;

        private CountVisitor() {
        }

        public boolean visit(IResource resource) {
            if (resource instanceof IFile) {
                ++this.count;
            }
            return true;
        }

        public boolean visit(IResourceDelta delta) {
            IResource resource = delta.getResource();
            return this.visit(resource);
        }
    }

    private static class CountVisitor2
    implements IResourceVisitor {
        private final boolean useFileExtensions;
        private final Map<IProject, Set<String>> fileExtensionsPerProject;
        private int count;

        CountVisitor2(boolean useFileExtensions, Map<IProject, Set<String>> fileExtensionsPerProject) {
            this.useFileExtensions = useFileExtensions;
            this.fileExtensionsPerProject = fileExtensionsPerProject;
        }

        CountVisitor2(boolean useFileExtensions, IProject project, Set<String> fileExtensions) {
            this.useFileExtensions = useFileExtensions;
            this.fileExtensionsPerProject = new HashMap<IProject, Set<String>>();
            this.fileExtensionsPerProject.put(project, fileExtensions);
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource instanceof IFile) {
                if (this.useFileExtensions) {
                    Set<String> extensions = this.fileExtensionsPerProject.get(resource.getProject());
                    String extension = resource.getFileExtension();
                    if (extensions != null && extension != null && extensions.contains(extension.toLowerCase(Locale.ROOT))) {
                        ++this.count;
                    }
                } else {
                    ++this.count;
                }
            }
            return true;
        }

        public int getCount() {
            return this.count;
        }
    }
}

