/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.runtime.cmd;

import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.PmdAnalysis;
import net.sourceforge.pmd.eclipse.runtime.cmd.AbstractDefaultCommand;
import net.sourceforge.pmd.eclipse.ui.actions.RuleSetUtil;
import net.sourceforge.pmd.eclipse.util.internal.IOUtil;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.lang.rule.RuleSet;
import net.sourceforge.pmd.reporting.Report;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPropertyListener;

public class ReviewResourceForRuleCommand
extends AbstractDefaultCommand {
    private IResource resource;
    private Rule rule;
    private List<IPropertyListener> listenerList;

    public ReviewResourceForRuleCommand() {
        super("ReviewResourceForRuleCommand", "Review a resource for a specific rule.");
        this.setOutputProperties(true);
        this.setReadOnly(true);
        this.setTerminated(false);
        this.listenerList = new ArrayList<IPropertyListener>();
    }

    public void setResource(IResource resource) {
        this.resource = resource;
    }

    public void setRule(Rule rule) {
        this.rule = rule;
    }

    public void addPropertyListener(IPropertyListener listener) {
        this.listenerList.add(listener);
    }

    @Override
    public boolean isReadyToExecute() {
        return this.resource != null && this.rule != null;
    }

    @Override
    public void reset() {
        this.setResource(null);
        this.setRule(null);
        this.listenerList = new ArrayList<IPropertyListener>();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void execute() {
        Report report;
        block15: {
            IFile file = (IFile)this.resource.getAdapter(IFile.class);
            this.beginTask("PMD checking for rule: " + this.rule.getName(), 1);
            if (file == null) return;
            RuleSet ruleSet = RuleSetUtil.newSingle(this.rule);
            File sourceCodeFile = file.getFullPath().toFile();
            FileId fileId = FileId.fromPathLikeString((String)sourceCodeFile.toString());
            PMDConfiguration configuration = new PMDConfiguration();
            report = null;
            try {
                Throwable throwable = null;
                Object var8_10 = null;
                try {
                    InputStreamReader input = new InputStreamReader(file.getContents(), file.getCharset());
                    try {
                        try (PmdAnalysis pmdAnalysis = PmdAnalysis.create((PMDConfiguration)configuration);){
                            pmdAnalysis.addRuleSet(ruleSet);
                            pmdAnalysis.files().addSourceFile(fileId, IOUtil.toString(input));
                            report = pmdAnalysis.performAnalysisAndCollectReport();
                        }
                        if (input == null) break block15;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (input == null) throw throwable;
                        ((Reader)input).close();
                        throw throwable;
                    }
                    ((Reader)input).close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        final Report finalResult = report;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                for (IPropertyListener listener : ReviewResourceForRuleCommand.this.listenerList) {
                    listener.propertyChanged(finalResult.getViolations().iterator(), 1112);
                }
            }
        });
    }
}

