/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.runtime.preferences.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.eclipse.core.IRuleSetManager;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.preferences.IPreferences;
import net.sourceforge.pmd.eclipse.runtime.preferences.IPreferencesManager;
import net.sourceforge.pmd.eclipse.ui.priority.PriorityDescriptor;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.lang.rule.RulePriority;
import net.sourceforge.pmd.lang.rule.RuleSet;

class PreferencesImpl
implements IPreferences {
    private Map<String, Boolean> booleansById = new HashMap<String, Boolean>();
    private IPreferencesManager preferencesManager;
    private boolean projectBuildPathEnabled;
    private boolean pmdPerspectiveEnabled;
    private boolean pmdViolationsOverviewEnabled;
    private boolean pmdViolationsOutlineEnabled;
    private boolean checkAfterSaveEnabled;
    private boolean useCustomPriorityNames;
    private boolean determineFiletypesAutomatically;
    private String reviewAdditionalComment;
    private boolean reviewPmdStyleEnabled;
    private int minTileSize;
    private String logFileName;
    private String logLevel;
    private boolean globalRuleManagement;
    private Set<String> activeRuleNames = new HashSet<String>();
    private Set<String> activeRendererNames = new HashSet<String>();
    private Set<String> activeExclusionPatterns = new HashSet<String>();
    private Set<String> activeInclusionPatterns = new HashSet<String>();
    private Map<RulePriority, PriorityDescriptor> uiDescriptorsByPriority = new HashMap<RulePriority, PriorityDescriptor>(5);
    private int tableFraction;
    private Set<String> hiddenColumnIds;
    private boolean sortDirectionUp;
    private String groupingColumn;
    private Set<String> selectedRuleNames;
    private int selectedPropertyTab;

    PreferencesImpl(IPreferencesManager preferencesManager) {
        this.preferencesManager = preferencesManager;
    }

    @Override
    public boolean boolFor(String prefId) {
        Boolean value = this.booleansById.get(prefId);
        if (value == null) {
            throw new IllegalArgumentException("Unknown pref id: " + prefId);
        }
        return value;
    }

    @Override
    public void boolFor(String prefId, boolean newValue) {
        this.booleansById.put(prefId, newValue);
    }

    @Override
    public boolean isProjectBuildPathEnabled() {
        return this.projectBuildPathEnabled;
    }

    @Override
    public void setProjectBuildPathEnabled(boolean theProjectBuildPathEnabled) {
        this.projectBuildPathEnabled = theProjectBuildPathEnabled;
    }

    @Override
    public boolean isPmdPerspectiveEnabled() {
        return this.pmdPerspectiveEnabled;
    }

    @Override
    public boolean isCheckAfterSaveEnabled() {
        return this.checkAfterSaveEnabled;
    }

    @Override
    public void isCheckAfterSaveEnabled(boolean flag) {
        this.checkAfterSaveEnabled = flag;
    }

    @Override
    public void setPmdPerspectiveEnabled(boolean thePmdPerspectiveEnabled) {
        this.pmdPerspectiveEnabled = thePmdPerspectiveEnabled;
    }

    @Override
    public void setPmdViolationsOverviewEnabled(boolean thePmdViolationsOverviewEnabled) {
        this.pmdViolationsOverviewEnabled = thePmdViolationsOverviewEnabled;
    }

    @Override
    public boolean isDetermineFiletypesAutomatically() {
        return this.determineFiletypesAutomatically;
    }

    @Override
    public void setDetermineFiletypesAutomatically(boolean newDetermineFiletypesAutomatically) {
        this.determineFiletypesAutomatically = newDetermineFiletypesAutomatically;
    }

    @Override
    public String getReviewAdditionalComment() {
        return this.reviewAdditionalComment;
    }

    @Override
    public void setReviewAdditionalComment(String newReviewAdditionalComment) {
        this.reviewAdditionalComment = newReviewAdditionalComment;
    }

    @Override
    public boolean isReviewPmdStyleEnabled() {
        return this.reviewPmdStyleEnabled;
    }

    @Override
    public void setReviewPmdStyleEnabled(boolean newReviewPmdStyleEnabled) {
        this.reviewPmdStyleEnabled = newReviewPmdStyleEnabled;
    }

    @Override
    public int getMinTileSize() {
        return this.minTileSize;
    }

    @Override
    public void setMinTileSize(int newMinTileSize) {
        this.minTileSize = newMinTileSize;
    }

    @Override
    public String getLogFileName() {
        return this.logFileName;
    }

    @Override
    public String getLogLevelName() {
        return this.logLevel;
    }

    @Override
    public void setLogFileName(String theLogFileName) {
        this.logFileName = theLogFileName;
    }

    @Override
    public void setLogLevel(String level) {
        this.logLevel = level;
    }

    @Override
    public void sync() {
        this.preferencesManager.storePreferences(this);
    }

    @Override
    public boolean getGlobalRuleManagement() {
        return this.globalRuleManagement;
    }

    @Override
    public void setGlobalRuleManagement(boolean b) {
        this.globalRuleManagement = b;
    }

    @Override
    public boolean isActive(String ruleName) {
        return this.activeRuleNames.contains(ruleName);
    }

    @Override
    public boolean isActiveRenderer(String rendererName) {
        return this.activeRendererNames.contains(rendererName);
    }

    @Override
    public void isActive(String ruleName, boolean isActive) {
        if (isActive) {
            this.activeRuleNames.add(ruleName);
        } else {
            this.activeRuleNames.remove(ruleName);
        }
    }

    @Override
    public Set<String> getActiveRuleNames() {
        return this.activeRuleNames;
    }

    @Override
    public String getDefaultActiveRules() {
        StringBuilder rules = new StringBuilder();
        IRuleSetManager ruleSetManager = PMDPlugin.getDefault().getRuleSetManager();
        for (RuleSet ruleSet : ruleSetManager.getDefaultRuleSets()) {
            for (Rule rule : ruleSet.getRules()) {
                if (rules.length() > 0) {
                    rules.append(',');
                }
                rules.append(rule.getName());
            }
        }
        return rules.toString();
    }

    @Override
    public void setActiveRuleNames(Set<String> ruleNames) {
        this.activeRuleNames = ruleNames;
    }

    @Override
    public Set<String> activeExclusionPatterns() {
        return this.activeExclusionPatterns;
    }

    @Override
    public void activeExclusionPatterns(Set<String> patterns) {
        this.activeExclusionPatterns = patterns;
    }

    @Override
    public Set<String> activeInclusionPatterns() {
        return this.activeInclusionPatterns;
    }

    @Override
    public void activeInclusionPatterns(Set<String> patterns) {
        this.activeInclusionPatterns = patterns;
    }

    @Override
    public void setPriorityDescriptor(RulePriority priority, PriorityDescriptor pd) {
        this.uiDescriptorsByPriority.put(priority, pd);
    }

    @Override
    public PriorityDescriptor getPriorityDescriptor(RulePriority priority) {
        return this.uiDescriptorsByPriority.get(priority);
    }

    @Override
    public boolean useCustomPriorityNames() {
        return this.useCustomPriorityNames;
    }

    @Override
    public void useCustomPriorityNames(boolean flag) {
        this.useCustomPriorityNames = flag;
    }

    @Override
    public Set<String> activeReportRenderers() {
        return this.activeRendererNames;
    }

    @Override
    public void activeReportRenderers(Set<String> names) {
        this.activeRendererNames = names;
    }

    @Override
    public boolean isPmdViolationsOverviewEnabled() {
        return this.pmdViolationsOverviewEnabled;
    }

    @Override
    public boolean isPmdViolationsOutlineEnabled() {
        return this.pmdViolationsOutlineEnabled;
    }

    @Override
    public void setPmdViolationsOutlineEnabled(boolean pmdViolationsOutlineEnabled) {
        this.pmdViolationsOutlineEnabled = pmdViolationsOutlineEnabled;
    }

    @Override
    public int tableFraction() {
        return this.tableFraction;
    }

    @Override
    public void tableFraction(int aFraction) {
        this.tableFraction = aFraction;
    }

    @Override
    public Set<String> getHiddenColumnIds() {
        return this.hiddenColumnIds;
    }

    @Override
    public void setHiddenColumnIds(Set<String> names) {
        this.hiddenColumnIds = names;
    }

    @Override
    public boolean isSortDirectionUp() {
        return this.sortDirectionUp;
    }

    @Override
    public void setSortDirectionUp(boolean isUp) {
        this.sortDirectionUp = isUp;
    }

    @Override
    public String getGroupingColumn() {
        return this.groupingColumn;
    }

    @Override
    public void setGroupingColumn(String columnName) {
        this.groupingColumn = columnName;
    }

    @Override
    public Set<String> getSelectedRuleNames() {
        return this.selectedRuleNames;
    }

    @Override
    public void setSelectedRuleNames(Set<String> ruleNames) {
        this.selectedRuleNames = ruleNames;
    }

    @Override
    public int getSelectedPropertyTab() {
        return this.selectedPropertyTab;
    }

    @Override
    public void setSelectedPropertyTab(int anIndex) {
        this.selectedPropertyTab = anIndex;
    }
}

