/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.runtime.preferences.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.sourceforge.pmd.eclipse.core.IRuleSetManager;
import net.sourceforge.pmd.eclipse.core.internal.FileModificationUtil;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.preferences.IPreferences;
import net.sourceforge.pmd.eclipse.runtime.preferences.IPreferencesManager;
import net.sourceforge.pmd.eclipse.runtime.preferences.impl.PreferencesFactoryImpl;
import net.sourceforge.pmd.eclipse.runtime.properties.IProjectProperties;
import net.sourceforge.pmd.eclipse.runtime.properties.PropertiesException;
import net.sourceforge.pmd.eclipse.runtime.writer.IRuleSetWriter;
import net.sourceforge.pmd.eclipse.runtime.writer.WriterException;
import net.sourceforge.pmd.eclipse.ui.Shape;
import net.sourceforge.pmd.eclipse.ui.actions.RuleSetUtil;
import net.sourceforge.pmd.eclipse.ui.actions.internal.InternalRuleSetUtil;
import net.sourceforge.pmd.eclipse.ui.priority.PriorityDescriptor;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.lang.rule.RulePriority;
import net.sourceforge.pmd.lang.rule.RuleSet;
import net.sourceforge.pmd.lang.rule.RuleSetLoadException;
import net.sourceforge.pmd.lang.rule.RuleSetLoader;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.graphics.RGB;
import org.osgi.service.prefs.BackingStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PreferencesManagerImpl
implements IPreferencesManager {
    private static final Logger LOG = LoggerFactory.getLogger(PreferencesManagerImpl.class);
    private static final String PROJECT_BUILD_PATH_ENABLED = "net.sourceforge.pmd.eclipse.plugin.project_build_path_enabled";
    private static final String PMD_PERSPECTIVE_ENABLED = "net.sourceforge.pmd.eclipse.plugin.pmd_perspective_enabled";
    private static final String PMD_VIOLATIONS_OVERVIEW_ENABLED = "net.sourceforge.pmd.eclipse.plugin.pmd_overview_enabled";
    private static final String PMD_VIOLATIONS_OUTLINE_ENABLED = "net.sourceforge.pmd.eclipse.plugin.pmd_outline_enabled";
    private static final String PMD_CHECK_AFTER_SAVE_ENABLED = "net.sourceforge.pmd.eclipse.plugin.pmd_check_after_save_enabled";
    private static final String DETERMINE_FILETYPES_AUTOMATICALLY = "net.sourceforge.pmd.eclipse.plugin.determine_filetypes_automatically";
    private static final String REVIEW_ADDITIONAL_COMMENT = "net.sourceforge.pmd.eclipse.plugin.review_additional_comment";
    private static final String REVIEW_PMD_STYLE_ENABLED = "net.sourceforge.pmd.eclipse.plugin.review_pmd_style_enabled";
    private static final String PMD_USE_CUSTOM_PRIORITY_NAMES = "net.sourceforge.pmd.eclipse.plugin.use_custom_priority_names";
    private static final String MIN_TILE_SIZE = "net.sourceforge.pmd.eclipse.plugin.min_tile_size";
    private static final String LOG_FILENAME = "net.sourceforge.pmd.eclipse.plugin.log_filename";
    private static final String LOG_LEVEL = "net.sourceforge.pmd.eclipse.plugin.log_level";
    private static final String GLOBAL_RULE_MANAGEMENT = "net.sourceforge.pmd.eclipse.plugin.globalRuleManagement";
    private static final String ACTIVE_RULES = "net.sourceforge.pmd.eclipse.plugin.active_rules";
    private static final String ACTIVE_RENDERERS = "net.sourceforge.pmd.eclipse.plugin.active_renderers";
    private static final String ACTIVE_EXCLUSIONS = "net.sourceforge.pmd.eclipse.plugin.active_exclusions";
    private static final String ACTIVE_INCLUSIONS = "net.sourceforge.pmd.eclipse.plugin.active_inclusions";
    private static final String TABLE_FRACTION = "net.sourceforge.pmd.eclipse.plugin.ruletable.fraction";
    private static final String TABLE_HIDDEN_COLS = "net.sourceforge.pmd.eclipse.plugin.ruletable.hiddenColumns";
    private static final String TABLE_COLUMN_SORT_UP = "net.sourceforge.pmd.eclipse.plugin.ruletable.sortUp";
    private static final String GROUPING_COLUMN = "net.sourceforge.pmd.eclipse.plugin.ruletable.groupingColumn";
    private static final String SELECTED_RULE_NAMES = "net.sourceforge.pmd.eclipse.plugin.ruletable.selectedRules";
    private static final String SELECTED_PROPERTY_TAB = "net.sourceforge.pmd.eclipse.plugin.ruletable.selectedPropertyTab";
    private static final String OLD_PREFERENCE_PREFIX = "net.sourceforge.pmd.runtime";
    private static final String OLD_PREFERENCE_LOCATION = "/.metadata/.plugins/org.eclipse.core.runtime/.settings/net.sourceforge.pmd.runtime.prefs";
    private static final String NEW_PREFERENCE_LOCATION = "/.metadata/.plugins/org.eclipse.core.runtime/.settings/net.sourceforge.pmd.eclipse.plugin.prefs";
    private static final String PREFERENCE_RULESET_FILE = "/ruleset.xml";
    private static final Map<RulePriority, PriorityDescriptor> DEFAULT_DESCRIPTORS_BY_PRIORITY = new HashMap<RulePriority, PriorityDescriptor>(5);
    private static final Map<RulePriority, String> STORE_KEYS_BY_PRIORITY = new HashMap<RulePriority, String>(5);
    private IPreferences preferences;
    private long preferencesTimestamp;
    private IPreferenceStore storePreferencesStore = PMDPlugin.getDefault().getPreferenceStore();
    private IPreferenceStore loadPreferencesStore;
    private RuleSet ruleSet;
    private long ruleSetModificationTimestamp;

    static {
        DEFAULT_DESCRIPTORS_BY_PRIORITY.put(RulePriority.HIGH, new PriorityDescriptor(RulePriority.HIGH, "view.filter.priority.1", "view.tooltip.filter.priority", null, Shape.triangleRight, new RGB(255, 0, 0), 13));
        DEFAULT_DESCRIPTORS_BY_PRIORITY.put(RulePriority.MEDIUM_HIGH, new PriorityDescriptor(RulePriority.MEDIUM_HIGH, "view.filter.priority.2", "view.tooltip.filter.priority", null, Shape.triangleRight, new RGB(0, 255, 255), 13));
        DEFAULT_DESCRIPTORS_BY_PRIORITY.put(RulePriority.MEDIUM, new PriorityDescriptor(RulePriority.MEDIUM, "view.filter.priority.3", "view.tooltip.filter.priority", null, Shape.triangleRight, new RGB(0, 255, 0), 13));
        DEFAULT_DESCRIPTORS_BY_PRIORITY.put(RulePriority.MEDIUM_LOW, new PriorityDescriptor(RulePriority.MEDIUM_LOW, "view.filter.priority.4", "view.tooltip.filter.priority", null, Shape.triangleRight, new RGB(255, 0, 255), 13));
        DEFAULT_DESCRIPTORS_BY_PRIORITY.put(RulePriority.LOW, new PriorityDescriptor(RulePriority.LOW, "view.filter.priority.5", "view.tooltip.filter.priority", null, Shape.triangleRight, new RGB(0, 0, 255), 13));
        STORE_KEYS_BY_PRIORITY.put(RulePriority.HIGH, "net.sourceforge.pmd.eclipse.plugin.priority_descriptor_1");
        STORE_KEYS_BY_PRIORITY.put(RulePriority.MEDIUM_HIGH, "net.sourceforge.pmd.eclipse.plugin.priority_descriptor_2");
        STORE_KEYS_BY_PRIORITY.put(RulePriority.MEDIUM, "net.sourceforge.pmd.eclipse.plugin.priority_descriptor_3");
        STORE_KEYS_BY_PRIORITY.put(RulePriority.MEDIUM_LOW, "net.sourceforge.pmd.eclipse.plugin.priority_descriptor_4");
        STORE_KEYS_BY_PRIORITY.put(RulePriority.LOW, "net.sourceforge.pmd.eclipse.plugin.priority_descriptor_5");
    }

    PreferencesManagerImpl() {
    }

    @Override
    public PriorityDescriptor defaultDescriptorFor(RulePriority priority) {
        return DEFAULT_DESCRIPTORS_BY_PRIORITY.get(priority);
    }

    @Override
    public IPreferences loadPreferences() {
        if (this.preferences == null) {
            this.reloadPreferences();
        } else if (this.preferencesTimestamp != this.getPreferencesTimestamp()) {
            LOG.info("Workspace Preferences for PMD Plugin changed on disk - reloading");
            if (this.loadPreferencesStore.needsSaving()) {
                LOG.warn("Any preference changes done in this eclipse instance are lost!");
            }
            IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(PMDPlugin.getDefault().getBundle().getSymbolicName());
            try {
                prefs.sync();
            }
            catch (BackingStoreException e) {
                LOG.error("Error while reloading preferences for PMD", (Throwable)e);
            }
            this.reloadPreferences();
        }
        return this.preferences;
    }

    private long getPreferencesTimestamp() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IPath path = root.getLocation().append(NEW_PREFERENCE_LOCATION);
        File newPrefs = path.toFile();
        return FileModificationUtil.getFileModificationTimestamp(newPrefs);
    }

    @Override
    public IPreferences reloadPreferences() {
        this.initLoadPreferencesStore();
        PreferencesFactoryImpl factory = new PreferencesFactoryImpl();
        this.preferences = factory.newPreferences(this);
        this.loadProjectBuildPathEnabled();
        this.loadPmdPerspectiveEnabled();
        this.loadPmdViolationsOverviewEnabled();
        this.loadPmdViolationsOutlineEnabled();
        this.loadCheckAfterSaveEnabled();
        this.loadUseCustomPriorityNames();
        this.loadDetermineFiletypesAutomatically();
        this.loadReviewAdditionalComment();
        this.loadReviewPmdStyleEnabled();
        this.loadMinTileSize();
        this.loadLogFileName();
        this.loadLogLevel();
        this.loadGlobalRuleManagement();
        this.loadActiveRules();
        this.loadActiveReportRenderers();
        this.loadActiveExclusions();
        this.loadActiveInclusions();
        this.loadRulePriorityDescriptors();
        this.loadTableFraction();
        this.loadHiddenColumnIds();
        this.loadSortDirectionUp();
        this.loadGroupingColumn();
        this.loadSelectedRuleNames();
        this.loadSelectedPropertyTab();
        this.preferencesTimestamp = this.getPreferencesTimestamp();
        return this.preferences;
    }

    private void initLoadPreferencesStore() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IPath path = root.getLocation();
        File newPrefs = new File(path.append(NEW_PREFERENCE_LOCATION).toString());
        File oldPrefs = new File(path.append(OLD_PREFERENCE_LOCATION).toString());
        this.loadPreferencesStore = this.storePreferencesStore;
        if (!newPrefs.exists() && oldPrefs.exists()) {
            try {
                Properties props = new Properties();
                Throwable throwable = null;
                Iterator<Map.Entry<Object, Object>> iterator = null;
                try (InputStream in = Files.newInputStream(oldPrefs.toPath(), new OpenOption[0]);){
                    props.load(in);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                this.loadPreferencesStore = new PreferenceStore();
                for (Map.Entry<Object, Object> entry : props.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.startsWith(OLD_PREFERENCE_PREFIX)) {
                        key = key.replaceFirst(OLD_PREFERENCE_PREFIX, "net.sourceforge.pmd.eclipse.plugin");
                    }
                    this.loadPreferencesStore.putValue(key, (String)entry.getValue());
                }
            }
            catch (IOException ioe) {
                PMDPlugin.getDefault().logError("IOException in loading old format preferences", ioe);
                this.loadPreferencesStore = this.storePreferencesStore;
            }
        }
    }

    @Override
    public void storePreferences(IPreferences thePreferences) {
        this.preferences = thePreferences;
        this.storeProjectBuildPathEnabled();
        this.storePmdPerspectiveEnabled();
        this.storePmdViolationsOverviewEnabled();
        this.storePmdViolationsOutlineEnabled();
        this.storeCheckAfterSaveEnabled();
        this.storeUseCustomPriorityNames();
        this.storeDetermineFiletypesAutomatically();
        this.storeReviewAdditionalComment();
        this.storeReviewPmdStyleEnabled();
        this.storeMinTileSize();
        this.storeLogFileName();
        this.storeLogLevel();
        this.storeGlobalRuleManagement();
        this.storeActiveRules();
        this.storeActiveReportRenderers();
        this.storeActiveExclusions();
        this.storeActiveInclusions();
        this.storePriorityDescriptors();
        this.storeTableFraction();
        this.storeHiddenColumnIds();
        this.storeSortDirectionUp();
        this.storeGroupingColumn();
        this.storeSelectedRuleNames();
        this.storeSelectedPropertyTab();
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(PMDPlugin.getDefault().getBundle().getSymbolicName());
        try {
            prefs.flush();
            this.preferencesTimestamp = this.getPreferencesTimestamp();
        }
        catch (BackingStoreException e) {
            LOG.error("Error while storing preferences for PMD", (Throwable)e);
        }
    }

    @Override
    public RuleSet getRuleSet() {
        if (this.ruleSet == null) {
            LOG.debug("First time loading ruleset from state store");
            this.ruleSet = this.getRuleSetFromStateLocation();
        } else if (this.ruleSetModificationTimestamp != this.getRuleSetModificationTimestamp()) {
            LOG.info("RuleSet in state store changed on disk - reloading");
            RuleSet newRuleSet = this.getRuleSetFromStateLocation();
            this.updateConfiguredProjects(newRuleSet);
            this.ruleSet = newRuleSet;
        }
        return this.ruleSet;
    }

    @Override
    public void setRuleSet(RuleSet newRuleSet) {
        this.updateConfiguredProjects(newRuleSet);
        this.ruleSet = newRuleSet;
        this.storeRuleSetInStateLocation(this.ruleSet);
    }

    private void loadProjectBuildPathEnabled() {
        this.loadPreferencesStore.setDefault(PROJECT_BUILD_PATH_ENABLED, true);
        this.preferences.setProjectBuildPathEnabled(this.loadPreferencesStore.getBoolean(PROJECT_BUILD_PATH_ENABLED));
    }

    private void loadPmdPerspectiveEnabled() {
        this.loadPreferencesStore.setDefault(PMD_PERSPECTIVE_ENABLED, true);
        this.preferences.setPmdPerspectiveEnabled(this.loadPreferencesStore.getBoolean(PMD_PERSPECTIVE_ENABLED));
    }

    private void loadPmdViolationsOverviewEnabled() {
        this.loadPreferencesStore.setDefault(PMD_VIOLATIONS_OVERVIEW_ENABLED, false);
        this.preferences.setPmdViolationsOverviewEnabled(this.loadPreferencesStore.getBoolean(PMD_VIOLATIONS_OVERVIEW_ENABLED));
    }

    private void loadPmdViolationsOutlineEnabled() {
        this.loadPreferencesStore.setDefault(PMD_VIOLATIONS_OUTLINE_ENABLED, false);
        this.preferences.setPmdViolationsOutlineEnabled(this.loadPreferencesStore.getBoolean(PMD_VIOLATIONS_OUTLINE_ENABLED));
    }

    private void loadCheckAfterSaveEnabled() {
        this.loadPreferencesStore.setDefault(PMD_CHECK_AFTER_SAVE_ENABLED, false);
        this.preferences.isCheckAfterSaveEnabled(this.loadPreferencesStore.getBoolean(PMD_CHECK_AFTER_SAVE_ENABLED));
    }

    private void loadUseCustomPriorityNames() {
        this.loadPreferencesStore.setDefault(PMD_USE_CUSTOM_PRIORITY_NAMES, true);
        this.preferences.useCustomPriorityNames(this.loadPreferencesStore.getBoolean(PMD_USE_CUSTOM_PRIORITY_NAMES));
    }

    private void loadDetermineFiletypesAutomatically() {
        this.loadPreferencesStore.setDefault(DETERMINE_FILETYPES_AUTOMATICALLY, true);
        this.preferences.setDetermineFiletypesAutomatically(this.loadPreferencesStore.getBoolean(DETERMINE_FILETYPES_AUTOMATICALLY));
    }

    private void loadReviewAdditionalComment() {
        this.loadPreferencesStore.setDefault(REVIEW_ADDITIONAL_COMMENT, "by {0} on {1}");
        this.preferences.setReviewAdditionalComment(this.loadPreferencesStore.getString(REVIEW_ADDITIONAL_COMMENT));
    }

    private void loadReviewPmdStyleEnabled() {
        this.loadPreferencesStore.setDefault(REVIEW_PMD_STYLE_ENABLED, true);
        this.preferences.setReviewPmdStyleEnabled(this.loadPreferencesStore.getBoolean(REVIEW_PMD_STYLE_ENABLED));
    }

    private void loadMinTileSize() {
        this.loadPreferencesStore.setDefault(MIN_TILE_SIZE, 25);
        this.preferences.setMinTileSize(this.loadPreferencesStore.getInt(MIN_TILE_SIZE));
    }

    private void loadLogFileName() {
        this.loadPreferencesStore.setDefault(LOG_FILENAME, IPreferences.LOG_FILENAME_DEFAULT);
        this.preferences.setLogFileName(this.loadPreferencesStore.getString(LOG_FILENAME));
    }

    private void loadLogLevel() {
        this.loadPreferencesStore.setDefault(LOG_LEVEL, "WARN");
        this.preferences.setLogLevel(this.loadPreferencesStore.getString(LOG_LEVEL));
    }

    private void loadGlobalRuleManagement() {
        this.loadPreferencesStore.setDefault(GLOBAL_RULE_MANAGEMENT, false);
        this.preferences.setGlobalRuleManagement(this.loadPreferencesStore.getBoolean(GLOBAL_RULE_MANAGEMENT));
    }

    private void loadActiveRules() {
        this.loadPreferencesStore.setDefault(ACTIVE_RULES, this.preferences.getDefaultActiveRules());
        this.preferences.setActiveRuleNames(PreferencesManagerImpl.asStringSet(this.loadPreferencesStore.getString(ACTIVE_RULES), ","));
    }

    private void loadActiveReportRenderers() {
        this.loadPreferencesStore.setDefault(ACTIVE_RENDERERS, "text");
        this.preferences.activeReportRenderers(PreferencesManagerImpl.asStringSet(this.loadPreferencesStore.getString(ACTIVE_RENDERERS), ","));
    }

    private void loadActiveExclusions() {
        this.loadPreferencesStore.setDefault(ACTIVE_EXCLUSIONS, "");
        this.preferences.activeExclusionPatterns(PreferencesManagerImpl.asStringSet(this.loadPreferencesStore.getString(ACTIVE_EXCLUSIONS), ","));
    }

    private void loadActiveInclusions() {
        this.loadPreferencesStore.setDefault(ACTIVE_INCLUSIONS, "");
        this.preferences.activeInclusionPatterns(PreferencesManagerImpl.asStringSet(this.loadPreferencesStore.getString(ACTIVE_INCLUSIONS), ","));
    }

    private void loadRulePriorityDescriptors() {
        if (STORE_KEYS_BY_PRIORITY != null) {
            for (Map.Entry<RulePriority, String> entry : STORE_KEYS_BY_PRIORITY.entrySet()) {
                PriorityDescriptor defaultPriorityDescriptor = this.defaultDescriptorFor(entry.getKey());
                this.loadPreferencesStore.setDefault(entry.getValue(), defaultPriorityDescriptor.storeString());
                String storeKey = STORE_KEYS_BY_PRIORITY.get(entry.getKey());
                PriorityDescriptor loadedPriorityDescriptor = PriorityDescriptor.from(this.loadPreferencesStore.getString(storeKey));
                if (loadedPriorityDescriptor != null) {
                    this.preferences.setPriorityDescriptor(entry.getKey(), loadedPriorityDescriptor);
                    continue;
                }
                this.loadPreferencesStore.setValue(entry.getValue(), defaultPriorityDescriptor.storeString());
                this.preferences.setPriorityDescriptor(entry.getKey(), defaultPriorityDescriptor);
            }
        }
    }

    private void loadTableFraction() {
        this.loadPreferencesStore.setDefault(TABLE_FRACTION, 55);
        this.preferences.tableFraction(this.loadPreferencesStore.getInt(TABLE_FRACTION));
    }

    private static String defaultHiddenColumnIds() {
        return "tExtURL,tMinLang,fixCnt,tXmpCnt,tMaxLang,tSince,modCnt";
    }

    private void loadHiddenColumnIds() {
        this.loadPreferencesStore.setDefault(TABLE_HIDDEN_COLS, PreferencesManagerImpl.defaultHiddenColumnIds());
        this.preferences.setHiddenColumnIds(PreferencesManagerImpl.asStringSet(this.loadPreferencesStore.getString(TABLE_HIDDEN_COLS), ","));
    }

    private void loadSortDirectionUp() {
        this.loadPreferencesStore.setDefault(TABLE_COLUMN_SORT_UP, false);
        this.preferences.setSortDirectionUp(this.loadPreferencesStore.getBoolean(TABLE_COLUMN_SORT_UP));
    }

    private void loadGroupingColumn() {
        this.loadPreferencesStore.setDefault(GROUPING_COLUMN, "");
        this.preferences.setGroupingColumn(this.loadPreferencesStore.getString(GROUPING_COLUMN));
    }

    private void loadSelectedRuleNames() {
        this.loadPreferencesStore.setDefault(SELECTED_RULE_NAMES, "");
        this.preferences.setSelectedRuleNames(PreferencesManagerImpl.asStringSet(this.loadPreferencesStore.getString(SELECTED_RULE_NAMES), ","));
    }

    private void loadSelectedPropertyTab() {
        this.loadPreferencesStore.setDefault(SELECTED_PROPERTY_TAB, 0);
        this.preferences.setSelectedPropertyTab(this.loadPreferencesStore.getInt(SELECTED_PROPERTY_TAB));
    }

    private static Set<String> asStringSet(String delimitedString, String delimiter) {
        String[] values = delimitedString.split(delimiter);
        HashSet<String> valueSet = new HashSet<String>(values.length);
        int i = 0;
        while (i < values.length) {
            String name = values[i].trim();
            if (!StringUtils.isBlank((CharSequence)name)) {
                valueSet.add(name);
            }
            ++i;
        }
        return valueSet;
    }

    private static String asDelimitedString(Set<String> values, String delimiter) {
        if (values == null || values.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String value : values) {
            sb.append(delimiter).append(value);
        }
        return sb.toString();
    }

    private void storeGlobalRuleManagement() {
        this.storePreferencesStore.setValue(GLOBAL_RULE_MANAGEMENT, this.preferences.getGlobalRuleManagement());
    }

    private void storeActiveRules() {
        this.storePreferencesStore.setValue(ACTIVE_RULES, PreferencesManagerImpl.asDelimitedString(this.preferences.getActiveRuleNames(), ","));
    }

    private void storeActiveReportRenderers() {
        this.storePreferencesStore.setValue(ACTIVE_RENDERERS, PreferencesManagerImpl.asDelimitedString(this.preferences.activeReportRenderers(), ","));
    }

    private void storeActiveExclusions() {
        this.storePreferencesStore.setValue(ACTIVE_EXCLUSIONS, PreferencesManagerImpl.asDelimitedString(this.preferences.activeExclusionPatterns(), ","));
    }

    private void storeActiveInclusions() {
        this.storePreferencesStore.setValue(ACTIVE_INCLUSIONS, PreferencesManagerImpl.asDelimitedString(this.preferences.activeInclusionPatterns(), ","));
    }

    private void storeProjectBuildPathEnabled() {
        this.storePreferencesStore.setValue(PROJECT_BUILD_PATH_ENABLED, this.preferences.isProjectBuildPathEnabled());
    }

    private void storeCheckAfterSaveEnabled() {
        this.storePreferencesStore.setValue(PMD_CHECK_AFTER_SAVE_ENABLED, this.preferences.isCheckAfterSaveEnabled());
    }

    private void storeUseCustomPriorityNames() {
        this.storePreferencesStore.setValue(PMD_USE_CUSTOM_PRIORITY_NAMES, this.preferences.useCustomPriorityNames());
    }

    private void storePmdPerspectiveEnabled() {
        this.storePreferencesStore.setValue(PMD_PERSPECTIVE_ENABLED, this.preferences.isPmdPerspectiveEnabled());
    }

    private void storePmdViolationsOverviewEnabled() {
        this.storePreferencesStore.setValue(PMD_VIOLATIONS_OVERVIEW_ENABLED, this.preferences.isPmdViolationsOverviewEnabled());
    }

    private void storePmdViolationsOutlineEnabled() {
        this.storePreferencesStore.setValue(PMD_VIOLATIONS_OUTLINE_ENABLED, this.preferences.isPmdViolationsOutlineEnabled());
    }

    private void storeDetermineFiletypesAutomatically() {
        this.storePreferencesStore.setValue(DETERMINE_FILETYPES_AUTOMATICALLY, this.preferences.isDetermineFiletypesAutomatically());
    }

    private void storeReviewAdditionalComment() {
        this.storePreferencesStore.setValue(REVIEW_ADDITIONAL_COMMENT, this.preferences.getReviewAdditionalComment());
    }

    private void storeReviewPmdStyleEnabled() {
        this.storePreferencesStore.setValue(REVIEW_PMD_STYLE_ENABLED, this.preferences.isReviewPmdStyleEnabled());
    }

    private void storeMinTileSize() {
        this.storePreferencesStore.setValue(MIN_TILE_SIZE, this.preferences.getMinTileSize());
    }

    private void storeLogFileName() {
        this.storePreferencesStore.setValue(LOG_FILENAME, this.preferences.getLogFileName());
    }

    private void storeLogLevel() {
        this.storePreferencesStore.setValue(LOG_LEVEL, this.preferences.getLogLevelName());
    }

    private void storePriorityDescriptors() {
        for (Map.Entry<RulePriority, String> entry : STORE_KEYS_BY_PRIORITY.entrySet()) {
            PriorityDescriptor desc = this.preferences.getPriorityDescriptor(entry.getKey());
            this.storePreferencesStore.setValue(entry.getValue(), desc.storeString());
        }
    }

    private void storeTableFraction() {
        this.storePreferencesStore.setValue(TABLE_FRACTION, this.preferences.tableFraction());
    }

    private void storeHiddenColumnIds() {
        this.storePreferencesStore.setValue(TABLE_HIDDEN_COLS, PreferencesManagerImpl.asDelimitedString(this.preferences.getHiddenColumnIds(), ","));
    }

    private void storeSortDirectionUp() {
        this.storePreferencesStore.setValue(TABLE_COLUMN_SORT_UP, this.preferences.isSortDirectionUp());
    }

    private void storeGroupingColumn() {
        this.storePreferencesStore.setValue(GROUPING_COLUMN, this.preferences.getGroupingColumn());
    }

    private void storeSelectedRuleNames() {
        this.storePreferencesStore.setValue(SELECTED_RULE_NAMES, PreferencesManagerImpl.asDelimitedString(this.preferences.getSelectedRuleNames(), ","));
    }

    private void storeSelectedPropertyTab() {
        this.storePreferencesStore.setValue(SELECTED_PROPERTY_TAB, this.preferences.getSelectedPropertyTab());
    }

    private RuleSet getRuleSetFromStateLocation() {
        RuleSetLoader loader = InternalRuleSetUtil.getDefaultRuleSetLoader();
        RuleSet preferredRuleSet = null;
        IPath ruleSetLocation = PMDPlugin.getDefault().getStateLocation().append(PREFERENCE_RULESET_FILE);
        File ruleSetFile = ruleSetLocation.toFile();
        if (ruleSetFile.exists()) {
            try {
                preferredRuleSet = loader.loadFromResource(ruleSetLocation.toOSString());
                this.ruleSetModificationTimestamp = this.getRuleSetModificationTimestamp();
            }
            catch (RuleSetLoadException e) {
                LOG.error("Error when loading stored ruleset file. Falling back to default ruleset: {}", (Object)e.toString(), (Object)e);
                this.ruleSetModificationTimestamp = this.getRuleSetModificationTimestamp();
            }
        }
        if (preferredRuleSet == null) {
            preferredRuleSet = this.getDefaultRuleSet();
        }
        return preferredRuleSet;
    }

    private long getRuleSetModificationTimestamp() {
        IPath ruleSetLocation = PMDPlugin.getDefault().getStateLocation().append(PREFERENCE_RULESET_FILE);
        File ruleSetFile = ruleSetLocation.toFile();
        return FileModificationUtil.getFileModificationTimestamp(ruleSetFile);
    }

    @Override
    public RuleSet getDefaultRuleSet() {
        RuleSet defaultRuleSet = RuleSetUtil.newEmpty("pmd-eclipse", "PMD Plugin preferences rule set");
        IRuleSetManager ruleSetManager = PMDPlugin.getDefault().getRuleSetManager();
        for (RuleSet ruleSet : ruleSetManager.getDefaultRuleSets()) {
            defaultRuleSet = RuleSetUtil.addRuleSetByReference(defaultRuleSet, ruleSet);
        }
        return defaultRuleSet;
    }

    private Collection<Rule> getNewRules(RuleSet newRuleSet) {
        ArrayList<Rule> addedRules = new ArrayList<Rule>();
        for (Rule rule : newRuleSet.getRules()) {
            if (this.ruleSet.getRuleByName(rule.getName()) != null) continue;
            addedRules.add(rule);
        }
        return addedRules;
    }

    private void updateConfiguredProjects(RuleSet updatedRuleSet) {
        IProject[] projects;
        LOG.debug("Updating configured projects");
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isAccessible()) {
                try {
                    IProjectProperties properties = PMDPlugin.getDefault().loadProjectProperties(project);
                    List<RuleSet> projectRuleSets = properties.getProjectRuleSetList();
                    ArrayList<RuleSet> newProjectRuleSet = new ArrayList<RuleSet>();
                    if (projectRuleSets != null && !projectRuleSets.isEmpty()) {
                        RuleSet firstProjectRuleset = properties.getProjectRuleSet();
                        firstProjectRuleset = RuleSetUtil.addRules(firstProjectRuleset, this.getNewRules(updatedRuleSet));
                        firstProjectRuleset = InternalRuleSetUtil.setFileExclusions(firstProjectRuleset, updatedRuleSet.getFileExclusions());
                        firstProjectRuleset = InternalRuleSetUtil.setFileInclusions(firstProjectRuleset, updatedRuleSet.getFileInclusions());
                        newProjectRuleSet.add(firstProjectRuleset);
                        int i = 1;
                        while (i < projectRuleSets.size()) {
                            newProjectRuleSet.add(projectRuleSets.get(i));
                            ++i;
                        }
                        properties.setProjectRuleSetList(newProjectRuleSet);
                        properties.sync();
                    }
                }
                catch (PropertiesException e) {
                    PMDPlugin.getDefault().logError("Unable to add new rules for project: " + project, e);
                }
            }
            ++n2;
        }
    }

    private void storeRuleSetInStateLocation(RuleSet ruleSet) {
        PMDPlugin plugin = PMDPlugin.getDefault();
        IPath ruleSetLocation = plugin.getStateLocation().append(PREFERENCE_RULESET_FILE);
        try {
            Throwable throwable = null;
            Object var5_8 = null;
            try (OutputStream out = Files.newOutputStream(ruleSetLocation.toFile().toPath(), new OpenOption[0]);){
                IRuleSetWriter writer = plugin.getRuleSetWriter();
                writer.write(out, ruleSet);
                this.ruleSetModificationTimestamp = this.getRuleSetModificationTimestamp();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            plugin.logError("IO Exception when storing ruleset in state location", e);
        }
        catch (WriterException e) {
            plugin.logError("General PMD Eclipse Exception when storing ruleset in state location", e);
        }
    }
}

