/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.runtime.properties.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.PmdAnalysis;
import net.sourceforge.pmd.eclipse.core.internal.FileModificationUtil;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.cmd.JavaProjectClassLoader;
import net.sourceforge.pmd.eclipse.runtime.properties.IProjectProperties;
import net.sourceforge.pmd.eclipse.runtime.properties.IProjectPropertiesManager;
import net.sourceforge.pmd.eclipse.runtime.properties.PropertiesException;
import net.sourceforge.pmd.eclipse.runtime.writer.IRuleSetWriter;
import net.sourceforge.pmd.eclipse.runtime.writer.WriterException;
import net.sourceforge.pmd.eclipse.ui.actions.RuleSetUtil;
import net.sourceforge.pmd.eclipse.ui.actions.internal.InternalRuleSetUtil;
import net.sourceforge.pmd.lang.rule.RuleSet;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.ui.IWorkingSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectPropertiesImpl
implements IProjectProperties {
    private static final Logger LOG = LoggerFactory.getLogger(ProjectPropertiesImpl.class);
    private static final String PROJECT_RULESET_FILE = ".ruleset";
    private final IProjectPropertiesManager projectPropertiesManager;
    private final IProject project;
    private boolean needRebuild;
    private boolean pmdEnabled;
    private boolean ruleSetStoredInProject;
    private String ruleSetFile;
    private List<RuleSet> projectRuleSets;
    private long projectRuleFileLastModified = 0L;
    private IWorkingSet projectWorkingSet;
    private boolean includeDerivedFiles;
    private boolean violationsAsErrors = true;
    private boolean fullBuildEnabled = true;
    private Set<String> buildPathExcludePatterns = new HashSet<String>();
    private Set<String> buildPathIncludePatterns = new HashSet<String>();
    private JavaProjectClassLoader auxclasspath;

    public ProjectPropertiesImpl(IProject project, IProjectPropertiesManager projectPropertiesManager) {
        this.project = project;
        this.projectPropertiesManager = projectPropertiesManager;
        this.projectRuleSets = new ArrayList<RuleSet>();
        this.projectRuleSets.add(PMDPlugin.getDefault().getPreferencesManager().getRuleSet());
        this.determineBuildPathIncludesExcludes();
    }

    private void determineBuildPathIncludesExcludes() {
        IClasspathEntry source = PMDPlugin.buildSourceClassPathEntryFor(this.project);
        if (source != null) {
            String pathString;
            IPath path;
            int n;
            int n2;
            IPath[] iPathArray;
            String basePath = this.project.getWorkspace().getRoot().getFolder(source.getPath()).getLocation().toPortableString();
            if (!basePath.endsWith(String.valueOf('/'))) {
                basePath = String.valueOf(basePath) + '/';
            }
            if (source.getExclusionPatterns() != null) {
                iPathArray = source.getExclusionPatterns();
                n2 = iPathArray.length;
                n = 0;
                while (n < n2) {
                    path = iPathArray[n];
                    pathString = path.toPortableString();
                    this.buildPathExcludePatterns.add(String.valueOf(basePath) + this.convertPatternToRegex(pathString));
                    ++n;
                }
            }
            if (source.getInclusionPatterns() != null) {
                iPathArray = source.getInclusionPatterns();
                n2 = iPathArray.length;
                n = 0;
                while (n < n2) {
                    path = iPathArray[n];
                    pathString = path.toPortableString();
                    this.buildPathIncludePatterns.add(String.valueOf(basePath) + this.convertPatternToRegex(pathString));
                    ++n;
                }
            }
        }
    }

    private String convertPatternToRegex(String pattern) {
        String regex = pattern;
        regex = regex.replaceAll("\\.", "\\\\.");
        regex = regex.replaceAll("\\*\\*", ".*");
        regex = regex.replaceAll("/\\*([^\\*])", "/[^/]*$1");
        regex = regex.replaceAll("\\.\\*/", ".*");
        regex = regex.replaceAll("\\?", ".");
        return regex;
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public boolean isPmdEnabled() {
        return this.pmdEnabled;
    }

    @Override
    public void setPmdEnabled(boolean pmdEnabled) {
        LOG.debug("Enable PMD for project {}: before={} now={}", new Object[]{this.project.getName(), this.pmdEnabled, pmdEnabled});
        if (this.pmdEnabled != pmdEnabled) {
            this.pmdEnabled = pmdEnabled;
            this.setNeedRebuild(this.needRebuild | pmdEnabled);
        }
    }

    @Override
    public List<RuleSet> getProjectRuleSetList() throws PropertiesException {
        return this.projectRuleSets;
    }

    @Override
    public RuleSet getProjectRuleSet() throws PropertiesException {
        return this.projectRuleSets.get(0);
    }

    @Override
    public void setProjectRuleSet(RuleSet projectRuleSet) throws PropertiesException {
        this.setProjectRuleSetList(Collections.singletonList(projectRuleSet));
    }

    @Override
    public void setProjectRuleSetList(List<RuleSet> newProjectRuleSets) throws PropertiesException {
        LOG.debug("Set a rule set for project {}", (Object)this.project.getName());
        if (newProjectRuleSets == null) {
            throw new PropertiesException("Setting a project rule set to null");
        }
        this.setNeedRebuild(!this.projectRuleSets.equals(newProjectRuleSets));
        this.projectRuleSets = newProjectRuleSets;
        if (this.ruleSetStoredInProject) {
            for (File f : this.getResolvedRuleSetFiles()) {
                long mod = FileModificationUtil.getFileModificationTimestamp(f);
                if (this.projectRuleFileLastModified >= mod) continue;
                this.projectRuleFileLastModified = mod;
            }
        }
    }

    @Override
    public boolean isRuleSetStoredInProject() {
        return this.ruleSetStoredInProject;
    }

    @Override
    public void setRuleSetStoredInProject(boolean ruleSetStoredInProject) throws PropertiesException {
        LOG.debug("Set rule set stored in project for project {}: {}", (Object)this.project.getName(), (Object)ruleSetStoredInProject);
        this.setNeedRebuild(this.needRebuild | this.ruleSetStoredInProject ^ ruleSetStoredInProject);
        this.ruleSetStoredInProject = ruleSetStoredInProject;
        if (this.ruleSetStoredInProject) {
            if (!this.isRuleSetFileExist()) {
                throw new PropertiesException("The project ruleset file(s) " + this.getRuleSetFile() + " cannot be found for project " + this.project.getName());
            }
            for (File f : this.getResolvedRuleSetFiles()) {
                long mod = FileModificationUtil.getFileModificationTimestamp(f);
                if (this.projectRuleFileLastModified >= mod) continue;
                this.projectRuleFileLastModified = mod;
            }
        }
    }

    @Override
    public String getRuleSetFile() {
        return StringUtils.isBlank((CharSequence)this.ruleSetFile) ? PROJECT_RULESET_FILE : this.ruleSetFile;
    }

    @Override
    public void setRuleSetFile(String ruleSetFile) throws PropertiesException {
        LOG.debug("Set rule set file for project {}: {}", (Object)this.project.getName(), (Object)ruleSetFile);
        this.setNeedRebuild(this.needRebuild | this.ruleSetFile == null || !this.ruleSetFile.equals(ruleSetFile));
        this.ruleSetFile = ruleSetFile;
        if (this.ruleSetStoredInProject) {
            if (!this.isRuleSetFileExist()) {
                throw new PropertiesException("The project ruleset file cannot be found for project " + this.project.getName());
            }
            for (File f : this.getResolvedRuleSetFiles()) {
                long mod = FileModificationUtil.getFileModificationTimestamp(f);
                if (this.projectRuleFileLastModified >= mod) continue;
                this.projectRuleFileLastModified = mod;
            }
        }
    }

    @Override
    public IWorkingSet getProjectWorkingSet() {
        return this.projectWorkingSet;
    }

    @Override
    public void setProjectWorkingSet(IWorkingSet projectWorkingSet) {
        LOG.debug("Set working set for project {}: {}", (Object)this.project.getName(), (Object)(projectWorkingSet == null ? "none" : projectWorkingSet.getName()));
        this.setNeedRebuild(this.needRebuild | projectWorkingSet == null ? this.projectWorkingSet != null : !projectWorkingSet.equals(this.projectWorkingSet));
        this.projectWorkingSet = projectWorkingSet;
    }

    @Override
    public boolean isNeedRebuild() {
        LOG.debug("Query if project {} need rebuild : {}", (Object)this.project.getName(), (Object)this.needRebuild);
        if (this.ruleSetStoredInProject) {
            boolean rulesetFilesChanged = false;
            for (File f : this.getResolvedRuleSetFiles()) {
                long mod = FileModificationUtil.getFileModificationTimestamp(f);
                rulesetFilesChanged |= mod > this.projectRuleFileLastModified;
            }
            LOG.debug("   ruleset files have changed = {}", (Object)rulesetFilesChanged);
            this.setNeedRebuild(this.needRebuild | rulesetFilesChanged);
        }
        return this.needRebuild;
    }

    @Override
    public void setNeedRebuild(boolean needRebuild) {
        LOG.debug("Set needRebuild for project " + this.project.getName() + ": " + needRebuild);
        this.needRebuild = needRebuild;
    }

    @Override
    public final boolean isRuleSetFileExist() {
        boolean allFilesCanBeRead = false;
        for (File f : this.getResolvedRuleSetFiles()) {
            if (f.canRead()) {
                allFilesCanBeRead = true;
                continue;
            }
            allFilesCanBeRead = false;
            break;
        }
        return allFilesCanBeRead;
    }

    @Override
    public List<File> getResolvedRuleSetFiles() {
        ArrayList<File> files = new ArrayList<File>();
        String[] stringArray = this.getRuleSetFile().split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String ruleSetFile = stringArray[n2];
            IFile file = this.project.getFile(ruleSetFile);
            File f = this.getExistingFileOrNull(file);
            if (f == null) {
                IWorkspaceRoot workspaceRoot = this.project.getWorkspace().getRoot();
                try {
                    IFile workspaceFile = workspaceRoot.getFile((IPath)new Path(ruleSetFile));
                    f = this.getExistingFileOrNull(workspaceFile);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                if (f == null && !(f = new File(ruleSetFile)).canRead()) {
                    f = null;
                }
            }
            if (f != null) {
                files.add(f);
            }
            ++n2;
        }
        return files;
    }

    private File getExistingFileOrNull(IFile file) {
        try {
            file.refreshLocal(0, null);
        }
        catch (CoreException e) {
            LOG.warn("Error refreshing {}", (Object)file, (Object)e);
        }
        boolean exists = file.exists() && file.isAccessible();
        File result = null;
        if (exists) {
            result = file.getLocation().toFile();
        }
        return result;
    }

    @Override
    public void createDefaultRuleSetFile() throws PropertiesException {
        LOG.info("Create a default rule set file for project " + this.project.getName());
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                IRuleSetWriter writer = PMDPlugin.getDefault().getRuleSetWriter();
                RuleSet ruleSet = RuleSetUtil.newEmpty("pmd-eclipse", "PMD Plugin preferences rule set");
                for (RuleSet rs : this.projectRuleSets) {
                    ruleSet = RuleSetUtil.addRules(ruleSet, rs.getRules());
                    ruleSet = InternalRuleSetUtil.addFileInclusions(ruleSet, rs.getFileInclusions());
                    ruleSet = InternalRuleSetUtil.addFileExclusions(ruleSet, rs.getFileExclusions());
                }
                writer.write(baos, ruleSet);
                IFile file = this.project.getFile(PROJECT_RULESET_FILE);
                if (file.exists() && file.isAccessible()) {
                    throw new PropertiesException("Project ruleset file already exists");
                }
                Object object = null;
                Object var8_12 = null;
                try (ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());){
                    file.create((InputStream)bais, true, null);
                }
                catch (Throwable throwable2) {
                    if (object == null) {
                        object = throwable2;
                    } else if (object != throwable2) {
                        ((Throwable)object).addSuppressed(throwable2);
                    }
                    throw object;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException | WriterException | CoreException e) {
            throw new PropertiesException("Error while creating default ruleset file for project " + this.project.getName(), e);
        }
    }

    @Override
    public boolean isIncludeDerivedFiles() {
        return this.includeDerivedFiles;
    }

    @Override
    public void setIncludeDerivedFiles(boolean includeDerivedFiles) {
        LOG.debug("Set if derived files should be included: " + includeDerivedFiles);
        this.setNeedRebuild(this.needRebuild | this.includeDerivedFiles ^ includeDerivedFiles);
        this.includeDerivedFiles = includeDerivedFiles;
    }

    @Override
    public void sync() throws PropertiesException {
        LOG.info("Commit properties for project " + this.project.getName());
        this.projectPropertiesManager.storeProjectProperties(this);
    }

    @Override
    public boolean violationsAsErrors() throws PropertiesException {
        return this.violationsAsErrors;
    }

    @Override
    public void setViolationsAsErrors(boolean violationsAsErrors) throws PropertiesException {
        LOG.debug("Set to handle violations as errors: {}", (Object)violationsAsErrors);
        this.setNeedRebuild(this.needRebuild | this.violationsAsErrors ^ violationsAsErrors);
        this.violationsAsErrors = violationsAsErrors;
    }

    @Override
    public boolean isFullBuildEnabled() throws PropertiesException {
        return this.fullBuildEnabled;
    }

    @Override
    public void setFullBuildEnabled(boolean fullBuildEnabled) throws PropertiesException {
        LOG.debug("Set if run at full build for project {}: {}", (Object)this.project.getName(), (Object)fullBuildEnabled);
        if (this.fullBuildEnabled != fullBuildEnabled) {
            this.fullBuildEnabled = fullBuildEnabled;
            if (this.fullBuildEnabled) {
                this.setNeedRebuild(true);
            }
        }
    }

    public String toString() {
        String projectName = "n/a";
        String projectRuleSetName = "n/a";
        String projectWorkingSetName = "n/a";
        if (this.project != null) {
            projectName = this.project.getName();
        }
        if (this.projectRuleSets != null) {
            projectRuleSetName = "";
            for (RuleSet rs : this.projectRuleSets) {
                projectRuleSetName = String.valueOf(projectRuleSetName) + rs.getName() + ",";
            }
        }
        if (this.projectWorkingSet != null) {
            projectWorkingSetName = this.projectWorkingSet.getName();
        }
        return "fullBuildEnabled:" + this.fullBuildEnabled + " includeDerivedFiles:" + this.includeDerivedFiles + " pmdEnabled:" + this.pmdEnabled + " project:" + projectName + " projectRuleSet:" + projectRuleSetName + " projectWorkingSet:" + projectWorkingSetName + " ruleSetFile:" + this.ruleSetFile + " ruleSetStoredInProject:" + this.ruleSetStoredInProject + " violationsAsErrors: " + this.violationsAsErrors;
    }

    @Override
    public Set<String> getBuildPathExcludePatterns() {
        return this.buildPathExcludePatterns;
    }

    @Override
    public Set<String> getBuildPathIncludePatterns() {
        return this.buildPathIncludePatterns;
    }

    @Override
    public ClassLoader getAuxClasspath() {
        block6: {
            try {
                if (this.project == null || !this.project.hasNature("org.eclipse.jdt.core.javanature")) break block6;
                String projectName = this.project.getName();
                if (this.auxclasspath != null && this.auxclasspath.isModified()) {
                    PMDPlugin.getDefault().logInformation("Classpath of project " + projectName + " changed - recreating it.");
                    try {
                        this.auxclasspath.close();
                    }
                    catch (IOException iOException) {}
                    this.auxclasspath = null;
                }
                if (this.auxclasspath == null) {
                    PMDPlugin.getDefault().logInformation("Creating new auxclasspath class loader for project " + this.project.getName());
                    this.auxclasspath = new JavaProjectClassLoader(PmdAnalysis.class.getClassLoader(), this.project);
                }
                return this.auxclasspath;
            }
            catch (CoreException e) {
                LOG.error("Error determining aux classpath", (Throwable)e);
                PMDPlugin.getDefault().logError("Error determining aux classpath", e);
            }
        }
        return null;
    }
}

