/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.runtime.properties.impl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import javax.xml.bind.DataBindingException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.builder.PMDNature;
import net.sourceforge.pmd.eclipse.runtime.properties.IProjectProperties;
import net.sourceforge.pmd.eclipse.runtime.properties.IProjectPropertiesManager;
import net.sourceforge.pmd.eclipse.runtime.properties.PropertiesException;
import net.sourceforge.pmd.eclipse.runtime.properties.impl.ProjectPropertiesTO;
import net.sourceforge.pmd.eclipse.runtime.properties.impl.ProjectPropertiesTimestampTupel;
import net.sourceforge.pmd.eclipse.runtime.properties.impl.PropertiesFactoryImpl;
import net.sourceforge.pmd.eclipse.runtime.properties.impl.RuleSpecTO;
import net.sourceforge.pmd.eclipse.ui.actions.RuleSetUtil;
import net.sourceforge.pmd.eclipse.ui.actions.internal.InternalRuleSetUtil;
import net.sourceforge.pmd.eclipse.util.internal.IOUtil;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.lang.rule.RuleSet;
import net.sourceforge.pmd.lang.rule.RuleSetLoadException;
import net.sourceforge.pmd.lang.rule.RuleSetLoader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectPropertiesManagerImpl
implements IProjectPropertiesManager {
    private static final Logger LOG = LoggerFactory.getLogger(ProjectPropertiesManagerImpl.class);
    private static final JAXBContext JAXB_CONTEXT = ProjectPropertiesManagerImpl.initJaxbContext();
    private final ConcurrentMap<IProject, ProjectPropertiesTimestampTupel> projectsProperties = new ConcurrentHashMap<IProject, ProjectPropertiesTimestampTupel>();

    private static JAXBContext initJaxbContext() {
        try {
            return JAXBContext.newInstance((Class[])new Class[]{ProjectPropertiesTO.class});
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public IProjectProperties loadProjectProperties(IProject project) throws PropertiesException {
        LOG.debug("Loading project properties for project {}", (Object)project.getName());
        try {
            IProjectProperties projectProperties;
            ProjectPropertiesTimestampTupel projectPropertiesTupel = (ProjectPropertiesTimestampTupel)this.projectsProperties.get(project);
            if (projectPropertiesTupel == null) {
                LOG.debug("Creating new poject properties for {}", (Object)project.getName());
                IProjectProperties projectPropertiesNew = new PropertiesFactoryImpl().newProjectProperties(project, this);
                ProjectPropertiesTO to = this.readProjectProperties(project);
                this.fillProjectProperties(projectPropertiesNew, to);
                projectPropertiesTupel = this.projectsProperties.putIfAbsent(project, new ProjectPropertiesTimestampTupel(projectPropertiesNew));
                if (projectPropertiesTupel == null) {
                    projectPropertiesTupel = (ProjectPropertiesTimestampTupel)this.projectsProperties.get(project);
                } else {
                    LOG.debug("project properties already existed for {}", (Object)project.getName());
                }
                projectProperties = projectPropertiesTupel.getProjectProperties();
            } else if (projectPropertiesTupel.isOutOfSync()) {
                LOG.info("Project properties for project {} have been changed on disk - reloading", (Object)project.getName());
                projectProperties = projectPropertiesTupel.getProjectProperties();
                ProjectPropertiesTO to = this.readProjectProperties(project);
                this.fillProjectProperties(projectProperties, to);
                projectProperties.setNeedRebuild(true);
            } else {
                LOG.debug("Project properties found and are up to date for project {}", (Object)project.getName());
                projectProperties = projectPropertiesTupel.getProjectProperties();
            }
            if (projectProperties.isRuleSetStoredInProject()) {
                this.loadRuleSetFromProject(projectProperties);
            } else {
                boolean needRebuild = this.synchronizeRuleSet(projectProperties);
                projectProperties.setNeedRebuild(projectProperties.isNeedRebuild() || needRebuild);
            }
            return projectProperties;
        }
        catch (CoreException e) {
            throw new PropertiesException("Core Exception when loading project properties for project " + project.getName(), e);
        }
    }

    @Override
    public void storeProjectProperties(IProjectProperties projectProperties) throws PropertiesException {
        LOG.debug("Storing project properties for project {}", (Object)projectProperties.getProject().getName());
        try {
            if (projectProperties.isPmdEnabled()) {
                PMDNature.addPMDNature(projectProperties.getProject(), null);
            } else {
                PMDNature.removePMDNature(projectProperties.getProject(), null);
            }
            this.writeProjectProperties(projectProperties.getProject(), this.fillTransferObject(projectProperties));
            this.projectsProperties.put(projectProperties.getProject(), new ProjectPropertiesTimestampTupel(projectProperties));
        }
        catch (CoreException e) {
            throw new PropertiesException("Core Exception when storing project properties for project " + projectProperties.getProject().getName(), e);
        }
    }

    @Override
    public void removeProjectProperties(IProject project) {
        this.projectsProperties.remove(project);
    }

    private void loadRuleSetFromProject(IProjectProperties projectProperties) throws PropertiesException {
        if (projectProperties.isRuleSetFileExist() && projectProperties.isNeedRebuild()) {
            LOG.debug("Loading ruleset from project ruleset file: " + projectProperties.getRuleSetFile());
            try {
                RuleSetLoader loader = InternalRuleSetUtil.getDefaultRuleSetLoader();
                ArrayList<RuleSet> allRulesets = new ArrayList<RuleSet>();
                for (File ruleSetFile : projectProperties.getResolvedRuleSetFiles()) {
                    RuleSet ruleSet = loader.loadFromResource(ruleSetFile.getPath());
                    allRulesets.add(ruleSet);
                }
                projectProperties.setProjectRuleSetList(allRulesets);
            }
            catch (RuleSetLoadException e) {
                PMDPlugin.getDefault().logError("Project RuleSet cannot be loaded for project " + projectProperties.getProject().getName() + " using RuleSet file name " + projectProperties.getRuleSetFile() + ". Using the rules from properties.", e);
            }
        }
    }

    public ProjectPropertiesTO convertProjectPropertiesFromString(String properties) {
        try {
            StreamSource source = new StreamSource(new StringReader(properties));
            JAXBElement element = JAXB_CONTEXT.createUnmarshaller().unmarshal((Source)source, ProjectPropertiesTO.class);
            return (ProjectPropertiesTO)element.getValue();
        }
        catch (JAXBException e) {
            throw new DataBindingException((Throwable)e);
        }
    }

    private ProjectPropertiesTO readProjectProperties(IProject project) throws PropertiesException {
        ProjectPropertiesTO projectProperties = null;
        try {
            IFile propertiesFile = project.getFile(".pmd");
            if (propertiesFile.exists() && propertiesFile.isAccessible()) {
                Throwable throwable = null;
                Object var5_7 = null;
                try (InputStreamReader in = new InputStreamReader(propertiesFile.getContents(), StandardCharsets.UTF_8);){
                    String properties = IOUtil.toString(in);
                    projectProperties = this.convertProjectPropertiesFromString(properties);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            return projectProperties;
        }
        catch (IOException | DataBindingException | CoreException e) {
            throw new PropertiesException("Error while reading project properties file for project " + project.getName(), e);
        }
    }

    private void fillProjectProperties(IProjectProperties projectProperties, ProjectPropertiesTO to) throws PropertiesException, CoreException {
        String projectName = projectProperties.getProject().getName();
        if (to == null) {
            LOG.info("Project properties for project {} not found. Use default.", (Object)projectName);
        } else {
            IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
            projectProperties.setProjectWorkingSet(workingSetManager.getWorkingSet(to.getWorkingSetName()));
            projectProperties.setRuleSetFile(to.getRuleSetFile());
            projectProperties.setRuleSetStoredInProject(to.isRuleSetStoredInProject());
            projectProperties.setPmdEnabled(projectProperties.getProject().hasNature("net.sourceforge.pmd.eclipse.plugin.pmdNature"));
            projectProperties.setIncludeDerivedFiles(to.isIncludeDerivedFiles());
            projectProperties.setViolationsAsErrors(to.isViolationsAsErrors());
            projectProperties.setFullBuildEnabled(to.isFullBuildEnabled());
            if (to.isRuleSetStoredInProject()) {
                this.loadRuleSetFromProject(projectProperties);
            } else {
                this.setRuleSetFromProperties(projectProperties, to.getRules());
            }
            LOG.debug("Project properties for project {} loaded", (Object)projectName);
        }
    }

    private void setRuleSetFromProperties(IProjectProperties projectProperties, RuleSpecTO[] rules) throws PropertiesException {
        RuleSet pluginRuleSet = PMDPlugin.getDefault().getPreferencesManager().getRuleSet();
        HashSet<String> ruleNamesToAdd = new HashSet<String>();
        if (rules != null) {
            RuleSpecTO[] ruleSpecTOArray = rules;
            int n = rules.length;
            int n2 = 0;
            while (n2 < n) {
                RuleSpecTO rule = ruleSpecTOArray[n2];
                if (!ruleNamesToAdd.add(rule.getName())) {
                    PMDPlugin.getDefault().logInformation("Duplicated Rule found: " + rule.getName() + ". This rule will be ignored.");
                    LOG.debug("Duplicated Rule found: " + rule.getName() + ". This rule will be ignored.");
                }
                ++n2;
            }
        }
        ArrayList<Rule> rulesToAdd = new ArrayList<Rule>();
        for (String ruleName : ruleNamesToAdd) {
            Rule rule = pluginRuleSet.getRuleByName(ruleName);
            if (rule != null) {
                rulesToAdd.add(rule);
                continue;
            }
            PMDPlugin.getDefault().logInformation("The rule " + ruleName + " could not be found. The rule will be ignored.");
            LOG.debug("The rule " + ruleName + " could not be found. The rule will be ignored.");
        }
        RuleSet ruleSet = RuleSetUtil.newEmpty("pmd-eclipse", "PMD Plugin preferences rule set");
        ruleSet = RuleSetUtil.addRules(ruleSet, rulesToAdd);
        ruleSet = InternalRuleSetUtil.setFileExclusions(ruleSet, pluginRuleSet.getFileExclusions());
        ruleSet = InternalRuleSetUtil.setFileInclusions(ruleSet, pluginRuleSet.getFileInclusions());
        projectProperties.setProjectRuleSet(ruleSet);
    }

    public String convertProjectPropertiesToString(ProjectPropertiesTO projectProperties) {
        try {
            Marshaller marshaller = JAXB_CONTEXT.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.fragment", (Object)true);
            StringWriter writer = new StringWriter();
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            marshaller.marshal((Object)projectProperties, (Writer)writer);
            writer.write("\n");
            return writer.toString();
        }
        catch (JAXBException e) {
            throw new DataBindingException((Throwable)e);
        }
    }

    private void writeProjectProperties(IProject project, ProjectPropertiesTO projectProperties) throws PropertiesException {
        try {
            String writer = this.convertProjectPropertiesToString(projectProperties);
            IFile propertiesFile = project.getFile(".pmd");
            if (propertiesFile.exists() && propertiesFile.isAccessible()) {
                propertiesFile.setContents((InputStream)new ByteArrayInputStream(writer.getBytes(StandardCharsets.UTF_8)), false, false, null);
            } else {
                propertiesFile.create((InputStream)new ByteArrayInputStream(writer.getBytes(StandardCharsets.UTF_8)), false, null);
            }
            propertiesFile.setCharset(StandardCharsets.UTF_8.name(), null);
        }
        catch (CoreException e) {
            throw new PropertiesException("Error while writing project properties file for project " + project.getName(), e);
        }
    }

    private ProjectPropertiesTO fillTransferObject(IProjectProperties projectProperties) throws PropertiesException {
        ProjectPropertiesTO bean = new ProjectPropertiesTO();
        bean.setWorkingSetName(projectProperties.getProjectWorkingSet() == null ? null : projectProperties.getProjectWorkingSet().getName());
        bean.setIncludeDerivedFiles(projectProperties.isIncludeDerivedFiles());
        bean.setViolationsAsErrors(projectProperties.violationsAsErrors());
        bean.setFullBuildEnabled(projectProperties.isFullBuildEnabled());
        bean.setRuleSetStoredInProject(projectProperties.isRuleSetStoredInProject());
        if (projectProperties.isRuleSetStoredInProject()) {
            bean.setRuleSetFile(projectProperties.getRuleSetFile());
        } else {
            List<RuleSet> ruleSets = projectProperties.getProjectRuleSetList();
            ArrayList<RuleSpecTO> rules = new ArrayList<RuleSpecTO>();
            ArrayList<String> excludePatterns = new ArrayList<String>();
            ArrayList<String> includePatterns = new ArrayList<String>();
            for (RuleSet ruleSet : ruleSets) {
                for (Rule rule : ruleSet.getRules()) {
                    rules.add(new RuleSpecTO(rule.getName(), rule.getRuleSetName()));
                }
                for (Pattern pattern : ruleSet.getFileExclusions()) {
                    excludePatterns.add(pattern.pattern());
                }
                for (Pattern pattern : ruleSet.getFileInclusions()) {
                    includePatterns.add(pattern.pattern());
                }
            }
            bean.setRules(rules.toArray(new RuleSpecTO[0]));
            bean.setExcludePatterns(excludePatterns.toArray(new String[0]));
            bean.setIncludePatterns(includePatterns.toArray(new String[0]));
        }
        return bean;
    }

    private boolean synchronizeRuleSet(IProjectProperties projectProperties) throws PropertiesException {
        LOG.debug("Synchronizing the project ruleset with the plugin ruleset");
        RuleSet pluginRuleSet = PMDPlugin.getDefault().getPreferencesManager().getRuleSet();
        List<RuleSet> projectRuleSets = projectProperties.getProjectRuleSetList();
        boolean flChanged = false;
        ArrayList projectRules = new ArrayList();
        for (RuleSet ruleset : projectRuleSets) {
            projectRules.addAll(ruleset.getRules());
        }
        if (!projectRules.equals(pluginRuleSet.getRules())) {
            RuleSet ruleset;
            LOG.debug("The project ruleset is different from the plugin ruleset; synchronizing.");
            ruleset = projectRuleSets.get(0);
            RuleSet newRuleSet = RuleSetUtil.newEmpty(ruleset.getName(), ruleset.getDescription());
            ArrayList<Rule> newRules = new ArrayList<Rule>();
            ArrayList<Rule> haystack = new ArrayList<Rule>(pluginRuleSet.getRules());
            for (RuleSet projectRuleSet : projectRuleSets) {
                for (Rule projectRule : projectRuleSet.getRules()) {
                    Rule pluginRule = RuleSetUtil.findSameRule(haystack, projectRule);
                    if (pluginRule == null) {
                        LOG.debug("The rule " + projectRule.getName() + " is not defined in the plugin ruleset. Remove it.");
                        continue;
                    }
                    newRules.add(pluginRule);
                    haystack.remove(pluginRule);
                }
            }
            if (!(newRuleSet = RuleSetUtil.addRules(newRuleSet, newRules)).getRules().equals(projectRules)) {
                LOG.info("Set the project ruleset according to preferences.");
                projectProperties.setProjectRuleSet(newRuleSet);
                flChanged = true;
            }
            LOG.debug("Ruleset for project " + projectProperties.getProject().getName() + " is now synchronized. " + (flChanged ? "Ruleset has changed" : "Ruleset has not changed"));
        }
        return flChanged;
    }
}

