/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.runtime.properties.impl;

import java.io.File;
import net.sourceforge.pmd.eclipse.core.internal.FileModificationUtil;
import net.sourceforge.pmd.eclipse.runtime.properties.IProjectProperties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProjectPropertiesTimestampTupel {
    private static final Logger LOG = LoggerFactory.getLogger(ProjectPropertiesTimestampTupel.class);
    static final String PROPERTIES_FILE = ".pmd";
    private final IProjectProperties projectProperties;
    private long lastReadTimestamp;

    ProjectPropertiesTimestampTupel(IProjectProperties projectProperties) {
        this.projectProperties = projectProperties;
        this.lastReadTimestamp = this.getModificationTimestamp();
    }

    IProjectProperties getProjectProperties() {
        return this.projectProperties;
    }

    IProject getProject() {
        return this.projectProperties.getProject();
    }

    boolean isOutOfSync() throws CoreException {
        IProject project = this.projectProperties.getProject();
        IFile propertiesFile = project.getFile(PROPERTIES_FILE);
        if (!propertiesFile.isSynchronized(0)) {
            LOG.debug("File {} is out of sync... refreshing initiated", (Object)propertiesFile);
            propertiesFile.refreshLocal(0, null);
        }
        long newTimestamp = this.getModificationTimestamp();
        LOG.debug("Comparing timestamps for {}: lastRead={}, new={}", new Object[]{propertiesFile, this.lastReadTimestamp, newTimestamp});
        if (newTimestamp != this.lastReadTimestamp) {
            this.lastReadTimestamp = newTimestamp;
            return true;
        }
        return false;
    }

    private long getModificationTimestamp() {
        IProject project = this.projectProperties.getProject();
        IFile propertiesFile = project.getFile(PROPERTIES_FILE);
        File propertiesFileReal = propertiesFile.getLocation().toFile();
        return FileModificationUtil.getFileModificationTimestamp(propertiesFileReal);
    }
}

