/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.search;

import java.util.Set;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.java.JavaLanguageModule;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RuleSearchPage
extends DialogPage
implements ISearchPage {
    private Text idText;
    private String selected;

    public RuleSearchPage(String title) {
        super(title);
    }

    public RuleSearchPage(String title, ImageDescriptor image) {
        super(title, image);
    }

    public boolean performAction() {
        return false;
    }

    public void setContainer(ISearchPageContainer container) {
        if (container.getSelection() instanceof TextSelection) {
            this.selected = ((TextSelection)container.getSelection()).getText();
        }
    }

    public void buildLanguageCombo(Composite parent) {
        Set languages = LanguageRegistry.PMD.getLanguages();
        Combo languageCombo = new Combo(parent, 8);
        JavaLanguageModule defaultLanguage = JavaLanguageModule.getInstance();
        int selectionIndex = -1;
        int i = 0;
        for (Language language : languages) {
            if (defaultLanguage.equals(language)) {
                selectionIndex = i;
            }
            languageCombo.add(language.getName());
            ++i;
        }
        languageCombo.select(selectionIndex);
    }

    private void addButtons(Composite parent, int horizSpan) {
        Group group = new Group(parent, 2048);
        group.setLayoutData((Object)new GridData(1, 1, true, true, horizSpan, 1));
        group.setLayout((Layout)new GridLayout(2, false));
        group.setText("Scope");
        Button name = new Button((Composite)group, 32);
        name.setText("Names");
        Button description = new Button((Composite)group, 32);
        description.setText("Descriptions");
        Button example = new Button((Composite)group, 32);
        example.setText("Examples");
        Button xpath = new Button((Composite)group, 32);
        xpath.setText("XPaths");
    }

    public void createControl(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayoutData((Object)new GridData(768, 1040, true, true, 2, 1));
        panel.setLayout((Layout)new GridLayout(3, false));
        Composite textPanel = new Composite(panel, 0);
        textPanel.setLayoutData((Object)new GridData(768, 1, true, true, 3, 1));
        textPanel.setLayout((Layout)new GridLayout(4, false));
        Label label = new Label(textPanel, 2048);
        label.setText("Containing text:");
        label.setLayoutData((Object)new GridData(1, 1, false, false, 4, 1));
        this.idText = new Text(textPanel, 2048);
        GridData gridData2 = new GridData();
        gridData2.horizontalSpan = 3;
        this.idText.setLayoutData((Object)gridData2);
        if (this.selected != null) {
            this.idText.setText(this.selected);
            this.idText.setSelection(0, this.selected.length());
        }
        Button caseSensitive = new Button(textPanel, 32);
        caseSensitive.setText("Case sensitive");
        caseSensitive.setLayoutData((Object)new GridData(3, 1, false, false, 1, 1));
        this.addButtons(panel, 4);
        this.setControl((Control)panel);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.idText.setFocus();
    }
}

