/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui;

import net.sourceforge.pmd.eclipse.ui.ColumnDescriptor;
import net.sourceforge.pmd.eclipse.util.ResourceManager;
import net.sourceforge.pmd.eclipse.util.internal.SWTUtil;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public abstract class AbstractColumnDescriptor
implements ColumnDescriptor {
    private final String id;
    private final String label;
    private final String tooltip;
    private final int alignment;
    private final int width;
    private final boolean isResizable;
    private final String imagePath;
    public static final String DESCRIPTOR_KEY = "descriptor";

    public AbstractColumnDescriptor(String theId, String labelKey, int theAlignment, int theWidth, boolean resizableFlag, String theImagePath) {
        this.id = theId;
        this.label = SWTUtil.stringFor(labelKey);
        this.tooltip = SWTUtil.tooltipFor(labelKey);
        this.alignment = theAlignment;
        this.width = theWidth;
        this.isResizable = resizableFlag;
        this.imagePath = theImagePath;
    }

    protected void setLabelIfImageMissing(TreeColumn column) {
        if (this.imagePath == null) {
            column.setText(this.label);
        }
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String label() {
        return this.label;
    }

    @Override
    public String tooltip() {
        return this.tooltip;
    }

    @Override
    public int defaultWidth() {
        return this.width;
    }

    protected TreeColumn buildTreeColumn(Tree parent) {
        TreeColumn tc = new TreeColumn(parent, this.alignment);
        this.loadCommon((Item)tc);
        tc.setWidth(this.width);
        tc.setResizable(this.isResizable);
        tc.setToolTipText(this.tooltip);
        return tc;
    }

    public TableColumn buildTableColumn(Table parent) {
        TableColumn tc = new TableColumn(parent, this.alignment);
        this.loadCommon((Item)tc);
        tc.setText(this.label);
        tc.setWidth(this.width);
        tc.setResizable(this.isResizable);
        tc.setToolTipText(this.tooltip);
        return tc;
    }

    private void loadCommon(Item column) {
        column.setData(DESCRIPTOR_KEY, (Object)this);
        if (this.imagePath != null) {
            column.setImage(ResourceManager.imageFor(this.imagePath));
        }
    }
}

