/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.eclipse.ui.ItemColumnDescriptor;
import net.sourceforge.pmd.eclipse.ui.preferences.AbstractTableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Table;

public class BasicTableLabelProvider
extends AbstractTableLabelProvider {
    private final ItemColumnDescriptor[] columns;
    private final List<Image> imagesToBeDisposed = new ArrayList<Image>();

    public BasicTableLabelProvider(ItemColumnDescriptor<?, ?>[] theColumns) {
        this.columns = theColumns;
    }

    @Override
    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    @Override
    public Image getColumnImage(Object element, int columnIndex) {
        ItemColumnDescriptor itemColumnDescriptor = this.columns[columnIndex];
        Image image = itemColumnDescriptor.imageFor(element);
        if (image != null && itemColumnDescriptor.shouldImageBeDisposed()) {
            this.imagesToBeDisposed.add(image);
        }
        return image;
    }

    public String getColumnText(Object element, int columnIndex) {
        String value = this.columns[columnIndex].textFor(element);
        return value == null ? null : value.toString();
    }

    public void addColumnsTo(Table table) {
        ItemColumnDescriptor[] itemColumnDescriptorArray = this.columns;
        int n = this.columns.length;
        int n2 = 0;
        while (n2 < n) {
            ItemColumnDescriptor desc = itemColumnDescriptorArray[n2];
            desc.buildTableColumn(table);
            ++n2;
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        for (Image image : this.imagesToBeDisposed) {
            image.dispose();
        }
        this.imagesToBeDisposed.clear();
    }
}

