/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.PMDRuntimeConstants;
import net.sourceforge.pmd.eclipse.runtime.builder.MarkerUtil;
import net.sourceforge.pmd.eclipse.ui.priority.PriorityDescriptorCache;
import net.sourceforge.pmd.eclipse.ui.views.PriorityFilter;
import net.sourceforge.pmd.lang.rule.RulePriority;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;

public class RuleLabelDecorator
implements ILightweightLabelDecorator {
    public static final String ID = "net.sourceforge.pmd.eclipse.plugin.RuleLabelDecorator";
    private Set<ILabelProviderListener> listeners = new CopyOnWriteArraySet<ILabelProviderListener>();

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add(listener);
    }

    public void dispose() {
    }

    public void changed(Collection<IResource> resources) {
        LabelProviderChangedEvent lpce = new LabelProviderChangedEvent((IBaseLabelProvider)this, resources.toArray());
        for (ILabelProviderListener listener : this.listeners) {
            listener.labelProviderChanged(lpce);
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove(listener);
    }

    public void decorate(Object element, IDecoration decoration) {
        if (!(element instanceof IResource)) {
            return;
        }
        IResource resource = (IResource)element;
        Set<Integer> range = null;
        try {
            range = MarkerUtil.priorityRangeOf(resource, PMDRuntimeConstants.RULE_MARKER_TYPES, 5);
        }
        catch (CoreException coreException) {
            return;
        }
        if (range.isEmpty()) {
            return;
        }
        Integer highestPriority = null;
        for (Integer priority : range) {
            if (!PriorityFilter.getInstance().isPriorityEnabled(RulePriority.valueOf((int)priority)) || highestPriority != null && highestPriority <= priority) continue;
            highestPriority = priority;
        }
        if (highestPriority == null) {
            return;
        }
        ImageDescriptor overlay = PriorityDescriptorCache.INSTANCE.descriptorFor(RulePriority.valueOf((int)highestPriority)).getAnnotationImageDescriptor();
        try {
            boolean hasMarkers = MarkerUtil.hasAnyRuleMarkers(resource);
            if (hasMarkers) {
                decoration.addOverlay(overlay);
            }
        }
        catch (CoreException e) {
            PMDPlugin.getDefault().logError("Error while adding overlay icon", e);
        }
    }
}

