/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.actions;

import java.util.stream.Collectors;
import net.sourceforge.pmd.cpd.CPDReportRenderer;
import net.sourceforge.pmd.cpd.CSVRenderer;
import net.sourceforge.pmd.cpd.SimpleRenderer;
import net.sourceforge.pmd.cpd.XMLRenderer;
import net.sourceforge.pmd.eclipse.runtime.cmd.DetectCutAndPasteCmd;
import net.sourceforge.pmd.eclipse.ui.actions.AbstractUIAction;
import net.sourceforge.pmd.eclipse.ui.dialogs.CPDCheckDialog;
import net.sourceforge.pmd.eclipse.ui.views.cpd2.CPDView2;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageRegistry;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CPDCheckProjectAction
extends AbstractUIAction {
    private static final Logger LOG = LoggerFactory.getLogger(CPDCheckProjectAction.class);
    private static final String XML_KEY = "XML";
    private static final String SIMPLE_KEY = "Simple Text";
    private static final String CSV_KEY = "CSV";

    public void run(IAction action) {
        String[] formats;
        String[] languages;
        IWorkbenchPartSite site = this.targetPartSite();
        ISelection sel = this.targetSelection();
        Shell shell = site.getShell();
        CPDCheckDialog dialog = new CPDCheckDialog(shell, languages = LanguageRegistry.CPD.getLanguages().stream().map(Language::getId).collect(Collectors.toList()).toArray(new String[0]), formats = new String[]{SIMPLE_KEY, XML_KEY, CSV_KEY});
        if (dialog.open() == 0 && sel instanceof IStructuredSelection) {
            StructuredSelection ss = (StructuredSelection)sel;
            for (Object obj : ss) {
                if (obj instanceof IAdaptable) {
                    IAdaptable adaptable = (IAdaptable)obj;
                    IProject project = (IProject)adaptable.getAdapter(IProject.class);
                    if (project == null) {
                        LOG.warn("The selected object cannot adapt to a project");
                        LOG.debug("   -> selected object : " + obj);
                        continue;
                    }
                    this.detectCutAndPaste(project, dialog);
                    continue;
                }
                LOG.warn("The selected object is not adaptable");
                LOG.debug("   -> selected object : " + obj);
            }
        }
    }

    private void detectCutAndPaste(IProject project, CPDCheckDialog dialog) {
        String selectedLanguage = dialog.getSelectedLanguage();
        int tilesize = dialog.getTileSize();
        boolean createReport = dialog.isCreateReportSelected();
        CPDReportRenderer selectedRenderer = this.createRenderer(dialog.getSelectedFormat());
        String fileName = this.createFileName(dialog.getSelectedFormat());
        CPDView2 view = this.showView();
        try {
            DetectCutAndPasteCmd detectCmd = new DetectCutAndPasteCmd();
            detectCmd.setProject(project);
            detectCmd.setCreateReport(createReport);
            detectCmd.setLanguage(selectedLanguage);
            detectCmd.setMinTileSize(tilesize);
            detectCmd.setCPDRenderer(selectedRenderer);
            detectCmd.setReportName(fileName);
            detectCmd.setUserInitiated(true);
            detectCmd.addPropertyListener(view);
            detectCmd.performExecute();
        }
        catch (RuntimeException e) {
            this.logError(this.getString("message.error.pmd_exception"), e);
        }
    }

    private CPDView2 showView() {
        CPDView2 view = null;
        try {
            IWorkbenchPage workbenchPage = this.targetPartSite().getPage();
            view = (CPDView2)workbenchPage.showView("net.sourceforge.pmd.eclipse.ui.views.br.CPDView2");
        }
        catch (PartInitException pie) {
            this.logError(this.getString("message.error.view_exception"), pie);
        }
        return view;
    }

    private CPDReportRenderer createRenderer(String rendererKey) {
        XMLRenderer renderer = null;
        if (XML_KEY.equals(rendererKey)) {
            renderer = new XMLRenderer();
        } else if (SIMPLE_KEY.equals(rendererKey)) {
            renderer = new SimpleRenderer();
        } else if (CSV_KEY.equals(rendererKey)) {
            renderer = new CSVRenderer();
        }
        return renderer;
    }

    private String createFileName(String rendererKey) {
        String fileName = XML_KEY.equals(rendererKey) ? "cpd-report.xml" : (CSV_KEY.equals(rendererKey) ? "cpd-report.csv" : "cpd-report.txt");
        return fileName;
    }
}

