/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.actions;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import net.sourceforge.pmd.eclipse.ui.actions.AbstractUIAction;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClearReviewsAction
extends AbstractUIAction
implements IResourceVisitor,
IViewActionDelegate {
    private static final Logger LOG = LoggerFactory.getLogger(ClearReviewsAction.class);
    private IProgressMonitor monitor;

    public void init(IViewPart view) {
        this.setActivePart(null, view.getSite().getPage().getActivePart());
    }

    public void run(IAction action) {
        LOG.info("Remove violation reviews requested.");
        ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog(Display.getDefault().getActiveShell());
        try {
            monitorDialog.run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    ClearReviewsAction.this.setMonitor(monitor);
                    ClearReviewsAction.this.clearReviews();
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            this.logError("Invocation Target Exception when removing violation reviews", e.getTargetException());
        }
        catch (InterruptedException e) {
            this.logError("Interrupted Exception when removing violation reviews", e);
        }
    }

    protected IProgressMonitor getMonitor() {
        return this.monitor;
    }

    protected void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    protected void monitorWorked() {
        if (this.getMonitor() != null) {
            this.getMonitor().worked(1);
        }
    }

    protected void monitorSubTask(String message) {
        if (this.getMonitor() != null) {
            this.getMonitor().subTask(message);
        }
    }

    protected void clearReviews() {
        try {
            ISelection selection = this.targetSelection();
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                if (this.getMonitor() != null) {
                    this.getMonitor().beginTask(this.getString("monitor.remove_reviews"), -1);
                    for (Object object : structuredSelection) {
                        IResource resource = null;
                        if (object instanceof IMarker) {
                            resource = ((IMarker)object).getResource();
                        } else if (object instanceof IAdaptable) {
                            IAdaptable adaptable = (IAdaptable)object;
                            resource = (IResource)adaptable.getAdapter(IResource.class);
                        } else {
                            LOG.warn("The selected object is not adaptable");
                            LOG.debug("   -> selected object = " + object);
                        }
                        if (resource != null) {
                            resource.accept((IResourceVisitor)this);
                            continue;
                        }
                        LOG.warn("The selected object cannot adapt to a resource.");
                        LOG.debug("   -> selected object" + object);
                    }
                }
            }
        }
        catch (CoreException e) {
            this.logError("Core Exception when clearing violations reviews", e);
        }
    }

    private void clearReviews(IFile file) {
        this.monitorSubTask(file.getName());
        String updatedFileContent = this.removeReviews(file);
        if (updatedFileContent != null) {
            this.saveNewContent(file, updatedFileContent);
        }
        this.monitorWorked();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String removeReviews(IFile file) {
        boolean noChange;
        StringWriter modified;
        block24: {
            modified = new StringWriter();
            noChange = true;
            try {
                Throwable throwable = null;
                Object var5_8 = null;
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(file.getContents(), file.getCharset()));
                    try {
                        try (PrintWriter out = new PrintWriter(modified);){
                            boolean comment = false;
                            while (true) {
                                if (!reader.ready()) {
                                    out.flush();
                                    break;
                                }
                                String origLine = reader.readLine();
                                String line = origLine.trim();
                                if (line == null) continue;
                                int index = origLine.indexOf("// NOPMD");
                                int quoteIndex = origLine.indexOf(34);
                                if (line.startsWith("/*")) {
                                    if (line.indexOf("*/") == -1) {
                                        comment = true;
                                    }
                                    out.println(origLine);
                                    continue;
                                }
                                if (comment && line.indexOf("*/") != -1) {
                                    comment = false;
                                    out.println(origLine);
                                    continue;
                                }
                                if (!comment && line.startsWith("// @PMD:REVIEWED:")) {
                                    noChange = false;
                                    continue;
                                }
                                if (!(comment || index == -1 || quoteIndex != -1 && quoteIndex < index && index < origLine.lastIndexOf(34))) {
                                    noChange = false;
                                    out.println(origLine.substring(0, index));
                                    continue;
                                }
                                out.println(origLine);
                            }
                        }
                        if (reader == null) break block24;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (reader == null) throw throwable;
                        reader.close();
                        throw throwable;
                    }
                    reader.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            catch (CoreException e) {
                this.logError("message.error.core_exception", e);
            }
            catch (IOException e) {
                this.logError("message.error.io_exception", e);
            }
        }
        if (noChange) {
            return null;
        }
        String string = modified.toString();
        return string;
    }

    private void saveNewContent(IFile file, String newContent) {
        try {
            file.setContents((InputStream)new ByteArrayInputStream(newContent.getBytes(file.getCharset())), false, true, this.getMonitor());
        }
        catch (CoreException e) {
            this.logError("message.error.core_exception", e);
        }
        catch (IOException e) {
            this.logError("message.error.io_exception", e);
        }
    }

    public boolean visit(IResource resource) throws CoreException {
        if (resource instanceof IFile) {
            this.clearReviews((IFile)resource);
        }
        return resource instanceof IProject || resource instanceof IFolder;
    }
}

