/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.actions;

import java.util.List;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.cmd.RenderReportsCmd;
import net.sourceforge.pmd.eclipse.ui.actions.AbstractUIAction;
import net.sourceforge.pmd.eclipse.ui.reports.ReportManager;
import net.sourceforge.pmd.renderers.Renderer;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateReportAction
extends AbstractUIAction {
    private static final Logger LOG = LoggerFactory.getLogger(GenerateReportAction.class);
    private static final String DEFAULT_REPORT_NAME = "pmd-report";

    private void registerRenderers(RenderReportsCmd cmd) {
        ReportManager.loadReportProperties();
        for (Renderer renderer : ReportManager.INSTANCE.activeRenderers()) {
            cmd.registerRenderer(renderer, "pmd-report." + renderer.defaultFileExtension());
        }
    }

    private boolean checkRenderers() {
        List<Renderer> renderers = ReportManager.INSTANCE.activeRenderers();
        if (renderers.isEmpty()) {
            PMDPlugin.getDefault().showUserError("No report renderers selected");
            return false;
        }
        StringBuilder errors = new StringBuilder();
        for (Renderer renderer : renderers) {
            String issue = renderer.dysfunctionReason();
            if (!StringUtils.isNotBlank((CharSequence)issue)) continue;
            errors.append(renderer.getName()).append(": ");
            errors.append(issue).append("\n");
        }
        if (errors.length() == 0) {
            return true;
        }
        PMDPlugin.getDefault().showUserError(errors.toString());
        return false;
    }

    public final void run(IAction action) {
        LOG.info("Generation Report action requested");
        ISelection sel = this.targetSelection();
        if (sel instanceof IStructuredSelection) {
            try {
                IProject project = GenerateReportAction.getProject((IStructuredSelection)sel);
                if (project != null) {
                    if (!this.checkRenderers()) {
                        return;
                    }
                    RenderReportsCmd cmd = new RenderReportsCmd();
                    cmd.setProject(project);
                    cmd.setUserInitiated(true);
                    this.registerRenderers(cmd);
                    cmd.performExecute();
                }
            }
            catch (RuntimeException e) {
                this.showErrorById("message.error.pmd_exception", e);
            }
        }
    }

    private static IProject getProject(IStructuredSelection selection) {
        IResource resource;
        Object object = selection.getFirstElement();
        if (object instanceof IAdaptable && (resource = (IResource)((IAdaptable)object).getAdapter(IResource.class)) != null) {
            return resource.getProject();
        }
        return null;
    }
}

