/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.actions;

import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.cmd.ReviewCodeCmd;
import net.sourceforge.pmd.eclipse.ui.actions.AbstractUIAction;
import net.sourceforge.pmd.eclipse.ui.model.AbstractPMDRecord;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkingSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PMDCheckAction
extends AbstractUIAction {
    private static final Logger LOG = LoggerFactory.getLogger(PMDCheckAction.class);

    public PMDCheckAction() {
        LOG.info("New Check Action created...");
    }

    public void run(IAction action) {
        LOG.info("Check PMD action requested");
        try {
            ISelection selection = this.targetSelection();
            if (selection instanceof IStructuredSelection) {
                this.reviewSelectedResources((IStructuredSelection)selection);
            } else {
                LOG.debug("The selection is not an instance of IStructuredSelection. This is not supported: " + selection.getClass().getName());
            }
        }
        catch (RuntimeException e) {
            this.showErrorById("message.error.core_exception", e);
        }
    }

    private void setupAndExecute(ReviewCodeCmd cmd) {
        cmd.setOpenPmdPerspective(PMDPlugin.getDefault().loadPreferences().isPmdPerspectiveEnabled());
        cmd.setOpenPmdViolationsOverviewView(PMDPlugin.getDefault().loadPreferences().isPmdViolationsOverviewEnabled());
        cmd.setOpenPmdViolationsOutlineView(PMDPlugin.getDefault().loadPreferences().isPmdViolationsOutlineEnabled());
        cmd.setUserInitiated(true);
        cmd.setRunAlways(true);
        cmd.performExecute();
    }

    private void reviewSelectedResources(IStructuredSelection selection) {
        ReviewCodeCmd cmd = new ReviewCodeCmd();
        for (Object element : selection) {
            if (element instanceof AbstractPMDRecord) {
                IResource resource = ((AbstractPMDRecord)element).getResource();
                if (resource != null) {
                    cmd.addResource(resource);
                    continue;
                }
                LOG.warn("The selected object has no resource");
                LOG.debug("  -> selected object : " + element);
                continue;
            }
            if (element instanceof IWorkingSet) {
                IWorkingSet set = (IWorkingSet)element;
                IAdaptable[] iAdaptableArray = set.getElements();
                int n = iAdaptableArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IAdaptable adaptable = iAdaptableArray[n2];
                    this.addAdaptable(cmd, adaptable);
                    ++n2;
                }
                continue;
            }
            if (element instanceof IAdaptable) {
                IAdaptable adaptable = (IAdaptable)element;
                this.addAdaptable(cmd, adaptable);
                continue;
            }
            LOG.warn("The selected object is not adaptable");
            LOG.debug("   -> selected object : " + element);
        }
        this.setupAndExecute(cmd);
    }

    private void addAdaptable(ReviewCodeCmd cmd, IAdaptable adaptable) {
        IResource resource = (IResource)adaptable.getAdapter(IResource.class);
        if (resource != null) {
            cmd.addResource(resource);
        } else {
            LOG.warn("The selected object cannot adapt to a resource");
            LOG.debug("   -> selected object : " + adaptable);
        }
    }
}

