/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.actions;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.writer.IAstWriter;
import net.sourceforge.pmd.eclipse.runtime.writer.WriterException;
import net.sourceforge.pmd.eclipse.ui.actions.AbstractUIAction;
import net.sourceforge.pmd.lang.LanguageProcessor;
import net.sourceforge.pmd.lang.LanguageProcessorRegistry;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.ast.ParseException;
import net.sourceforge.pmd.lang.ast.Parser;
import net.sourceforge.pmd.lang.ast.SemanticErrorReporter;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.document.TextDocument;
import net.sourceforge.pmd.lang.document.TextFile;
import net.sourceforge.pmd.lang.java.JavaLanguageModule;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PMDGenerateASTAction
extends AbstractUIAction
implements IRunnableWithProgress {
    private static final Logger LOG = LoggerFactory.getLogger(PMDGenerateASTAction.class);

    public void run(IAction action) {
        LOG.info("Generation AST action requested");
        ISelection sel = this.targetSelection();
        if (sel instanceof IStructuredSelection) {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            try {
                dialog.run(false, false, (IRunnableWithProgress)this);
            }
            catch (InvocationTargetException e) {
                this.showErrorById("message.error.invocationtarget_exception", e);
            }
            catch (InterruptedException e) {
                this.showErrorById("message.error.interrupted_exception", e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void generateAST(IFile file) {
        LOG.info("Generating AST for file " + file.getName());
        JavaLanguageModule javaLanguage = JavaLanguageModule.getInstance();
        try {
            Throwable throwable = null;
            Object var4_9 = null;
            try {
                InputStreamReader reader = new InputStreamReader(file.getContents(), file.getCharset());
                try {
                    block37: {
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        try {
                            block36: {
                                LanguageProcessor javaProcessor = javaLanguage.createProcessor(javaLanguage.newPropertyBundle());
                                try {
                                    block35: {
                                        try (TextDocument textDocument = TextDocument.create((TextFile)TextFile.forReader((Reader)reader, (FileId)FileId.fromPathLikeString((String)file.getName()), (LanguageVersion)javaLanguage.getDefaultVersion()));){
                                            Parser parser = javaProcessor.services().getParser();
                                            Parser.ParserTask parserTask = new Parser.ParserTask(textDocument, SemanticErrorReporter.noop(), LanguageProcessorRegistry.singleton((LanguageProcessor)javaProcessor));
                                            ASTCompilationUnit compilationUnit = (ASTCompilationUnit)parser.parse(parserTask);
                                            IAstWriter astWriter = PMDPlugin.getDefault().getAstWriter();
                                            astWriter.write(byteArrayOutputStream, compilationUnit);
                                            byteArrayOutputStream.flush();
                                            IFile astFile = PMDGenerateASTAction.createASTFile(file);
                                            if (astFile == null) break block35;
                                            if (astFile.exists()) {
                                                astFile.delete(false, null);
                                            }
                                            Throwable throwable2 = null;
                                            Object var15_25 = null;
                                            try (ByteArrayInputStream astInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());){
                                                astFile.create((InputStream)astInputStream, false, null);
                                            }
                                            catch (Throwable throwable3) {
                                                if (throwable2 == null) {
                                                    throwable2 = throwable3;
                                                    throw throwable2;
                                                }
                                                if (throwable2 == throwable3) throw throwable2;
                                                throwable2.addSuppressed(throwable3);
                                                throw throwable2;
                                            }
                                        }
                                    }
                                    if (javaProcessor == null) break block36;
                                }
                                catch (Throwable throwable4) {
                                    if (throwable == null) {
                                        throwable = throwable4;
                                    } else if (throwable != throwable4) {
                                        throwable.addSuppressed(throwable4);
                                    }
                                    if (javaProcessor == null) throw throwable;
                                    javaProcessor.close();
                                    throw throwable;
                                }
                                javaProcessor.close();
                            }
                            if (byteArrayOutputStream == null) break block37;
                        }
                        catch (Throwable throwable5) {
                            if (throwable == null) {
                                throwable = throwable5;
                            } else if (throwable != throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                            if (byteArrayOutputStream == null) throw throwable;
                            byteArrayOutputStream.close();
                            throw throwable;
                        }
                        byteArrayOutputStream.close();
                    }
                    if (reader == null) return;
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                    } else if (throwable != throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    if (reader == null) throw throwable;
                    ((Reader)reader).close();
                    throw throwable;
                }
                ((Reader)reader).close();
                return;
            }
            catch (Throwable throwable7) {
                if (throwable == null) {
                    throwable = throwable7;
                    throw throwable;
                }
                if (throwable == throwable7) throw throwable;
                throwable.addSuppressed(throwable7);
                throw throwable;
            }
        }
        catch (CoreException e) {
            this.showErrorById("message.error.core_exception", e);
            return;
        }
        catch (WriterException | ParseException e) {
            this.showErrorById("message.error.pmd_exception", e);
            return;
        }
        catch (IOException e) {
            this.showErrorById("message.error.io_exception", e);
            return;
        }
        catch (Exception e) {
            this.showErrorById("message.error.pmd_exception", e);
        }
    }

    private static IFile createASTFile(IFile file) {
        String astName = PMDGenerateASTAction.astNameFor(file);
        IFile astFile = null;
        IContainer parent = file.getParent();
        if (parent instanceof IFolder) {
            astFile = ((IFolder)parent).getFile(astName);
        } else if (parent instanceof IProject) {
            astFile = ((IProject)parent).getFile(astName);
        }
        return astFile;
    }

    private static String astNameFor(IFile file) {
        String name = file.getName();
        int dotPosition = name.indexOf(46);
        return String.valueOf(name.substring(0, dotPosition)) + ".ast";
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        IStructuredSelection structuredSelection = (IStructuredSelection)this.targetSelection();
        monitor.beginTask("", structuredSelection.size());
        for (Object element : structuredSelection) {
            if (element instanceof IAdaptable) {
                IAdaptable adaptable = (IAdaptable)element;
                IResource resource = (IResource)adaptable.getAdapter(IResource.class);
                if (resource != null) {
                    monitor.subTask(resource.getName());
                    this.generateAST((IFile)resource);
                    monitor.worked(1);
                    continue;
                }
                LOG.warn("The selected object cannot adapt to a resource");
                LOG.debug("   -> selected object : " + element);
                continue;
            }
            LOG.warn("The selected object is not adaptable");
            LOG.debug("   -> selected object : " + element);
        }
    }
}

