/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.actions;

import net.sourceforge.pmd.eclipse.runtime.builder.MarkerUtil;
import net.sourceforge.pmd.eclipse.ui.actions.AbstractUIAction;
import net.sourceforge.pmd.eclipse.ui.model.AbstractPMDRecord;
import net.sourceforge.pmd.eclipse.ui.views.ViolationOverview;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PMDRemoveMarkersAction
extends AbstractUIAction
implements IViewActionDelegate {
    private static final String VIEW_ACTION = "net.sourceforge.pmd.eclipse.ui.pmdRemoveAllMarkersAction";
    private static final String OBJECT_ACTION = "net.sourceforge.pmd.eclipse.ui.pmdRemoveMarkersAction";
    private static final Logger LOG = LoggerFactory.getLogger(PMDRemoveMarkersAction.class);

    public void init(IViewPart view) {
        this.setActivePart(null, (IWorkbenchPart)view);
    }

    public void run(IAction action) {
        LOG.info("Remove Markers action requested");
        try {
            if (VIEW_ACTION.equals(action.getId())) {
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                MarkerUtil.deleteAllMarkersIn((IResource)root);
                LOG.debug("Remove markers over the whole workspace");
            } else if (OBJECT_ACTION.equals(action.getId())) {
                this.processResource();
            } else {
                LOG.warn("Cannot remove markers, action ID is not supported");
            }
        }
        catch (CoreException e) {
            this.showErrorById("message.error.core_exception", e);
        }
    }

    private void processResource() {
        LOG.debug("Processing a resource");
        try {
            ISelection sel = this.targetSelection();
            if (sel instanceof IStructuredSelection) {
                IStructuredSelection structuredSel = (IStructuredSelection)sel;
                for (Object element : structuredSel) {
                    this.processElement(element);
                }
            } else {
                LOG.warn("The view part selection is not a structured selection !");
            }
        }
        catch (CoreException e) {
            this.showErrorById("message.error.core_exception", e);
        }
    }

    private void processElement(Object element) throws CoreException {
        if (element instanceof AbstractPMDRecord) {
            AbstractPMDRecord record = (AbstractPMDRecord)element;
            IResource resource = record.getResource();
            if (this.isViolationOverview()) {
                ((ViolationOverview)this.targetPart()).deleteMarkers(record);
            }
            LOG.debug("Remove markers on resource " + resource.getName());
        } else if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            IResource resource = (IResource)adaptable.getAdapter(IResource.class);
            if (resource == null) {
                LOG.warn("The selected object cannot adapt to a resource");
                LOG.debug("   -> selected object : " + element);
            } else {
                MarkerUtil.deleteAllMarkersIn(resource);
                LOG.debug("Remove markers on resrouce " + resource.getName());
            }
        } else {
            LOG.warn("The selected object is not adaptable");
            LOG.debug("   -> selected object : " + element);
        }
    }
}

