/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.actions;

import java.util.ArrayList;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.cmd.ReviewCodeCmd;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.ILocationProvider;

public class ReviewCodeHandler
extends AbstractHandler {
    private IWorkbenchWindow fWindow;
    private IResource[] fResources;
    private IPath fLocation;

    protected final ISelection getSelection() {
        IWorkbenchWindow window = this.getWorkbenchWindow();
        return window != null ? window.getSelectionService().getSelection() : null;
    }

    protected final IWorkbenchWindow getWorkbenchWindow() {
        if (this.fWindow == null) {
            this.fWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        }
        return this.fWindow;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.computeSelectedResources();
        try {
            if (this.fResources != null && this.fResources.length > 0) {
                ReviewCodeCmd cmd = new ReviewCodeCmd();
                cmd.reset();
                IResource[] iResourceArray = this.fResources;
                int n = this.fResources.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource rsc = iResourceArray[n2];
                    cmd.addResource(rsc);
                    ++n2;
                }
                try {
                    cmd.performExecute();
                }
                catch (RuntimeException e) {
                    PMDPlugin.getDefault().log(4, "Error processing user-initiated code review", e);
                }
            }
            return null;
        }
        finally {
            this.fResources = null;
            this.fLocation = null;
        }
    }

    protected final void computeSelectedResources() {
        IWorkbenchPart workbenchPart;
        IWorkbenchWindow window;
        if (this.fResources != null || this.fLocation != null) {
            return;
        }
        ISelection selection = this.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            ArrayList<IResource> resources = new ArrayList<IResource>(structuredSelection.size());
            for (Object element : structuredSelection) {
                IAdaptable adaptable;
                Object adapter;
                if (element instanceof IResource) {
                    resources.add((IResource)element);
                    continue;
                }
                if (!(element instanceof IAdaptable) || !((adapter = (adaptable = (IAdaptable)element).getAdapter(IResource.class)) instanceof IResource)) continue;
                resources.add((IResource)adapter);
            }
            if (!resources.isEmpty()) {
                this.fResources = resources.toArray(new IResource[0]);
            }
        } else if (selection instanceof ITextSelection && (window = this.getWorkbenchWindow()) != null && (workbenchPart = window.getPartService().getActivePart()) instanceof IEditorPart) {
            IEditorPart editorPart = (IEditorPart)workbenchPart;
            IEditorInput input = editorPart.getEditorInput();
            Object adapter = input.getAdapter(IResource.class);
            if (adapter instanceof IResource) {
                this.fResources = new IResource[]{(IResource)adapter};
            } else {
                adapter = input.getAdapter(ILocationProvider.class);
                if (adapter instanceof ILocationProvider) {
                    ILocationProvider provider = (ILocationProvider)adapter;
                    this.fLocation = provider.getPath((Object)input);
                }
            }
        }
    }
}

