/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.actions;

import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.lang.rule.RuleSet;
import net.sourceforge.pmd.lang.rule.RuleSetLoader;

public final class RuleSetUtil {
    public static final String DEFAULT_RULESET_NAME = "pmd-eclipse";
    public static final String DEFAULT_RULESET_DESCRIPTION = "PMD Plugin preferences rule set";

    private RuleSetUtil() {
    }

    public static RuleSet newCopyOf(RuleSet original) {
        return RuleSet.copy((RuleSet)original);
    }

    public static RuleSet retainOnly(RuleSet ruleSet, Collection<Rule> wantedRules) {
        return RuleSet.create((String)ruleSet.getName(), (String)ruleSet.getDescription(), (String)ruleSet.getFileName(), (Collection)ruleSet.getFileExclusions(), (Collection)ruleSet.getFileInclusions(), wantedRules);
    }

    public static RuleSet removeRule(RuleSet ruleSet, Rule removedRule) {
        ArrayList<Rule> wantedRules = new ArrayList<Rule>(ruleSet.getRules());
        wantedRules.remove(removedRule);
        return RuleSetUtil.retainOnly(ruleSet, wantedRules);
    }

    public static RuleSet newSingle(Rule rule) {
        return RuleSet.forSingleRule((Rule)rule);
    }

    public static RuleSet newEmpty(String name, String description) {
        Set emptySet = Collections.emptySet();
        Set emptyRules = Collections.emptySet();
        return RuleSet.create((String)name, (String)description, null, emptySet, emptySet, emptyRules);
    }

    public static RuleSet addRuleSetByReference(RuleSet ruleSet, RuleSet sourceRuleSet) {
        StringWriter ruleSetXml = new StringWriter();
        try {
            XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(ruleSetXml);
            writer.writeStartDocument(StandardCharsets.UTF_8.name(), "1.0");
            writer.writeStartElement("ruleset");
            writer.writeAttribute("name", ruleSet.getName());
            writer.writeStartElement("description");
            writer.writeCharacters(ruleSet.getDescription());
            writer.writeEndElement();
            for (Rule rule : sourceRuleSet.getRules()) {
                writer.writeStartElement("rule");
                writer.writeAttribute("ref", String.valueOf(sourceRuleSet.getFileName()) + "/" + rule.getName());
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.flush();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
        RuleSetLoader ruleSetLoader = new RuleSetLoader();
        RuleSet withReferences = ruleSetLoader.loadFromString("temporary-ruleset.xml", ruleSetXml.toString());
        ArrayList allRulesList = new ArrayList(ruleSet.getRules());
        allRulesList.addAll(withReferences.getRules());
        return RuleSet.create((String)ruleSet.getName(), (String)ruleSet.getDescription(), (String)ruleSet.getFileName(), (Collection)ruleSet.getFileExclusions(), (Collection)ruleSet.getFileInclusions(), allRulesList);
    }

    public static RuleSet addRules(RuleSet ruleSet, Collection<Rule> newRules) {
        ArrayList<Rule> allRules = new ArrayList<Rule>();
        allRules.addAll(ruleSet.getRules());
        allRules.addAll(newRules);
        return RuleSet.create((String)ruleSet.getName(), (String)ruleSet.getDescription(), (String)ruleSet.getFileName(), (Collection)ruleSet.getFileExclusions(), (Collection)ruleSet.getFileInclusions(), allRules);
    }

    public static RuleSet addRule(RuleSet ruleSet, Rule newRule) {
        return RuleSetUtil.addRules(ruleSet, Collections.singleton(newRule));
    }

    public static RuleSet setNameDescription(RuleSet ruleSet, String name, String description) {
        return RuleSet.create((String)name, (String)description, (String)ruleSet.getFileName(), (Collection)ruleSet.getFileExclusions(), (Collection)ruleSet.getFileInclusions(), (Iterable)ruleSet.getRules());
    }

    public static RuleSet setFileName(RuleSet ruleSet, String fileName) {
        return RuleSet.create((String)ruleSet.getName(), (String)ruleSet.getDescription(), (String)fileName, (Collection)ruleSet.getFileExclusions(), (Collection)ruleSet.getFileInclusions(), (Iterable)ruleSet.getRules());
    }

    public static RuleSet clearRules(RuleSet ruleSet) {
        Set emptySet = Collections.emptySet();
        return RuleSet.create((String)ruleSet.getName(), (String)ruleSet.getDescription(), (String)ruleSet.getFileName(), (Collection)ruleSet.getFileExclusions(), (Collection)ruleSet.getFileInclusions(), emptySet);
    }

    public static Rule findSameRule(Collection<Rule> haystack, Rule search) {
        for (Rule rule : haystack) {
            if (rule != search && (!rule.getName().equals(search.getName()) || rule.getLanguage() != search.getLanguage())) continue;
            return rule;
        }
        return null;
    }
}

