/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.actions.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.lang.rule.RulePriority;
import net.sourceforge.pmd.lang.rule.RuleSet;
import net.sourceforge.pmd.lang.rule.RuleSetLoader;

public final class InternalRuleSetUtil {
    private InternalRuleSetUtil() {
    }

    public static RuleSet setFileExclusions(RuleSet ruleSet, Collection<Pattern> excludePatterns) {
        return RuleSet.create((String)ruleSet.getName(), (String)ruleSet.getDescription(), (String)ruleSet.getFileName(), excludePatterns, (Collection)ruleSet.getFileInclusions(), (Iterable)ruleSet.getRules());
    }

    public static RuleSet setFileInclusions(RuleSet ruleSet, Collection<Pattern> includePatterns) {
        return RuleSet.create((String)ruleSet.getName(), (String)ruleSet.getDescription(), (String)ruleSet.getFileName(), (Collection)ruleSet.getFileExclusions(), includePatterns, (Iterable)ruleSet.getRules());
    }

    public static RuleSet addFileExclusions(RuleSet rs, Collection<Pattern> excludePatterns) {
        return InternalRuleSetUtil.addExcludePatterns(rs, excludePatterns, new HashSet<Pattern>());
    }

    public static RuleSet addFileInclusions(RuleSet rs, Collection<Pattern> includePatterns) {
        return InternalRuleSetUtil.addIncludePatterns(rs, includePatterns, new HashSet<Pattern>());
    }

    public static RuleSet addExcludePatterns(RuleSet ruleSet, Collection<Pattern> activeExclusionPatterns, Collection<Pattern> buildPathExcludePatterns) {
        HashSet<Pattern> newExcludePatterns = new HashSet<Pattern>(ruleSet.getFileExclusions());
        newExcludePatterns.addAll(activeExclusionPatterns);
        newExcludePatterns.addAll(buildPathExcludePatterns);
        HashSet newIncludePatterns = new HashSet(ruleSet.getFileInclusions());
        return RuleSet.create((String)ruleSet.getName(), (String)ruleSet.getDescription(), (String)ruleSet.getFileName(), newExcludePatterns, newIncludePatterns, (Iterable)ruleSet.getRules());
    }

    public static RuleSet addIncludePatterns(RuleSet ruleSet, Collection<Pattern> activeInclusionPatterns, Collection<Pattern> buildPathIncludePatterns) {
        HashSet newExcludePatterns = new HashSet(ruleSet.getFileExclusions());
        HashSet<Pattern> newIncludePatterns = new HashSet<Pattern>(ruleSet.getFileInclusions());
        newIncludePatterns.addAll(activeInclusionPatterns);
        newIncludePatterns.addAll(buildPathIncludePatterns);
        return RuleSet.create((String)ruleSet.getName(), (String)ruleSet.getDescription(), (String)ruleSet.getFileName(), newExcludePatterns, newIncludePatterns, (Iterable)ruleSet.getRules());
    }

    public static Collection<String> convert(Collection<Pattern> patterns) {
        HashSet<String> result = new HashSet<String>();
        for (Pattern p : patterns) {
            result.add(p.pattern());
        }
        return result;
    }

    public static Collection<Pattern> convertStringPatterns(Collection<String> patterns) {
        HashSet<Pattern> result = new HashSet<Pattern>();
        for (String p : patterns) {
            result.add(Pattern.compile(p));
        }
        return result;
    }

    public static int countRules(List<RuleSet> rulesets) {
        int rules = 0;
        for (RuleSet ruleset : rulesets) {
            rules += ruleset.size();
        }
        return rules;
    }

    public static Collection<Rule> allRules(List<RuleSet> rulesets) {
        ArrayList<Rule> result = new ArrayList<Rule>();
        for (RuleSet ruleset : rulesets) {
            result.addAll(ruleset.getRules());
        }
        return result;
    }

    public static RuleSetLoader getDefaultRuleSetLoader() {
        return new RuleSetLoader().warnDeprecated(false).filterAbovePriority(RulePriority.LOW);
    }
}

