/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.dialogs;

import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.util.internal.SWTUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;

public class CPDCheckDialog
extends Dialog {
    private final String[] languages;
    private final String[] formats;
    private int selectedFormat;
    private String selectedLanguage;
    private boolean createReport;
    private Group reportGroup = null;
    private Button createReportCheckbox = null;
    private Combo languageCombo = null;
    private Spinner minTileSizeSpinner = null;
    private Combo formatCombo = null;
    private int tileSize = this.defaultMinTileSize();

    public CPDCheckDialog(Shell parentShell, String[] languages, String[] formats) {
        super(parentShell);
        this.languages = languages;
        this.formats = formats;
    }

    public boolean close() {
        this.selectedLanguage = this.languageCombo.getText();
        return super.close();
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        this.initialize(container);
        return container;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.getString("dialog.cpd.title"));
    }

    public String getSelectedLanguage() {
        return this.selectedLanguage;
    }

    private int defaultMinTileSize() {
        return PMDPlugin.getDefault().loadPreferences().getMinTileSize();
    }

    public String getSelectedFormat() {
        return this.formats[this.selectedFormat];
    }

    public boolean isCreateReportSelected() {
        return this.createReport;
    }

    public int getTileSize() {
        return this.tileSize;
    }

    private void initialize(Composite container) {
        GridData gridData7 = new GridData();
        gridData7.horizontalAlignment = 3;
        gridData7.horizontalIndent = 40;
        gridData7.verticalAlignment = 2;
        GridData gridData6 = new GridData();
        gridData6.horizontalAlignment = 3;
        gridData6.verticalAlignment = 2;
        GridData gridData4 = new GridData();
        gridData4.verticalIndent = 5;
        gridData4.horizontalIndent = 5;
        gridData4.horizontalSpan = 2;
        GridLayout gridLayout1 = new GridLayout();
        gridLayout1.numColumns = 2;
        gridLayout1.makeColumnsEqualWidth = false;
        container.setLayout((Layout)gridLayout1);
        Label helpLabel = new Label(container, 0);
        helpLabel.setText(this.getString("dialog.cpd.help.label"));
        helpLabel.setLayoutData((Object)gridData4);
        Label languageLabel = new Label(container, 0);
        languageLabel.setText(this.getString("dialog.cpd.language.label"));
        languageLabel.setLayoutData((Object)gridData6);
        this.createLanguageCombo(container);
        Label minimumTileSizeLabel = new Label(container, 0);
        minimumTileSizeLabel.setText(this.getString("dialog.cpd.min_tilesize.label"));
        minimumTileSizeLabel.setLayoutData((Object)gridData7);
        this.createTileSizeSpinner(container);
        this.createReportGroup(container);
    }

    private void createTileSizeSpinner(Composite container) {
        GridData gridData5 = new GridData();
        gridData5.horizontalAlignment = 4;
        gridData5.grabExcessHorizontalSpace = true;
        gridData5.horizontalIndent = 10;
        gridData5.heightHint = -1;
        gridData5.verticalAlignment = 2;
        this.minTileSizeSpinner = new Spinner(container, 2048);
        this.minTileSizeSpinner.setLayoutData((Object)gridData5);
        this.minTileSizeSpinner.setToolTipText(this.getString("dialog.tooltip.cpd.tilesize"));
        this.minTileSizeSpinner.setMinimum(this.tileSize);
        this.minTileSizeSpinner.setTextLimit(3);
        this.minTileSizeSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CPDCheckDialog.this.tileSize = Integer.parseInt(CPDCheckDialog.this.minTileSizeSpinner.getText());
            }
        });
    }

    private void createReportGroup(Composite container) {
        GridData gridData7 = new GridData();
        gridData7.horizontalAlignment = 1;
        gridData7.horizontalIndent = 30;
        gridData7.verticalAlignment = 2;
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 1;
        gridData2.horizontalSpan = 2;
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.verticalAlignment = 2;
        GridData gridData11 = new GridData();
        gridData11.horizontalAlignment = 4;
        gridData11.verticalAlignment = 2;
        gridData11.heightHint = -1;
        gridData11.grabExcessHorizontalSpace = true;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        gridData.verticalAlignment = 2;
        gridData.verticalIndent = 10;
        gridData.horizontalIndent = 10;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.reportGroup = new Group(container, 0);
        this.reportGroup.setText(this.getString("dialog.cpd.report"));
        this.reportGroup.setLayoutData((Object)gridData);
        this.reportGroup.setLayout((Layout)gridLayout);
        this.createReportCheckbox = new Button((Composite)this.reportGroup, 32);
        this.createReportCheckbox.setText(this.getString("dialog.cpd.create_report"));
        this.createReportCheckbox.setLayoutData((Object)gridData2);
        this.createReportCheckbox.setSelection(true);
        this.createReport = true;
        this.createReportCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                CPDCheckDialog.this.formatCombo.setEnabled(CPDCheckDialog.this.createReportCheckbox.getSelection());
                CPDCheckDialog.this.createReport = CPDCheckDialog.this.createReportCheckbox.getSelection();
            }

            public void widgetSelected(SelectionEvent e) {
                CPDCheckDialog.this.formatCombo.setEnabled(CPDCheckDialog.this.createReportCheckbox.getSelection());
                CPDCheckDialog.this.createReport = CPDCheckDialog.this.createReportCheckbox.getSelection();
            }
        });
        Label formatLabel = new Label((Composite)this.reportGroup, 0);
        formatLabel.setText(this.getString("dialog.cpd.format.label"));
        formatLabel.setLayoutData((Object)gridData7);
        this.createFormatCombo();
    }

    private void createLanguageCombo(Composite container) {
        GridData gridData4 = new GridData();
        gridData4.grabExcessHorizontalSpace = true;
        gridData4.verticalAlignment = 2;
        gridData4.verticalIndent = 10;
        gridData4.horizontalIndent = 10;
        gridData4.horizontalAlignment = 4;
        this.languageCombo = new Combo(container, 12);
        this.languageCombo.setLayoutData((Object)gridData4);
        this.languageCombo.setItems(this.languages);
        this.languageCombo.select(0);
        this.languageCombo.setToolTipText(this.getString("dialog.tooltip.cpd.language"));
    }

    private void createFormatCombo() {
        GridData gridData3 = new GridData();
        gridData3.grabExcessHorizontalSpace = false;
        gridData3.widthHint = 150;
        gridData3.horizontalAlignment = 1;
        gridData3.horizontalIndent = 10;
        gridData3.verticalAlignment = 2;
        this.formatCombo = new Combo((Composite)this.reportGroup, 12);
        this.formatCombo.setLayoutData((Object)gridData3);
        this.formatCombo.setItems(this.formats);
        this.formatCombo.setToolTipText(this.getString("dialog.tooltip.cpd.format"));
        this.formatCombo.select(0);
        this.formatCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                CPDCheckDialog.this.selectedFormat = CPDCheckDialog.this.formatCombo.getSelectionIndex();
            }

            public void widgetSelected(SelectionEvent e) {
                CPDCheckDialog.this.selectedFormat = CPDCheckDialog.this.formatCombo.getSelectionIndex();
            }
        });
    }

    private String getString(String key) {
        return SWTUtil.stringFor(key);
    }
}

