/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.dialogs;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.eclipse.ui.preferences.br.EditorFactory;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleUIUtil;
import net.sourceforge.pmd.eclipse.ui.preferences.br.SizeChangeListener;
import net.sourceforge.pmd.eclipse.ui.preferences.br.ValueChangeListener;
import net.sourceforge.pmd.eclipse.ui.preferences.internal.PropertyEditorFactory;
import net.sourceforge.pmd.eclipse.util.Util;
import net.sourceforge.pmd.eclipse.util.internal.SWTUtil;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.lang.rule.RuleReference;
import net.sourceforge.pmd.lang.rule.xpath.XPathRule;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertySource;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewPropertyDialog
extends TitleAreaDialog
implements SizeChangeListener {
    private Text nameField;
    private Text descriptionField;
    private Combo typeField;
    private Control[] factoryControls;
    private Composite dlgArea;
    private EditorFactory<?> factory;
    private ValueChangeListener changeListener;
    private PropertySource propertySource;
    private PropertyDescriptor<?> descriptor;
    private static final Class<?>[] VALID_EDITOR_TYPES = new Class[]{String.class, Integer.class, Boolean.class};
    private static final Class<?> DEFAULT_EDITOR_TYPE = VALID_EDITOR_TYPES[0];

    public NewPropertyDialog(Shell parent, PropertySource theSource, ValueChangeListener theChangeListener) {
        super(parent);
        this.setShellStyle(68720);
        this.propertySource = theSource;
        this.changeListener = theChangeListener;
    }

    @Deprecated
    public NewPropertyDialog(Shell parent, Map<Class<?>, EditorFactory<?>> theEditorFactoriesByValueType, PropertySource theSource, ValueChangeListener theChangeListener) {
        this(parent, theSource, theChangeListener);
    }

    @Deprecated
    public NewPropertyDialog(Shell parent, Map<Class<?>, EditorFactory<?>> theEditorFactoriesByValueType, Rule theRule, PropertyDescriptor<?> theDescriptor, ValueChangeListener theChangeListener) {
        this(parent, theEditorFactoriesByValueType, (PropertySource)theRule, theChangeListener);
        this.descriptor = theDescriptor;
    }

    @Deprecated
    public static Map<Class<?>, EditorFactory<?>> withOnly(Map<Class<?>, EditorFactory<?>> factoriesByType, Class<?>[] legalTypeKeys) {
        HashMap results = new HashMap(legalTypeKeys.length);
        Class<?>[] classArray = legalTypeKeys;
        int n = legalTypeKeys.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> type = classArray[n2];
            if (factoriesByType.containsKey(type)) {
                results.put(type, factoriesByType.get(type));
            }
            ++n2;
        }
        return results;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(SWTUtil.stringFor("dialog.preferences.add_new_property"));
        this.dlgArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.verticalSpacing = 2;
        layout.marginTop = 1;
        this.dlgArea.setLayout((Layout)layout);
        this.dlgArea.setLayoutData((Object)new GridData(1808));
        this.buildLabel(this.dlgArea, "Name:");
        this.nameField = this.buildNameText(this.dlgArea);
        this.buildLabel(this.dlgArea, "Datatype:");
        this.typeField = this.buildTypeField(this.dlgArea);
        this.buildLabel(this.dlgArea, "Description:");
        this.descriptionField = this.buildDescriptionField(this.dlgArea);
        this.setPreferredName();
        this.setInitialType();
        this.dlgArea.pack();
        return this.dlgArea;
    }

    protected Control createButtonBar(Composite parent) {
        Control result = super.createButtonBar(parent);
        this.validateForm();
        return result;
    }

    private Label buildLabel(Composite parent, String msgKey) {
        Label label = new Label(parent, 0);
        label.setText(msgKey == null ? "" : SWTUtil.stringFor(msgKey));
        return label;
    }

    private void setFieldLayoutData(Control widget) {
        GridData data = new GridData();
        data.horizontalSpan = 1;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        widget.setLayoutData((Object)data);
    }

    private Text buildNameText(Composite parent) {
        Text text = new Text(parent, 2052);
        this.setFieldLayoutData((Control)text);
        text.addVerifyListener(RuleUIUtil.RULE_NAME_VERIFIER);
        text.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                NewPropertyDialog.this.validateForm();
            }
        });
        return text;
    }

    private boolean isValidNewDescription(String descriptionCandidate) {
        return StringUtils.isNotBlank((CharSequence)descriptionCandidate);
    }

    private boolean isPreExistingDescription(String descriptionCandidate) {
        for (PropertyDescriptor desc : this.propertySource.getPropertyDescriptors()) {
            if (!desc.description().equalsIgnoreCase(descriptionCandidate)) continue;
            return false;
        }
        return true;
    }

    private Text buildDescriptionField(Composite parent) {
        Text text = new Text(parent, 2052);
        this.setFieldLayoutData((Control)text);
        text.addVerifyListener(RuleUIUtil.RULE_LABEL_VERIFIER);
        text.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                NewPropertyDialog.this.validateForm();
            }
        });
        return text;
    }

    private static String labelFor(Class<?> type) {
        return Util.signatureFor(type, new String[0]);
    }

    private Combo buildTypeField(Composite parent) {
        Combo combo = new Combo(parent, 8);
        this.setFieldLayoutData((Control)combo);
        Object[] labels = new String[VALID_EDITOR_TYPES.length];
        int i = 0;
        while (i < labels.length) {
            labels[i] = VALID_EDITOR_TYPES[i].getSimpleName();
            ++i;
        }
        Arrays.sort(labels);
        combo.setItems((String[])labels);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertyEditorFactory factory = PropertyEditorFactory.INSTANCE;
                NewPropertyDialog.this.factory(factory);
            }
        });
        return combo;
    }

    private boolean ruleHasPropertyName(String name) {
        return this.propertySource.getPropertyDescriptor(name) != null;
    }

    private static XPathRule toXPathRule(PropertySource propertySource) {
        PropertySource rule = propertySource;
        if (propertySource instanceof RuleReference) {
            rule = ((RuleReference)propertySource).getRule();
        }
        if (rule instanceof XPathRule) {
            return (XPathRule)rule;
        }
        return null;
    }

    private void setPreferredName() {
        String xpath = "";
        XPathRule rule = NewPropertyDialog.toXPathRule(this.propertySource);
        if (rule != null) {
            xpath = rule.getXPathExpression().trim();
        }
        List<int[]> positions = Util.referencedNamePositionsIn(xpath, '$');
        List<String> names = Util.fragmentsWithin(xpath, positions);
        this.nameField.setText("");
        for (String name : names) {
            if (this.ruleHasPropertyName(name)) continue;
            if (!this.nameField.getText().isEmpty()) break;
            this.nameField.setText(name);
        }
    }

    private void setInitialType() {
        String editorLabel = NewPropertyDialog.labelFor(DEFAULT_EDITOR_TYPE);
        this.typeField.select(Util.indexOf(this.typeField.getItems(), editorLabel));
        this.factory(PropertyEditorFactory.INSTANCE);
    }

    private void cleanFactoryStuff() {
        if (this.factoryControls != null) {
            Control[] controlArray = this.factoryControls;
            int n = this.factoryControls.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                control.dispose();
                ++n2;
            }
        }
    }

    private void factory(EditorFactory<?> theFactory) {
        this.factory = theFactory;
        PropertyDescriptor<?> theDescriptor = theFactory.createDescriptor("propertyName", "The description", null);
        this.descriptor = theDescriptor;
        this.descriptionField.setText(theDescriptor.description());
        this.cleanFactoryStuff();
        this.factoryControls = theFactory.createOtherControlsOn(this.dlgArea, theDescriptor, this.propertySource, this.changeListener, this);
        this.dlgArea.getShell().layout();
        this.dlgArea.pack();
        this.dlgArea.getParent().pack();
    }

    protected void okPressed() {
        if (this.validateForm()) {
            this.descriptor = this.newDescriptor();
            super.okPressed();
        }
    }

    private boolean validateForm() {
        boolean isOk = this.validateName() && this.validateDescription();
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(isOk);
        }
        return isOk;
    }

    private boolean validateName() {
        String name = this.nameField.getText().trim();
        if (StringUtils.isBlank((CharSequence)name)) {
            this.setErrorMessage("A property name is required");
            return false;
        }
        if (this.ruleHasPropertyName(name)) {
            this.setErrorMessage("'" + name + "' is already used by another property");
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private boolean validateDescription() {
        String label = this.descriptionField.getText().trim();
        if (StringUtils.isBlank((CharSequence)label)) {
            this.setErrorMessage("A descriptive label is required");
            return false;
        }
        if (!this.isValidNewDescription(label)) {
            this.setErrorMessage("Invalid label");
            return false;
        }
        if (!this.isPreExistingDescription(label)) {
            this.setErrorMessage("Label text must differ from other label text");
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public PropertyDescriptor<?> descriptor() {
        return this.descriptor;
    }

    private PropertyDescriptor<?> newDescriptor() {
        return this.factory.createDescriptor(this.nameField.getText().trim(), this.descriptionField.getText().trim(), this.factoryControls);
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    @Override
    public void addedRows(int newRowCount) {
        this.dlgArea.pack();
        this.dlgArea.getParent().pack();
        System.out.println("rows added: " + newRowCount);
    }
}

