/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.dialogs;

import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.builder.MarkerUtil;
import net.sourceforge.pmd.eclipse.ui.dialogs.ViolationDetailsDialogPage;
import net.sourceforge.pmd.lang.rule.Rule;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.widgets.CompositeFactory;
import org.eclipse.jface.widgets.WidgetFactory;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class ViolationDetailsDialog
extends Dialog {
    private final IMarker violation;

    public ViolationDetailsDialog(Shell shell, IMarker selectedViolation) {
        super(shell);
        this.violation = selectedViolation;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(PMDPlugin.getDefault().getStringTable().getString("dialog.violation_details.title"));
    }

    protected boolean isResizable() {
        return true;
    }

    private Rule getSelectedViolationRule() {
        return PMDPlugin.getDefault().getPreferencesManager().getRuleSet().getRuleByName(MarkerUtil.ruleNameFor(this.violation));
    }

    protected Control createDialogArea(Composite parent) {
        ScrolledComposite scroll = new ScrolledComposite((Composite)super.createDialogArea(parent), 2816);
        scroll.setLayout((Layout)new GridLayout());
        scroll.setLayoutData((Object)new GridData(1808));
        Composite composite = (Composite)((CompositeFactory)((CompositeFactory)WidgetFactory.composite((int)0).layout((Layout)new GridLayout())).layoutData((Object)new GridData(1808))).create((Widget)scroll);
        scroll.setContent((Control)composite);
        ViolationDetailsDialogPage content = new ViolationDetailsDialogPage(this.violation, this.getSelectedViolationRule());
        content.createControl(composite);
        composite.setSize(composite.computeSize(-1, -1));
        return scroll;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, true);
    }

    protected void buttonPressed(int buttonId) {
        this.okPressed();
    }
}

