/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.dialogs;

import java.net.MalformedURLException;
import java.net.URL;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.ui.nls.StringTable;
import net.sourceforge.pmd.lang.rule.Rule;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.widgets.CompositeFactory;
import org.eclipse.jface.widgets.LabelFactory;
import org.eclipse.jface.widgets.TextFactory;
import org.eclipse.jface.widgets.WidgetFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;

public class ViolationDetailsDialogPage
extends DialogPage {
    private final IMarker violation;
    private final Rule rule;

    public ViolationDetailsDialogPage(IMarker selectedViolation, Rule selectedRule) {
        this.violation = selectedViolation;
        this.rule = selectedRule;
    }

    public void createControl(Composite parent) {
        StringTable messages = PMDPlugin.getDefault().getStringTable();
        GridLayout layout = new GridLayout(2, false);
        Composite composite = (Composite)((CompositeFactory)WidgetFactory.composite((int)0).layout((Layout)layout)).create((Widget)parent);
        this.createLabel(messages.getString("dialog.violation_details.message"), composite);
        this.createText(this.getViolationMessage(), composite);
        this.createLabel(messages.getString("dialog.violation_details.location"), composite);
        this.createText(this.getLocation(), composite);
        this.createLabel(messages.getString("dialog.violation_details.rulename"), composite);
        this.createText(this.rule.getName(), composite);
        this.createLabel(messages.getString("dialog.violation_details.category"), composite);
        this.createText(this.rule.getRuleSetName(), composite);
        this.createLabel(messages.getString("dialog.violation_details.priority"), composite);
        this.createText(this.rule.getPriority().getName(), composite);
        this.createTwoColumnLabel(messages.getString("dialog.violation_details.description"), composite);
        this.createTwoColumnMultiText(this.rule.getDescription(), composite);
        this.createTwoColumnLabel(messages.getString("dialog.violation_details.examples"), composite);
        this.createTwoColumnMultiText(this.getExamples(), JFaceResources.getTextFont(), composite);
        this.createLabel(messages.getString("dialog.violation_details.infourl"), composite);
        this.createLink(this.rule.getExternalInfoUrl(), composite);
    }

    private Label createLabel(String text, Composite parent) {
        return (Label)((LabelFactory)((LabelFactory)WidgetFactory.label((int)0).text(text).font(JFaceResources.getHeaderFont())).layoutData((Object)new GridData(2))).create((Widget)parent);
    }

    private Label createTwoColumnLabel(String text, Composite parent) {
        GridData gridData = new GridData();
        gridData.verticalAlignment = 1;
        gridData.horizontalSpan = 2;
        return (Label)((LabelFactory)((LabelFactory)WidgetFactory.label((int)0).text(text).font(JFaceResources.getHeaderFont())).layoutData((Object)gridData)).create((Widget)parent);
    }

    private Text createText(String text, Composite parent) {
        return (Text)((TextFactory)((TextFactory)WidgetFactory.text((int)12).background(parent.getBackground())).layoutData((Object)new GridData(768))).text(text).create((Widget)parent);
    }

    private Text createTwoColumnMultiText(String text, Composite parent) {
        return this.createTwoColumnMultiText(text, null, parent);
    }

    private Text createTwoColumnMultiText(String text, Font font, Composite parent) {
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        return (Text)((TextFactory)((TextFactory)((TextFactory)WidgetFactory.text((int)74).background(parent.getBackground())).layoutData((Object)gridData)).text(text).font(font)).create((Widget)parent);
    }

    private Link createLink(String url, Composite parent) {
        Link link = new Link(parent, 0);
        link.setText(String.format("<a href=\"%s\">%s</a>", url, url));
        link.addSelectionListener((SelectionListener)new LinkClickListener());
        link.setLayoutData((Object)new GridData(2));
        return link;
    }

    private String getViolationMessage() {
        String defaultMessage = this.violation.getAttribute("message", "");
        return this.violation.getAttribute("pmd_message", defaultMessage);
    }

    private String getLocation() {
        String projectName = this.violation.getResource().getProject().getName();
        String path = this.violation.getResource().getProjectRelativePath().toString();
        int lineNumber = this.violation.getAttribute("lineNumber", -1);
        if (lineNumber != -1) {
            return String.format("%s: %s:%d", projectName, path, lineNumber);
        }
        return String.format("%s: %s", projectName, path);
    }

    private String getExamples() {
        StringBuilder result = new StringBuilder();
        for (String example : this.rule.getExamples()) {
            result.append(example);
            result.append(System.lineSeparator());
            result.append(System.lineSeparator());
        }
        return result.toString();
    }

    private static final class LinkClickListener
    implements SelectionListener {
        private LinkClickListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            try {
                URL url = new URL(e.text);
                IWebBrowser browser = PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser();
                browser.openURL(url);
            }
            catch (MalformedURLException | PartInitException e1) {
                PMDPlugin.getDefault().logError(e1.getMessage(), e1);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }
}

