/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.model;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.PMDRuntimeConstants;
import net.sourceforge.pmd.eclipse.runtime.builder.MarkerUtil;
import net.sourceforge.pmd.eclipse.ui.model.AbstractPMDRecord;
import net.sourceforge.pmd.eclipse.ui.model.FolderRecord;
import net.sourceforge.pmd.eclipse.ui.model.MarkerRecord;
import net.sourceforge.pmd.eclipse.ui.model.PackageRecord;
import net.sourceforge.pmd.eclipse.ui.model.RepositoryUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class FileRecord
extends AbstractPMDRecord {
    private AbstractPMDRecord[] children;
    private final IResource resource;
    private final AbstractPMDRecord parent;
    private int numberOfLOC;
    private int numberOfMethods;

    public FileRecord(IResource javaResource) {
        if (javaResource == null) {
            throw new IllegalArgumentException("javaResource cannot be null");
        }
        this.resource = javaResource;
        this.parent = null;
        this.numberOfLOC = 0;
        this.numberOfMethods = 0;
        this.children = this.createChildren();
    }

    public FileRecord(IResource javaResource, PackageRecord record) {
        if (javaResource == null) {
            throw new IllegalArgumentException("javaResource cannot be null");
        }
        this.resource = javaResource;
        this.parent = record;
        this.numberOfLOC = 0;
        this.numberOfMethods = 0;
        this.children = this.createChildren();
    }

    public FileRecord(IResource resource, FolderRecord record) {
        if (resource == null) {
            throw new IllegalArgumentException("resource cannot be null");
        }
        this.resource = resource;
        this.parent = record;
        this.numberOfLOC = 0;
        this.numberOfMethods = 0;
        this.children = this.createChildren();
    }

    public long getTimestamp() {
        return this.resource.getLocalTimeStamp();
    }

    @Override
    public AbstractPMDRecord getParent() {
        return this.parent;
    }

    @Override
    public AbstractPMDRecord[] getChildren() {
        return this.children;
    }

    @Override
    public IResource getResource() {
        return this.resource;
    }

    public void updateChildren() {
        this.children = this.createChildren();
    }

    @Override
    protected final AbstractPMDRecord[] createChildren() {
        AbstractPMDRecord[] children = EMPTY_RECORDS;
        try {
            List<IMarker> markers = Arrays.asList(this.findMarkers());
            if (markers.isEmpty()) {
                return EMPTY_RECORDS;
            }
            Iterator<IMarker> markerIterator = markers.iterator();
            HashMap<String, MarkerRecord> allMarkerMap = new HashMap<String, MarkerRecord>();
            while (markerIterator.hasNext()) {
                IMarker marker = markerIterator.next();
                MarkerRecord markerRecord = (MarkerRecord)allMarkerMap.get(MarkerUtil.ruleNameFor(marker));
                if (markerRecord == null) {
                    String ruleName = MarkerUtil.ruleNameFor(marker);
                    markerRecord = new MarkerRecord(this, ruleName, MarkerUtil.rulePriorityFor(marker));
                    markerRecord.addViolation(marker);
                    allMarkerMap.put(ruleName, markerRecord);
                    continue;
                }
                markerRecord.addViolation(marker);
            }
            children = allMarkerMap.values().toArray(new MarkerRecord[0]);
        }
        catch (CoreException e) {
            PMDPlugin.getDefault().logError("message.error.core_exception" + this.toString(), e);
        }
        return children;
    }

    @Override
    public boolean hasMarkers() {
        IMarker[] markers = this.findMarkers();
        return markers != null && markers.length > 0;
    }

    @Override
    public final IMarker[] findMarkers() {
        try {
            if (this.resource.isAccessible()) {
                return MarkerUtil.findMarkers(this.resource, PMDRuntimeConstants.RULE_MARKER_TYPES);
            }
        }
        catch (CoreException ce) {
            PMDPlugin.getDefault().logError("message.error.find_marker" + this.toString(), ce);
        }
        return MarkerUtil.EMPTY_MARKERS;
    }

    public IMarker[] findDFAMarkers() {
        try {
            if (this.resource.isAccessible()) {
                return MarkerUtil.findMarkers(this.resource, "net.sourceforge.pmd.eclipse.plugin.pmdDFAMarker");
            }
        }
        catch (CoreException ce) {
            PMDPlugin.getDefault().logError("message.error.find_marker" + this.toString(), ce);
        }
        return MarkerUtil.EMPTY_MARKERS;
    }

    @Override
    public IMarker[] findMarkersByAttribute(String attributeName, Object value) {
        IMarker[] markers = this.findMarkers();
        ArrayList<IMarker> attributeMarkers = new ArrayList<IMarker>();
        try {
            IMarker[] iMarkerArray = markers;
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                Object val = marker.getAttribute(attributeName);
                if (val != null && val.equals(value)) {
                    attributeMarkers.add(marker);
                }
                ++n2;
            }
        }
        catch (CoreException ce) {
            PMDPlugin.getDefault().logError("message.error.find_marker" + this.toString(), ce);
        }
        return attributeMarkers.toArray(new IMarker[0]);
    }

    public void calculateLinesOfCode() {
        if (this.resource.isAccessible()) {
            String source = this.resourceToString(this.resource);
            this.numberOfLOC = FileRecord.linesOfCodeIn(source, true);
        }
    }

    public static int linesOfCodeIn(String source, boolean ignoreSingleBrackets) {
        int loc = 0;
        int firstCurly = source.indexOf(123);
        if (firstCurly != -1) {
            String body = source.substring(firstCurly + 1, source.length() - 1).trim();
            StringTokenizer lines = new StringTokenizer(body, "\n");
            while (lines.hasMoreTokens()) {
                String trimmed = lines.nextToken().trim();
                if (trimmed.length() > 0 && trimmed.startsWith("/*")) {
                    while (trimmed.indexOf("*/") == -1) {
                        trimmed = lines.nextToken().trim();
                    }
                    if (lines.hasMoreTokens()) {
                        trimmed = lines.nextToken().trim();
                    }
                }
                if (ignoreSingleBrackets && ("{".equals(trimmed) || "}".equals(trimmed)) || trimmed.startsWith("//")) continue;
                ++loc;
            }
        }
        return loc;
    }

    @Override
    public int getLOC() {
        return this.numberOfLOC;
    }

    protected String resourceToString(IResource resource) {
        StringBuilder fileContents = new StringBuilder();
        IFile file = (IFile)resource.getAdapter(IFile.class);
        try {
            Throwable throwable = null;
            Object var5_8 = null;
            try (BufferedReader bReader = new BufferedReader(new InputStreamReader(file.getContents(), file.getCharset()));){
                while (bReader.ready()) {
                    fileContents.append(bReader.readLine()).append('\n');
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (CoreException e) {
            PMDPlugin.getDefault().logError("message.error.file_not_found" + resource.toString() + " in " + this.toString(), e);
        }
        catch (IOException ioe) {
            PMDPlugin.getDefault().logError("message.error.io_exception" + this.toString(), ioe);
        }
        return fileContents.toString();
    }

    public void calculateNumberOfMethods() {
        if (this.resource.isAccessible()) {
            IJavaElement element = JavaCore.create((IResource)this.resource);
            ArrayList<IMethod> methods = new ArrayList<IMethod>();
            if (element instanceof ICompilationUnit) {
                try {
                    IType[] types;
                    IType[] iTypeArray = types = ((ICompilationUnit)element).getTypes();
                    int n = types.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IType type = iTypeArray[n2];
                        methods.addAll(Arrays.asList(type.getMethods()));
                        ++n2;
                    }
                }
                catch (JavaModelException jme) {
                    PMDPlugin.getDefault().logError("message.error.javamodel_exception" + this.toString(), jme);
                }
            }
            if (!methods.isEmpty()) {
                this.numberOfMethods = methods.size();
            }
        }
    }

    @Override
    public int getNumberOfMethods() {
        return this.numberOfMethods;
    }

    @Override
    public AbstractPMDRecord addResource(IResource resource) {
        return null;
    }

    @Override
    public AbstractPMDRecord removeResource(IResource resource) {
        return null;
    }

    @Override
    public String getName() {
        return this.resource.getName();
    }

    public String authorName() {
        return RepositoryUtil.hasRepositoryAccess() ? RepositoryUtil.authorNameFor(this.resource) : null;
    }

    @Override
    public int getResourceType() {
        return 1;
    }

    @Override
    public int getNumberOfViolationsToPriority(int prio, boolean invertMarkerAndFileRecords) {
        int number = 0;
        AbstractPMDRecord[] abstractPMDRecordArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractPMDRecord element = abstractPMDRecordArray[n2];
            number += element.getNumberOfViolationsToPriority(prio, false);
            ++n2;
        }
        return number;
    }
}

