/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.model;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.eclipse.ui.model.AbstractPMDRecord;
import net.sourceforge.pmd.eclipse.ui.model.FileRecord;
import net.sourceforge.pmd.eclipse.ui.model.FileToMarkerRecord;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;

public class MarkerRecord
extends AbstractPMDRecord {
    private AbstractPMDRecord[] children;
    private final FileRecord parent;
    private final String ruleName;
    private final int priority;
    private final List<IMarker> markers;

    public MarkerRecord(FileRecord parent, String ruleName, int priority) {
        this.parent = parent;
        this.ruleName = ruleName;
        this.priority = priority;
        this.markers = new ArrayList<IMarker>();
        this.children = EMPTY_RECORDS;
    }

    public void addViolation(IMarker marker) {
        this.markers.add(marker);
    }

    public int getViolationsCounted() {
        return this.markers.size();
    }

    @Override
    public AbstractPMDRecord addResource(IResource resource) {
        return null;
    }

    public void updateChildren() {
        this.children = this.createChildren();
    }

    @Override
    public final AbstractPMDRecord[] createChildren() {
        ArrayList<FileToMarkerRecord> children = new ArrayList<FileToMarkerRecord>();
        List<AbstractPMDRecord> markers = this.parent.getParent().findResourcesByName(this.ruleName, 16);
        for (MarkerRecord markerRecord : markers) {
            children.add(new FileToMarkerRecord(markerRecord));
        }
        return children.toArray(new AbstractPMDRecord[0]);
    }

    @Override
    public AbstractPMDRecord[] getChildren() {
        return this.children;
    }

    @Override
    public String getName() {
        return this.ruleName;
    }

    public int getPriority() {
        return this.priority;
    }

    @Override
    public AbstractPMDRecord getParent() {
        return this.parent;
    }

    @Override
    public IResource getResource() {
        return this.parent.getResource();
    }

    @Override
    public int getResourceType() {
        return 16;
    }

    @Override
    public AbstractPMDRecord removeResource(IResource resource) {
        return null;
    }

    @Override
    public boolean hasMarkers() {
        return !this.markers.isEmpty();
    }

    @Override
    public IMarker[] findMarkers() {
        return this.markers.toArray(new IMarker[0]);
    }

    @Override
    public int getNumberOfViolationsToPriority(int prio, boolean invertMarkerAndFileRecords) {
        int number = 0;
        if (prio == this.priority) {
            if (invertMarkerAndFileRecords) {
                AbstractPMDRecord[] abstractPMDRecordArray = this.children;
                int n = this.children.length;
                int n2 = 0;
                while (n2 < n) {
                    AbstractPMDRecord element = abstractPMDRecordArray[n2];
                    number += element.getNumberOfViolationsToPriority(prio, false);
                    ++n2;
                }
            } else {
                number = this.getViolationsCounted();
            }
        }
        return number;
    }

    @Override
    public int getLOC() {
        return this.parent.getLOC();
    }

    @Override
    public int getNumberOfMethods() {
        return this.parent.getNumberOfMethods();
    }
}

