/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.model;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.ui.model.AbstractPMDRecord;
import net.sourceforge.pmd.eclipse.ui.model.FileRecord;
import net.sourceforge.pmd.eclipse.ui.model.ProjectRecord;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;

public class PackageRecord
extends AbstractPMDRecord {
    private final IPackageFragment packageFragment;
    private final ProjectRecord parent;
    private AbstractPMDRecord[] children;

    public PackageRecord(IPackageFragment fragment, ProjectRecord record) {
        if (fragment == null) {
            throw new IllegalArgumentException("fragment cannot be null");
        }
        if (record == null) {
            throw new IllegalArgumentException("record cannot be null");
        }
        this.packageFragment = fragment;
        this.parent = record;
        this.children = this.createChildren();
    }

    @Override
    public AbstractPMDRecord getParent() {
        return this.parent;
    }

    @Override
    public AbstractPMDRecord[] getChildren() {
        return this.children;
    }

    @Override
    public IResource getResource() {
        IResource resource = null;
        try {
            resource = this.packageFragment.getCorrespondingResource();
        }
        catch (JavaModelException jme) {
            PMDPlugin.getDefault().logError("message.error.javamodel_exception" + this.toString(), jme);
        }
        return resource;
    }

    public IPackageFragment getFragment() {
        return this.packageFragment;
    }

    @Override
    protected final AbstractPMDRecord[] createChildren() {
        ArrayList<FileRecord> fileList = new ArrayList<FileRecord>();
        try {
            ICompilationUnit[] javaUnits;
            ICompilationUnit[] iCompilationUnitArray = javaUnits = this.packageFragment.getCompilationUnits();
            int n = javaUnits.length;
            int n2 = 0;
            while (n2 < n) {
                ICompilationUnit javaUnit = iCompilationUnitArray[n2];
                IResource javaResource = javaUnit.getCorrespondingResource();
                if (javaResource != null) {
                    fileList.add(new FileRecord(javaResource, this));
                }
                ++n2;
            }
        }
        catch (CoreException ce) {
            PMDPlugin.getDefault().logError("message.error.core_exception" + this.toString(), ce);
        }
        return fileList.toArray(new AbstractPMDRecord[0]);
    }

    @Override
    public AbstractPMDRecord addResource(IResource resource) {
        FileRecord file = new FileRecord(resource, this);
        List<AbstractPMDRecord> files = this.getChildrenAsList();
        files.add(file);
        this.children = new AbstractPMDRecord[files.size()];
        files.toArray(this.children);
        return file;
    }

    @Override
    public AbstractPMDRecord removeResource(IResource resource) {
        List<AbstractPMDRecord> files = this.getChildrenAsList();
        AbstractPMDRecord removedFile = null;
        boolean removed = false;
        int i = 0;
        while (i < files.size() && !removed) {
            AbstractPMDRecord file = files.get(i);
            if (file.getResource().equals((Object)resource)) {
                files.remove(i);
                this.children = new AbstractPMDRecord[files.size()];
                files.toArray(this.children);
                removed = true;
                removedFile = file;
            }
            ++i;
        }
        return removedFile;
    }

    @Override
    public String getName() {
        String name = this.packageFragment.getElementName();
        if (this.packageFragment.isDefaultPackage()) {
            name = PMDPlugin.getDefault().getStringTable().getString("view.default_package");
        }
        return name;
    }

    @Override
    public int getResourceType() {
        return 2;
    }

    public boolean equals(Object obj) {
        return obj instanceof PackageRecord && this.packageFragment.equals(((PackageRecord)obj).packageFragment);
    }

    public int hashCode() {
        return this.packageFragment.hashCode();
    }

    @Override
    public int getNumberOfViolationsToPriority(int prio, boolean invertMarkerAndFileRecords) {
        int number = 0;
        AbstractPMDRecord[] abstractPMDRecordArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractPMDRecord element = abstractPMDRecordArray[n2];
            number += element.getNumberOfViolationsToPriority(prio, false);
            ++n2;
        }
        return number;
    }

    @Override
    public int getLOC() {
        int number = 0;
        AbstractPMDRecord[] abstractPMDRecordArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractPMDRecord element = abstractPMDRecordArray[n2];
            number += element.getLOC();
            ++n2;
        }
        return number;
    }

    @Override
    public int getNumberOfMethods() {
        int number = 0;
        AbstractPMDRecord[] abstractPMDRecordArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractPMDRecord element = abstractPMDRecordArray[n2];
            number += element.getNumberOfMethods();
            ++n2;
        }
        return number;
    }
}

