/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.model;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.history.IFileHistoryProvider;
import org.eclipse.team.core.history.IFileRevision;

public final class RepositoryUtil {
    private static Boolean hasRepositoryAccess;

    private RepositoryUtil() {
    }

    public static boolean hasRepositoryAccess() {
        if (hasRepositoryAccess != null) {
            return hasRepositoryAccess;
        }
        try {
            Class.forName("org.eclipse.team.core.RepositoryProvider");
            hasRepositoryAccess = Boolean.TRUE;
        }
        catch (ClassNotFoundException classNotFoundException) {
            hasRepositoryAccess = Boolean.FALSE;
        }
        return hasRepositoryAccess;
    }

    public static String authorNameFor(IResource resource) {
        IFileHistoryProvider fhProvider;
        String authorName;
        block5: {
            RepositoryProvider provider;
            block4: {
                IProject project = resource.getProject();
                authorName = null;
                provider = RepositoryProvider.getProvider((IProject)project);
                if (provider != null) break block4;
                return null;
            }
            fhProvider = provider.getFileHistoryProvider();
            if (fhProvider != null) break block5;
            return null;
        }
        try {
            IFileRevision revision = fhProvider.getWorkspaceFileRevision(resource);
            authorName = revision.getAuthor();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return authorName;
    }
}

