/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.PMDVersion;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.plugin.UISettings;
import net.sourceforge.pmd.eclipse.runtime.builder.MarkerUtil;
import net.sourceforge.pmd.eclipse.runtime.preferences.IPreferences;
import net.sourceforge.pmd.eclipse.ui.BasicTableLabelProvider;
import net.sourceforge.pmd.eclipse.ui.Shape;
import net.sourceforge.pmd.eclipse.ui.ShapePicker;
import net.sourceforge.pmd.eclipse.ui.model.RootRecord;
import net.sourceforge.pmd.eclipse.ui.preferences.AbstractStructuredContentProvider;
import net.sourceforge.pmd.eclipse.ui.preferences.IconSelector;
import net.sourceforge.pmd.eclipse.ui.preferences.br.BasicTableManager;
import net.sourceforge.pmd.eclipse.ui.priority.PriorityColumnUI;
import net.sourceforge.pmd.eclipse.ui.priority.PriorityDescriptor;
import net.sourceforge.pmd.eclipse.ui.priority.PriorityDescriptorCache;
import net.sourceforge.pmd.eclipse.ui.priority.PriorityDescriptorIcon;
import net.sourceforge.pmd.lang.rule.RulePriority;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class GeneralPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String[] LOG_LEVELS = new String[]{"OFF", "FATAL", "ERROR", "WARN", "INFO", "DEBUG", "ALL"};
    private static final RGB SHAPE_COLOR = new RGB(255, 255, 255);
    private Text additionalCommentText;
    private Label sampleLabel;
    private Button showPerspectiveBox;
    private Button showViolationsOverviewViewBox;
    private Button showViolationsOutlineViewBox;
    private Button useProjectBuildPath;
    private Button checkCodeOnSave;
    private Button useCustomPriorityNames;
    private Button reviewPmdStyleBox;
    private Text logFileNameText;
    private Scale logLevelScale;
    private Label logLevelValueLabel;
    private TableViewer tableViewer;
    private IPreferences preferences;
    private BasicTableManager<?> priorityTableMgr;
    private Button determineFiletypesAutomatically;
    private Control[] nameFields;

    public void init(IWorkbench arg0) {
        this.preferences = PMDPlugin.getDefault().loadPreferences();
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.verticalSpacing = 10;
        composite.setLayout((Layout)layout);
        Group generalGroup = this.buildGeneralGroup(composite);
        Group priorityGroup = this.buildPriorityGroup(composite);
        Group reviewGroup = this.buildReviewGroup(composite);
        Group logGroup = this.buildLoggingGroup(composite);
        Group aboutGroup = this.buildAboutGroup(composite);
        generalGroup.setLayoutData((Object)new GridData(768));
        priorityGroup.setLayoutData((Object)new GridData(768));
        logGroup.setLayoutData((Object)new GridData(768));
        aboutGroup.setLayoutData((Object)new GridData(768));
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        reviewGroup.setLayoutData((Object)data);
        return composite;
    }

    private Group buildGeneralGroup(Composite parent) {
        Group group = new Group(parent, 4);
        group.setText(this.getMessage("preference.pmd.group.general"));
        group.setLayout((Layout)new GridLayout(1, false));
        this.showPerspectiveBox = this.buildShowPerspectiveBoxButton((Composite)group);
        this.showViolationsOverviewViewBox = this.buildShowViolationOverviewBoxButton((Composite)group);
        this.showViolationsOutlineViewBox = this.buildShowViolationOutlineBoxButton((Composite)group);
        this.useProjectBuildPath = this.buildUseProjectBuildPathButton((Composite)group);
        this.checkCodeOnSave = this.buildCheckCodeOnSaveButton((Composite)group);
        this.determineFiletypesAutomatically = this.buildDetermineFiletypesAutomatically((Composite)group);
        Label separator = new Label((Composite)group, 262);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.showPerspectiveBox.setLayoutData((Object)data);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.showViolationsOverviewViewBox.setLayoutData((Object)data);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.showViolationsOutlineViewBox.setLayoutData((Object)data);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.useProjectBuildPath.setLayoutData((Object)data);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        separator.setLayoutData((Object)data);
        return group;
    }

    private Link createPreferenceLink(Composite parent, String label, final String prefPageId) {
        Link link = new Link(parent, 0);
        link.setText(label);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                PreferenceDialog pref = PreferencesUtil.createPreferenceDialogOn((Shell)GeneralPreferencesPage.this.getShell(), (String)prefPageId, (String[])new String[0], null);
                if (pref != null) {
                    pref.open();
                }
            }
        });
        return link;
    }

    private void useCustomPriorityNames(boolean flag) {
        this.priorityTableMgr.visible(PriorityColumnUI.NAME, flag);
        this.priorityTableMgr.visible(PriorityColumnUI.PMD_NAME, !flag);
        UISettings.useCustomPriorityLabels(flag);
        Control[] controlArray = this.nameFields;
        int n = this.nameFields.length;
        int n2 = 0;
        while (n2 < n) {
            Control field = controlArray[n2];
            field.setEnabled(flag);
            ++n2;
        }
    }

    private Group buildPriorityGroup(Composite parent) {
        Group group = new Group(parent, 4);
        group.setText(this.getMessage("preference.pmd.group.priorities"));
        group.setLayout((Layout)new GridLayout(2, false));
        Link link = this.createPreferenceLink((Composite)group, "PMD folder annotations can be enabled on the <A>label decorations</A> page", "org.eclipse.ui.preferencePages.Decorators");
        link.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        this.useCustomPriorityNames = this.buildUseCustomPriorityNamesButton((Composite)group);
        this.useCustomPriorityNames.setLayoutData((Object)new GridData(3, 2, false, false, 1, 1));
        AbstractStructuredContentProvider contentProvider = new AbstractStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return (RulePriority[])inputElement;
            }
        };
        BasicTableLabelProvider labelProvider = new BasicTableLabelProvider(PriorityColumnUI.VISIBLE_COLUMNS);
        this.priorityTableMgr = new BasicTableManager("prio", null, PriorityColumnUI.VISIBLE_COLUMNS);
        this.tableViewer = this.priorityTableMgr.buildTableViewer((Composite)group);
        this.priorityTableMgr.setupColumns(PriorityColumnUI.VISIBLE_COLUMNS);
        Table table = this.tableViewer.getTable();
        table.setLayoutData((Object)new GridData(4, 2, true, true, 2, 1));
        this.tableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.tableViewer.setContentProvider((IContentProvider)contentProvider);
        table.setHeaderVisible(true);
        this.tableViewer.setInput((Object)UISettings.currentPriorities(true));
        Composite editorPanel = new Composite((Composite)group, 0);
        editorPanel.setLayoutData((Object)new GridData(4, 2, true, true, 2, 1));
        editorPanel.setLayout((Layout)new GridLayout(3, false));
        Label shapeLabel = new Label(editorPanel, 0);
        shapeLabel.setLayoutData((Object)new GridData());
        shapeLabel.setText("Shape and Color:");
        final ShapePicker ssc = new ShapePicker(editorPanel, 0, 14);
        ssc.setLayoutData(new GridData(16384, 0x1000000, true, false, 1, 1));
        ssc.setSize(280, 30);
        ssc.setShapeMap(UISettings.shapeSet(SHAPE_COLOR, 10));
        ssc.setItems(UISettings.allShapes());
        final ColorSelector colorPicker = new ColorSelector(editorPanel);
        new Label(editorPanel, 0).setText("Icon:");
        final IconSelector iconSelector = new IconSelector(editorPanel);
        iconSelector.setLayoutData(new GridData(16384, 2, true, true, 2, 1));
        Label nameLabel = new Label(editorPanel, 0);
        nameLabel.setLayoutData((Object)new GridData());
        nameLabel.setText("Name:");
        final Text priorityName = new Text(editorPanel, 2048);
        priorityName.setLayoutData((Object)new GridData(4, 2, true, true, 2, 1));
        this.nameFields = new Control[]{nameLabel, priorityName};
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                GeneralPreferencesPage.selectedPriorities(selection.toList(), ssc, colorPicker, priorityName, iconSelector);
            }
        });
        ssc.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (!selection.isEmpty()) {
                    GeneralPreferencesPage.this.setShape((Shape)((Object)selection.getFirstElement()));
                    iconSelector.setSelectedIcon(null);
                }
            }
        });
        iconSelector.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getNewValue() != null) {
                    ssc.removeSelection();
                    PriorityDescriptor[] priorityDescriptorArray = GeneralPreferencesPage.this.selectedDescriptors();
                    int n = priorityDescriptorArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        PriorityDescriptor pd = priorityDescriptorArray[n2];
                        pd.iconId = ((PriorityDescriptorIcon)event.getNewValue()).getIconId();
                        ++n2;
                    }
                    GeneralPreferencesPage.this.tableViewer.refresh();
                }
            }
        });
        colorPicker.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                GeneralPreferencesPage.this.setColor((RGB)event.getNewValue());
            }
        });
        priorityName.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                GeneralPreferencesPage.this.setName(priorityName.getText());
            }
        });
        this.useCustomPriorityNames.setSelection(this.preferences.useCustomPriorityNames());
        return group;
    }

    private void setShape(Shape shape) {
        if (shape == null) {
            return;
        }
        PriorityDescriptor[] priorityDescriptorArray = this.selectedDescriptors();
        int n = priorityDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            PriorityDescriptor pd = priorityDescriptorArray[n2];
            pd.shape.shape = shape;
            pd.iconId = null;
            ++n2;
        }
        this.tableViewer.refresh();
    }

    private void setColor(RGB clr) {
        PriorityDescriptor[] priorityDescriptorArray = this.selectedDescriptors();
        int n = priorityDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            PriorityDescriptor pd = priorityDescriptorArray[n2];
            pd.shape.rgbColor = clr;
            ++n2;
        }
        this.tableViewer.refresh();
    }

    private void setName(String newName) {
        if (StringUtils.isBlank((CharSequence)newName)) {
            return;
        }
        PriorityDescriptor[] priorityDescriptorArray = this.selectedDescriptors();
        int n = priorityDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            PriorityDescriptor pd = priorityDescriptorArray[n2];
            pd.label = newName;
            ++n2;
        }
        this.tableViewer.refresh();
    }

    private PriorityDescriptor[] selectedDescriptors() {
        Object[] items = ((IStructuredSelection)this.tableViewer.getSelection()).toArray();
        PriorityDescriptor[] descs = new PriorityDescriptor[items.length];
        int i = 0;
        while (i < descs.length) {
            descs[i] = PriorityDescriptorCache.INSTANCE.descriptorFor((RulePriority)items[i]);
            ++i;
        }
        return descs;
    }

    private static void selectedPriorities(List<RulePriority> items, ShapePicker<Shape> ssc, ColorSelector colorPicker, Text nameField, IconSelector iconSelector) {
        if (items.size() != 1) {
            ssc.setSelection((Shape)((Object)null));
            nameField.setText("");
            return;
        }
        RulePriority priority = items.get(0);
        PriorityDescriptor desc = PriorityDescriptorCache.INSTANCE.descriptorFor(priority);
        nameField.setText(desc.label);
        colorPicker.setColorValue(desc.shape.rgbColor);
        if (desc.iconId == null) {
            ssc.setSelection(desc.shape.shape);
        } else {
            ssc.removeSelection();
        }
        iconSelector.setSelectedIcon(PriorityDescriptorIcon.getById(desc.iconId));
    }

    private Group buildReviewGroup(Composite parent) {
        Group group = new Group(parent, 4);
        group.setText(this.getMessage("preference.pmd.group.review"));
        group.setLayout((Layout)new GridLayout(1, false));
        this.reviewPmdStyleBox = this.buildReviewPmdStyleBoxButton((Composite)group);
        Label separator = new Label((Composite)group, 262);
        this.buildLabel((Composite)group, "preference.pmd.label.addcomment");
        this.additionalCommentText = this.buildAdditionalCommentText((Composite)group);
        this.buildLabel((Composite)group, "preference.pmd.label.sample");
        this.sampleLabel = this.buildSampleLabel((Composite)group);
        this.updateSampleLabel();
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.reviewPmdStyleBox.setLayoutData((Object)data);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        separator.setLayoutData((Object)data);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.additionalCommentText.setLayoutData((Object)data);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.sampleLabel.setLayoutData((Object)data);
        return group;
    }

    private Group buildLoggingGroup(Composite parent) {
        GridData gridData2 = new GridData();
        gridData2.horizontalSpan = 2;
        gridData2.horizontalAlignment = 4;
        GridData gridData11 = new GridData();
        gridData11.horizontalAlignment = 4;
        gridData11.horizontalSpan = 3;
        GridData gridData3 = new GridData();
        gridData3.horizontalAlignment = 4;
        gridData3.horizontalSpan = 3;
        GridData gridData1 = new GridData();
        gridData1.grabExcessHorizontalSpace = true;
        gridData1.horizontalAlignment = 4;
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        Group loggingGroup = new Group(parent, 0);
        loggingGroup.setText(this.getMessage("preference.pmd.group.logging"));
        loggingGroup.setLayout((Layout)gridLayout);
        Label logFileNameLabel = new Label((Composite)loggingGroup, 0);
        logFileNameLabel.setText(this.getMessage("preference.pmd.label.log_file_name"));
        logFileNameLabel.setLayoutData((Object)gridData);
        this.logFileNameText = new Text((Composite)loggingGroup, 2048);
        this.logFileNameText.setText(this.preferences.getLogFileName());
        this.logFileNameText.setToolTipText(this.getMessage("preference.pmd.tooltip.log_file_name"));
        this.logFileNameText.setLayoutData((Object)gridData1);
        Button browseButton = new Button((Composite)loggingGroup, 0);
        browseButton.setText(this.getMessage("preference.pmd.button.browse"));
        browseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                GeneralPreferencesPage.this.browseLogFile();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        Label separator = new Label((Composite)loggingGroup, 258);
        separator.setLayoutData((Object)gridData11);
        Label logLevelLabel = new Label((Composite)loggingGroup, 0);
        logLevelLabel.setText(this.getMessage("preference.pmd.label.log_level"));
        this.logLevelValueLabel = new Label((Composite)loggingGroup, 0);
        this.logLevelValueLabel.setText("");
        this.logLevelValueLabel.setLayoutData((Object)gridData2);
        this.logLevelScale = new Scale((Composite)loggingGroup, 0);
        this.logLevelScale.setMaximum(6);
        this.logLevelScale.setPageIncrement(1);
        this.logLevelScale.setLayoutData((Object)gridData3);
        this.logLevelScale.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                GeneralPreferencesPage.this.updateLogLevelValueLabel();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                GeneralPreferencesPage.this.updateLogLevelValueLabel();
            }
        });
        this.logLevelScale.setSelection(this.intLogLevel(this.preferences.getLogLevelName()));
        this.updateLogLevelValueLabel();
        return loggingGroup;
    }

    private Group buildAboutGroup(Composite parent) {
        GridData gridData1 = new GridData();
        gridData1.grabExcessHorizontalSpace = false;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        Group aboutGroup = new Group(parent, 0);
        aboutGroup.setText(this.getMessage("preference.pmd.group.about"));
        aboutGroup.setLayout((Layout)gridLayout);
        StringBuilder aboutText = new StringBuilder();
        aboutText.append(this.getMessage("preference.pmd.label.pmd.eclipse.version")).append(" ").append(PMDPlugin.version).append("\n");
        aboutText.append(this.getMessage("preference.pmd.label.pmd.version")).append(" ").append(PMDVersion.VERSION).append("\n");
        Label aboutLabel = new Label((Composite)aboutGroup, 0);
        aboutLabel.setText(aboutText.toString());
        aboutLabel.setLayoutData((Object)gridData1);
        return aboutGroup;
    }

    private Label buildLabel(Composite parent, String msgKey) {
        Label label = new Label(parent, 0);
        label.setText(msgKey == null ? "" : this.getMessage(msgKey));
        return label;
    }

    private Label buildSampleLabel(Composite parent) {
        return new Label(parent, 64);
    }

    private Text buildAdditionalCommentText(Composite parent) {
        Text text = new Text(parent, 2052);
        text.setText(this.preferences.getReviewAdditionalComment());
        text.setToolTipText(this.getMessage("preference.pmd.tooltip.addcomment"));
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GeneralPreferencesPage.this.updateSampleLabel();
            }
        });
        return text;
    }

    private Button buildUseCustomPriorityNamesButton(Composite parent) {
        Button button = new Button(parent, 32);
        button.setLayoutData((Object)new GridData(3, 2, false, false, 1, 1));
        button.setText("Use custom names");
        button.setSelection(this.preferences.useCustomPriorityNames());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                GeneralPreferencesPage.this.useCustomPriorityNames(((Button)se.getSource()).getSelection());
            }
        });
        return button;
    }

    private Button buildCheckCodeOnSaveButton(Composite viewGroup) {
        Button button = new Button(viewGroup, 32);
        button.setText(this.getMessage("preference.pmd.label.check_after_saving"));
        button.setSelection(this.preferences.isCheckAfterSaveEnabled());
        return button;
    }

    private Button buildShowPerspectiveBoxButton(Composite viewGroup) {
        Button button = new Button(viewGroup, 32);
        button.setText(this.getMessage("preference.pmd.label.perspective_on_check"));
        button.setSelection(this.preferences.isPmdPerspectiveEnabled());
        return button;
    }

    private Button buildShowViolationOverviewBoxButton(Composite viewGroup) {
        Button button = new Button(viewGroup, 32);
        button.setText(this.getMessage("preference.pmd.label.violationsoverview_on_check"));
        button.setSelection(this.preferences.isPmdViolationsOverviewEnabled());
        return button;
    }

    private Button buildShowViolationOutlineBoxButton(Composite viewGroup) {
        Button button = new Button(viewGroup, 32);
        button.setText(this.getMessage("preference.pmd.label.violationsoutline_on_check"));
        button.setSelection(this.preferences.isPmdViolationsOutlineEnabled());
        return button;
    }

    private Button buildUseProjectBuildPathButton(Composite viewGroup) {
        Button button = new Button(viewGroup, 32);
        button.setText(this.getMessage("preference.pmd.label.use_project_build_path"));
        button.setSelection(this.preferences.isProjectBuildPathEnabled());
        return button;
    }

    private Button buildDetermineFiletypesAutomatically(Composite viewGroup) {
        Button button = new Button(viewGroup, 32);
        button.setText(this.getMessage("preference.pmd.label.determine_filetypes_automatically"));
        button.setSelection(this.preferences.isDetermineFiletypesAutomatically());
        return button;
    }

    private Button buildReviewPmdStyleBoxButton(Composite parent) {
        Button button = new Button(parent, 32);
        button.setText(this.getMessage("preference.pmd.label.review_pmd_style"));
        button.setSelection(this.preferences.isReviewPmdStyleEnabled());
        return button;
    }

    public static void setSelection(Button button, boolean flag) {
        if (button == null || button.isDisposed()) {
            return;
        }
        button.setSelection(flag);
    }

    public static void setText(Text field, String txt) {
        if (field == null || field.isDisposed()) {
            return;
        }
        field.setText(txt);
    }

    protected void performDefaults() {
        RulePriority[] rulePriorityArray = RulePriority.values();
        int n = rulePriorityArray.length;
        int n2 = 0;
        while (n2 < n) {
            RulePriority priority = rulePriorityArray[n2];
            PriorityDescriptor defaultDescriptor = PMDPlugin.getDefault().getPreferencesManager().defaultDescriptorFor(priority);
            PriorityDescriptor descriptor = PriorityDescriptorCache.INSTANCE.descriptorFor(priority);
            descriptor.shape.shape = defaultDescriptor.shape.shape;
            descriptor.shape.rgbColor = defaultDescriptor.shape.rgbColor;
            descriptor.label = defaultDescriptor.label;
            descriptor.iconId = defaultDescriptor.iconId;
            ++n2;
        }
        this.tableViewer.refresh();
        GeneralPreferencesPage.setText(this.additionalCommentText, "by {0} on {1}");
        GeneralPreferencesPage.setSelection(this.showPerspectiveBox, true);
        GeneralPreferencesPage.setSelection(this.showViolationsOverviewViewBox, false);
        GeneralPreferencesPage.setSelection(this.showViolationsOutlineViewBox, false);
        GeneralPreferencesPage.setSelection(this.checkCodeOnSave, false);
        GeneralPreferencesPage.setSelection(this.useCustomPriorityNames, true);
        GeneralPreferencesPage.setSelection(this.useProjectBuildPath, true);
        GeneralPreferencesPage.setSelection(this.reviewPmdStyleBox, true);
        GeneralPreferencesPage.setSelection(this.determineFiletypesAutomatically, true);
        GeneralPreferencesPage.setText(this.logFileNameText, IPreferences.LOG_FILENAME_DEFAULT);
        if (this.logLevelScale != null) {
            this.logLevelScale.setSelection(this.intLogLevel("WARN"));
            this.updateLogLevelValueLabel();
        }
    }

    protected void updateSampleLabel() {
        String pattern = this.additionalCommentText.getText();
        try {
            String commentText = MessageFormat.format(pattern, System.getProperty("user.name", ""), new Date());
            this.sampleLabel.setText(commentText);
            this.setMessage(this.getMessage("preference.pmd.header"), 0);
            this.setValid(true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.setMessage(this.getMessage("preference.pmd.message.incorrect_format"), 3);
            this.setValid(false);
        }
    }

    protected void updateLogLevelValueLabel() {
        this.logLevelValueLabel.setText(LOG_LEVELS[this.logLevelScale.getSelection()]);
    }

    protected void browseLogFile() {
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        dialog.setText(this.getMessage("preference.pmd.dialog.browse"));
        String fileName = dialog.open();
        if (fileName != null) {
            this.logFileNameText.setText(fileName);
        }
    }

    private void updateMarkerIcons() {
        if (!PriorityDescriptorCache.INSTANCE.hasChanges()) {
            return;
        }
        PriorityDescriptorCache.INSTANCE.storeInPreferences();
        RootRecord root = new RootRecord(ResourcesPlugin.getWorkspace().getRoot());
        Set<IFile> files = MarkerUtil.allMarkedFiles(root);
        PMDPlugin.getDefault().changedFiles(files);
        PMDPlugin.getDefault().refreshView("net.sourceforge.pmd.eclipse.ui.views.violationOverview");
        PMDPlugin.getDefault().refreshView("net.sourceforge.pmd.eclipse.ui.views.violationOutline");
        ScopedPreferenceStore editorsPreferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.ui.editors");
        RulePriority[] rulePriorityArray = RulePriority.values();
        int n = rulePriorityArray.length;
        int n2 = 0;
        while (n2 < n) {
            RulePriority priority = rulePriorityArray[n2];
            PriorityDescriptor descriptor = PriorityDescriptorCache.INSTANCE.descriptorFor(priority);
            editorsPreferenceStore.setValue("net.sourceforge.pmd.eclipse.plugin.annotation.prio" + priority.getPriority() + ".color", String.valueOf(descriptor.shape.rgbColor.red) + "," + descriptor.shape.rgbColor.green + "," + descriptor.shape.rgbColor.blue);
            ++n2;
        }
    }

    public boolean performCancel() {
        PriorityDescriptorCache.INSTANCE.loadFromPreferences();
        return true;
    }

    public boolean performOk() {
        this.updateMarkerIcons();
        if (this.additionalCommentText != null) {
            this.preferences.setReviewAdditionalComment(this.additionalCommentText.getText());
        }
        if (this.showPerspectiveBox != null) {
            this.preferences.setPmdPerspectiveEnabled(this.showPerspectiveBox.getSelection());
        }
        if (this.showViolationsOverviewViewBox != null) {
            this.preferences.setPmdViolationsOverviewEnabled(this.showViolationsOverviewViewBox.getSelection());
        }
        if (this.showViolationsOutlineViewBox != null) {
            this.preferences.setPmdViolationsOutlineEnabled(this.showViolationsOutlineViewBox.getSelection());
        }
        if (this.checkCodeOnSave != null) {
            boolean doCheck = this.checkCodeOnSave.getSelection();
            this.preferences.isCheckAfterSaveEnabled(doCheck);
            PMDPlugin.getDefault().fileChangeListenerEnabled(doCheck);
        }
        if (this.useCustomPriorityNames != null) {
            this.preferences.useCustomPriorityNames(this.useCustomPriorityNames.getSelection());
        }
        if (this.useProjectBuildPath != null) {
            this.preferences.setProjectBuildPathEnabled(this.useProjectBuildPath.getSelection());
        }
        if (this.determineFiletypesAutomatically != null) {
            this.preferences.setDetermineFiletypesAutomatically(this.determineFiletypesAutomatically.getSelection());
        }
        if (this.reviewPmdStyleBox != null) {
            this.preferences.setReviewPmdStyleEnabled(this.reviewPmdStyleBox.getSelection());
        }
        if (this.logFileNameText != null) {
            this.preferences.setLogFileName(this.logFileNameText.getText());
        }
        if (this.logLevelScale != null) {
            this.preferences.setLogLevel(LOG_LEVELS[this.logLevelScale.getSelection()]);
        }
        this.preferences.sync();
        PMDPlugin.getDefault().applyLogPreferences(this.preferences);
        return true;
    }

    private int intLogLevel(String level) {
        int result = Arrays.asList(LOG_LEVELS).indexOf(level);
        if (result < 0 || result > 6) {
            result = 0;
        }
        return result;
    }

    private String getMessage(String key) {
        return PMDPlugin.getDefault().getStringTable().getString(key);
    }
}

