/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences;

import java.util.ArrayList;
import java.util.Objects;
import net.sourceforge.pmd.eclipse.ui.priority.PriorityDescriptorIcon;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class IconSelector {
    private Composite composite;
    private ListenerList<IPropertyChangeListener> listeners = new ListenerList();
    private PriorityDescriptorIcon selectedIcon;

    public IconSelector(Composite parent) {
        this.composite = new Composite(parent, 4);
        this.composite.setLayout((Layout)new FillLayout());
        final ArrayList<Button> buttonGroup = new ArrayList<Button>();
        PriorityDescriptorIcon[] priorityDescriptorIconArray = PriorityDescriptorIcon.ICONS;
        int n = PriorityDescriptorIcon.ICONS.length;
        int n2 = 0;
        while (n2 < n) {
            PriorityDescriptorIcon icon = priorityDescriptorIconArray[n2];
            Button button = new Button(this.composite, 2);
            button.setImage(icon.getImage());
            button.setData((Object)icon);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Button btn = (Button)e.widget;
                    if (btn.getSelection()) {
                        for (Button otherButton : buttonGroup) {
                            if (Objects.equals(otherButton, btn)) continue;
                            otherButton.setSelection(false);
                        }
                        IconSelector.this.setSelectedIcon((PriorityDescriptorIcon)btn.getData());
                    } else {
                        btn.setSelection(true);
                    }
                }
            });
            buttonGroup.add(button);
            ++n2;
        }
        this.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                PriorityDescriptorIcon icon = (PriorityDescriptorIcon)event.getNewValue();
                for (Button btn : buttonGroup) {
                    btn.setSelection(Objects.equals(btn.getData(), icon));
                }
            }
        });
    }

    public void setLayoutData(Object layoutData) {
        this.composite.setLayoutData(layoutData);
    }

    public void setSelectedIcon(PriorityDescriptorIcon icon) {
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "selectedIcon", (Object)this.selectedIcon, (Object)icon);
        this.selectedIcon = icon;
        for (IPropertyChangeListener listener : this.listeners) {
            listener.propertyChange(event);
        }
    }

    public PriorityDescriptorIcon getSelectedIcon() {
        return this.selectedIcon;
    }

    public void addListener(IPropertyChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(IPropertyChangeListener listener) {
        this.listeners.remove((Object)listener);
    }
}

