/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences.br;

import java.util.HashSet;
import java.util.Set;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.preferences.IPreferences;
import net.sourceforge.pmd.eclipse.runtime.preferences.impl.PreferenceUIStore;
import net.sourceforge.pmd.eclipse.ui.ColumnDescriptor;
import net.sourceforge.pmd.eclipse.ui.preferences.br.SortListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;

public abstract class AbstractTableManager<T>
implements SortListener {
    private final String widgetId;
    protected boolean sortDescending;
    protected TableColumn sortColumn;
    protected Object columnSorter;
    protected IPreferences preferences;
    protected Menu headerMenu;
    protected Menu tableMenu;
    protected final ColumnDescriptor[] availableColumns;
    private final Set<ColumnDescriptor> hiddenColumns = new HashSet<ColumnDescriptor>();
    protected static PMDPlugin plugin = PMDPlugin.getDefault();

    public AbstractTableManager(String theWidgetId, IPreferences thePreferences, ColumnDescriptor[] theColumns) {
        this.widgetId = theWidgetId;
        this.preferences = thePreferences;
        this.availableColumns = theColumns;
        this.loadHiddenColumns();
    }

    protected static ColumnWidthAdapter adapterFor(final TableColumn column) {
        return new ColumnWidthAdapter(){

            @Override
            public int width() {
                return column.getWidth();
            }

            @Override
            public void width(int newWidth) {
                column.setWidth(newWidth);
            }

            @Override
            public Display display() {
                return column.getDisplay();
            }

            @Override
            public void setData(String key, Object value) {
                column.setData(key, value);
            }

            @Override
            public Object getData(String key) {
                return column.getData(key);
            }
        };
    }

    protected abstract ColumnWidthAdapter columnAdapterFor(ColumnDescriptor var1);

    protected void setupMenusFor(final Control control) {
        final Display display = control.getDisplay();
        Shell shell = control.getShell();
        this.setupMenus(shell);
        control.addListener(35, new Listener(){

            public void handleEvent(Event event) {
                boolean isHeader;
                Point pt = display.map(null, control, new Point(event.x, event.y));
                Rectangle clientArea = AbstractTableManager.this.clientAreaFor(control);
                boolean bl = isHeader = clientArea.y <= pt.y && pt.y < clientArea.y + AbstractTableManager.this.headerHeightFor(control);
                if (!isHeader) {
                    AbstractTableManager.this.adjustTableMenuOptions();
                }
                AbstractTableManager.this.setMenu(control, isHeader ? AbstractTableManager.this.headerMenu : AbstractTableManager.this.tableMenu);
            }
        });
        this.addDisposeListener(control);
    }

    protected abstract Rectangle clientAreaFor(Control var1);

    protected abstract int headerHeightFor(Control var1);

    protected abstract void setMenu(Control var1, Menu var2);

    protected abstract void saveItemSelections();

    public void saveUIState() {
        this.saveItemSelections();
    }

    protected void setupMenus(Shell shell) {
        this.headerMenu = new Menu((Decorations)shell, 8);
        this.addHeaderSelectionOptions(this.headerMenu);
        this.tableMenu = new Menu((Decorations)shell, 8);
        this.addTableSelectionOptions(this.tableMenu);
    }

    public void setTableMenu(Menu tableMenu) {
        this.tableMenu = tableMenu;
    }

    protected void addDeleteListener(Control control) {
        control.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent ev) {
                if (ev.character == '\u007f') {
                    AbstractTableManager.this.removeSelectedItems();
                }
            }
        });
    }

    protected void addHeaderSelectionOptions(Menu menu) {
        ColumnDescriptor[] columnDescriptorArray = this.availableColumns;
        int n = this.availableColumns.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnDescriptor desc = columnDescriptorArray[n2];
            MenuItem columnItem = new MenuItem(menu, 32);
            columnItem.setSelection(!this.isHidden(desc));
            columnItem.setText(desc.label());
            final ColumnDescriptor columnDesc = desc;
            columnItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractTableManager.this.toggleColumnVisiblity(columnDesc);
                }
            });
            ++n2;
        }
    }

    protected abstract void removeSelectedItems();

    protected void addTableSelectionOptions(Menu menu) {
    }

    protected void adjustTableMenuOptions() {
    }

    protected void addDisposeListener(Control control) {
        control.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                AbstractTableManager.this.headerMenu.dispose();
                AbstractTableManager.this.tableMenu.dispose();
            }
        });
    }

    public void visible(ColumnDescriptor column, boolean show) {
        if (show) {
            this.show(column);
        } else {
            this.hide(column);
        }
    }

    protected void show(ColumnDescriptor desc) {
        this.hiddenColumns.remove(desc);
        ColumnWidthAdapter cwa = this.columnAdapterFor(desc);
        Object widthData = cwa.getData("restoredWidth");
        int width = widthData == null ? desc.defaultWidth() : ((Integer)widthData).intValue();
        WidthChangeThread t = new WidthChangeThread(0, width, cwa);
        t.start();
    }

    protected void hide(ColumnDescriptor desc) {
        this.hiddenColumns.add(desc);
        ColumnWidthAdapter cwa = this.columnAdapterFor(desc);
        cwa.setData("restoredWidth", cwa.width());
        WidthChangeThread t = new WidthChangeThread(cwa.width(), 0, cwa);
        t.start();
    }

    protected boolean isHidden(ColumnDescriptor desc) {
        return this.hiddenColumns.contains(desc);
    }

    protected boolean isActive(String item) {
        return this.preferences.isActive(item);
    }

    protected void isActive(String item, boolean flag) {
        this.preferences.isActive(item, flag);
    }

    protected void toggleColumnVisiblity(ColumnDescriptor desc) {
        if (this.hiddenColumns.contains(desc)) {
            this.show(desc);
        } else {
            this.hide(desc);
        }
        this.storeHiddenColumns();
    }

    @Override
    public void sortBy(Object accessor, Object context) {
        if (this.columnSorter == accessor) {
            this.sortDescending = !this.sortDescending;
        } else {
            this.columnSorter = accessor;
        }
        this.sortColumn = (TableColumn)context;
        this.redrawTable(this.idFor(context), this.getSortDirection());
    }

    public int getSortDirection() {
        return this.sortDescending ? 1024 : 128;
    }

    public void setSortDirection(TableColumn column, Object accessor, int direction) {
        if (column != null && accessor != null) {
            this.sortDescending = direction == 1024;
            this.sortColumn = column;
            this.columnSorter = accessor;
            this.redrawTable(this.idFor(this.sortColumn), direction);
        }
    }

    protected abstract String idFor(Object var1);

    protected abstract void redrawTable(String var1, int var2);

    private void storeHiddenColumns() {
        HashSet<String> columnIds = new HashSet<String>(this.hiddenColumns.size());
        for (ColumnDescriptor desc : this.hiddenColumns) {
            columnIds.add(desc.id());
        }
        PreferenceUIStore.INSTANCE.hiddenColumnIds(columnIds);
    }

    private void loadHiddenColumns() {
        for (String columnId : PreferenceUIStore.INSTANCE.hiddenColumnIds()) {
            ColumnDescriptor[] columnDescriptorArray = this.availableColumns;
            int n = this.availableColumns.length;
            int n2 = 0;
            while (n2 < n) {
                ColumnDescriptor desc = columnDescriptorArray[n2];
                if (desc.id().equals(columnId)) {
                    this.hiddenColumns.add(desc);
                }
                ++n2;
            }
        }
    }

    protected String getMessage(String key) {
        return PMDPlugin.getDefault().getStringTable().getString(key);
    }

    protected static interface ColumnWidthAdapter {
        public int width();

        public void width(int var1);

        public Display display();

        public void setData(String var1, Object var2);

        public Object getData(String var1);
    }

    protected static class WidthChangeThread
    extends Thread {
        private final int startWidth;
        private final int endWidth;
        private final ColumnWidthAdapter column;

        protected WidthChangeThread(int start, int end, ColumnWidthAdapter theColumn) {
            this.startWidth = start;
            this.endWidth = end;
            this.column = theColumn;
        }

        protected void setWidth(final int width) {
            this.column.display().syncExec(new Runnable(){

                @Override
                public void run() {
                    column.width(width);
                }
            });
        }

        @Override
        public void run() {
            if (this.endWidth > this.startWidth) {
                int i = this.startWidth;
                while (i <= this.endWidth) {
                    this.setWidth(i);
                    ++i;
                }
            } else {
                int i = this.startWidth;
                while (i >= this.endWidth) {
                    this.setWidth(i);
                    --i;
                }
            }
        }
    }
}

