/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences.br;

import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.eclipse.ui.IndexedString;
import net.sourceforge.pmd.eclipse.ui.preferences.br.AbstractRuleColumnDescriptor;
import net.sourceforge.pmd.eclipse.ui.preferences.br.BasicRuleFieldAccessor;
import net.sourceforge.pmd.eclipse.ui.preferences.br.CellPainterBuilder;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleCollection;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleFieldAccessor;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleUIUtil;
import net.sourceforge.pmd.eclipse.ui.preferences.br.SortListener;
import net.sourceforge.pmd.lang.rule.Rule;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class ImageColumnDescriptor
extends AbstractRuleColumnDescriptor {
    private final CellPainterBuilder painterBuilder;
    public static final RuleFieldAccessor PROPERTIES_ACCESSOR = new BasicRuleFieldAccessor(){

        @Override
        public String labelFor(Rule rule) {
            IndexedString value = this.valueFor(rule);
            return value == null ? "" : value.string;
        }

        public IndexedString valueFor(Rule rule) {
            return RuleUIUtil.indexedPropertyStringFrom(rule);
        }

        @Override
        public Comparable<?> valueFor(RuleCollection collection) {
            return IndexedString.EMPTY;
        }
    };

    public ImageColumnDescriptor(String theId, String labelKey, int theAlignment, int theWidth, RuleFieldAccessor theAccessor, boolean resizableFlag, String theImagePath, CellPainterBuilder thePainterBuilder) {
        super(theId, labelKey, theAlignment, theWidth, theAccessor, resizableFlag, theImagePath);
        this.painterBuilder = thePainterBuilder;
    }

    @Override
    public TreeColumn newTreeColumnFor(Tree parent, int columnIndex, SortListener sortListener, Map<Integer, List<Listener>> paintListeners) {
        TreeColumn tc = this.buildTreeColumn(parent, sortListener);
        this.setLabelIfImageMissing(tc);
        if (this.painterBuilder != null) {
            this.painterBuilder.addPainterFor(tc.getParent(), columnIndex, this.accessor(), paintListeners);
        }
        return tc;
    }

    @Override
    public String stringValueFor(Rule rule) {
        return "";
    }

    @Override
    public Image imageFor(Rule rule) {
        return null;
    }
}

